/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFVarDeclExpression
extends CFExpression {
    private static final long serialVersionUID = 1L;
    private String name;
    private CFExpression init;
    List<CFIdentifier> otherVars = new ArrayList<CFIdentifier>();
    List<CFIdentifier> otherIds = new ArrayList<CFIdentifier>();

    public List<CFIdentifier> getOtherVars() {
        return this.otherVars;
    }

    public List<CFIdentifier> getOtherIds() {
        return this.otherIds;
    }

    public CFVarDeclExpression(Token _t, CFIdentifier _var, CFExpression _init) {
        super(_t);
        this.name = _var.getName();
        this.init = _init;
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder s = new StringBuilder(this.Indent(indent));
        s.append("var ");
        s.append(this.name);
        for (CFIdentifier id : this.otherVars) {
            s.append(" = var ");
            s.append(id.Decompile(indent));
        }
        for (CFIdentifier id : this.otherIds) {
            s.append(" = ");
            s.append(id.Decompile(indent));
        }
        if (this.init != null) {
            s.append(" = ");
            s.append(this.init.Decompile(indent + 2));
        }
        return s.toString();
    }

    public String getName() {
        return this.name;
    }

    public CFExpression getInit() {
        return this.init;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        retval.add(this.init);
        retval.addAll(this.otherIds);
        retval.addAll(this.otherVars);
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

