/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFContext;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public abstract class CFParsedStatement
implements CFStatement,
Serializable {
    private static final long serialVersionUID = 1L;
    private int line;
    private int col;
    private Token token;

    public CFParsedStatement(int _line, int _col) {
        this.line = _line;
        this.col = _col + 1;
    }

    public CFParsedStatement(Token t) {
        this.setToken(t);
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token t) {
        if (t != null) {
            this.line = t.getLine();
            this.col = t.getCharPositionInLine() + 1;
        }
        this.token = t;
    }

    @Override
    public abstract String Decompile(int var1);

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
    }

    protected void setLineCol(CFContext context) {
        context.setLineCol(this.line, this.col);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public String Indent(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public abstract List<CFExpression> decomposeExpression();

    public abstract List<CFScriptStatement> decomposeScript();
}

