/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFBinaryExpression
extends CFExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int _kind;
    protected final CFExpression _left;
    protected final CFExpression _right;
    protected String operatorImage;

    public CFBinaryExpression(Token t, CFExpression left, CFExpression right) {
        super(t);
        this._kind = t.getType();
        this.operatorImage = t.getText();
        if (this._kind == 71) {
            this._kind = 26;
        } else if (this._kind == 70) {
            this._kind = 21;
        } else if (this._kind == 177) {
            this._kind = 28;
        }
        this._left = left;
        this._right = right;
    }

    @Override
    public byte getType() {
        return CFExpression.BINARY;
    }

    @Override
    public String Decompile(int indent) {
        String endChar = "";
        if (this._kind == 72) {
            endChar = "]";
        }
        return "" + this._left.Decompile(indent) + " " + this.operatorImage + " " + this._right.Decompile(indent) + endChar;
    }

    public CFExpression getLeft() {
        return this._left;
    }

    public CFExpression getRight() {
        return this._right;
    }

    public int getKind() {
        return this._kind;
    }

    public String getOperatorImage() {
        return this.operatorImage;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this._left, this._right});
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

