/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFArrayExpression
extends CFExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<CFExpression> elements = new ArrayList();

    public CFArrayExpression(Token t) {
        super(t);
    }

    public void addElement(CFExpression _e) {
        this.elements.add(_e);
    }

    @Override
    public String Decompile(int indent) {
        if (this.elements.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < this.elements.size(); ++i) {
                sb.append(this.elements.get(i).Decompile(0));
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(']');
            return sb.toString();
        }
        return "[]";
    }

    public ArrayList<CFExpression> getElements() {
        return this.elements;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return this.elements;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

