/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfml;

import cfml.parsing.cfml.ErrorEvent;
import cfml.parsing.cfml.IErrorObserver;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ErrorObservable {
    List<IErrorObserver> observers;

    public ErrorObservable() {
        this.setObservers(Collections.synchronizedList(new LinkedList()));
    }

    public void addObserver(IErrorObserver observer) {
        this.getObservers().add(observer);
    }

    public void removeObserver(IErrorObserver observer) {
        this.getObservers().remove(observer);
    }

    public void notifyObservers(ErrorEvent event) {
        for (IErrorObserver observer : this.getObservers()) {
            observer.actionCFMLParserError(event);
        }
    }

    private List<IErrorObserver> getObservers() {
        return this.observers;
    }

    private void setObservers(List<IErrorObserver> observers) {
        this.observers = observers;
    }
}

