/*
 * Decompiled with CFR 0.152.
 */
package co.ceryle.fitgridview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;

public abstract class FitGridAdapter
extends BaseAdapter {
    private Context context;
    private int columnWidth;
    private int columnHeight;
    private int row;
    private int column;
    private int itemId;
    private int size = 0;

    public FitGridAdapter(Context context) {
        this.context = context;
    }

    public FitGridAdapter(Context context, int itemId) {
        this.context = context;
        this.itemId = itemId;
    }

    public FitGridAdapter(Context context, int itemId, int size) {
        this.context = context;
        this.itemId = itemId;
        this.size = size;
    }

    public FitGridAdapter(Context context, int itemId, int row, int column) {
        this.context = context;
        this.itemId = itemId;
        this.row = row;
        this.column = column;
        this.size = row * column;
    }

    public View getView(int position, View itemView, ViewGroup parent) {
        if (itemView == null) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            itemView = inflater.inflate(this.itemId, parent, false);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(this.columnWidth, this.columnHeight);
            itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.onBindView(position, itemView);
        }
        return itemView;
    }

    public abstract void onBindView(int var1, View var2);

    public int getCount() {
        return this.size == 0 ? this.column * this.row : this.size;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    void setColumnHeight(int columnHeight) {
        this.columnHeight = columnHeight;
    }

    void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    void setColumn(int column) {
        this.column = column;
    }

    void setRow(int row) {
        this.row = row;
    }
}

