/*
 * Decompiled with CFR 0.152.
 */
package net.center.blurview;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import net.center.blurview.R;
import net.center.blurview.impl.AndroidStockBlurImpl;
import net.center.blurview.impl.AndroidXBlurImpl;
import net.center.blurview.impl.BlurImpl;
import net.center.blurview.impl.EmptyBlurImpl;
import net.center.blurview.impl.SupportLibraryBlurImpl;

public class ShapeBlurView
extends View {
    private Context mContext;
    private float mDownSampleFactor;
    private int mOverlayColor;
    private float mBlurRadius;
    public static final int DEFAULT_BORDER_COLOR = -1;
    private final BlurImpl mBlurImpl;
    private boolean mDirty;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private boolean mIsRendering;
    private final Rect mRectSrc = new Rect();
    private final RectF mRectFDst = new RectF();
    private View mDecorView;
    private boolean mDifferentRoot;
    private static int RENDERING_COUNT;
    private static int BLUR_IMPL;
    private int blurMode = 0;
    private final Paint mBitmapPaint;
    private float cx = 0.0f;
    private float cy = 0.0f;
    private float cRadius = 0.0f;
    private static final float DEFAULT_RADIUS = 0.0f;
    private final float[] mCornerRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final Path cornerPath = new Path();
    private float[] cornerRids;
    private static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private final RectF mBorderRect = new RectF();
    private final Paint mBorderPaint;
    private float mBorderWidth = 0.0f;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-1);
    private Matrix matrix = new Matrix();
    private BitmapShader shader;
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPreDraw() {
            int[] locations = new int[2];
            Bitmap oldBmp = ShapeBlurView.this.mBlurredBitmap;
            View decor = ShapeBlurView.this.mDecorView;
            if (decor != null && ShapeBlurView.this.isShown() && ShapeBlurView.this.prepare()) {
                boolean redrawBitmap = ShapeBlurView.this.mBlurredBitmap != oldBmp;
                oldBmp = null;
                decor.getLocationOnScreen(locations);
                int x = -locations[0];
                int y = -locations[1];
                ShapeBlurView.this.getLocationOnScreen(locations);
                x += locations[0];
                y += locations[1];
                ShapeBlurView.this.mBitmapToBlur.eraseColor(ShapeBlurView.this.mOverlayColor & 0xFFFFFF);
                int rc = ShapeBlurView.this.mBlurringCanvas.save();
                ShapeBlurView.this.mIsRendering = true;
                RENDERING_COUNT++;
                try {
                    ShapeBlurView.this.mBlurringCanvas.scale(1.0f * (float)ShapeBlurView.this.mBitmapToBlur.getWidth() / (float)ShapeBlurView.this.getWidth(), 1.0f * (float)ShapeBlurView.this.mBitmapToBlur.getHeight() / (float)ShapeBlurView.this.getHeight());
                    ShapeBlurView.this.mBlurringCanvas.translate((float)(-x), (float)(-y));
                    if (decor.getBackground() != null) {
                        decor.getBackground().draw(ShapeBlurView.this.mBlurringCanvas);
                    }
                    decor.draw(ShapeBlurView.this.mBlurringCanvas);
                }
                catch (StopException stopException) {
                }
                finally {
                    ShapeBlurView.this.mIsRendering = false;
                    RENDERING_COUNT--;
                    ShapeBlurView.this.mBlurringCanvas.restoreToCount(rc);
                }
                ShapeBlurView.this.blur(ShapeBlurView.this.mBitmapToBlur, ShapeBlurView.this.mBlurredBitmap);
                if (redrawBitmap || ShapeBlurView.this.mDifferentRoot) {
                    ShapeBlurView.this.invalidate();
                }
            }
            return true;
        }
    };
    private static StopException STOP_EXCEPTION;

    public ShapeBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mBlurImpl = this.getBlurImpl();
        try {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShapeBlurView);
            this.mBlurRadius = a.getDimension(R.styleable.ShapeBlurView_blur_radius, TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.mDownSampleFactor = a.getFloat(R.styleable.ShapeBlurView_blur_down_sample, 4.0f);
            this.mOverlayColor = a.getColor(R.styleable.ShapeBlurView_blur_overlay_color, 0);
            float cornerRadiusOverride = a.getDimensionPixelSize(R.styleable.ShapeBlurView_blur_corner_radius, -1);
            this.mCornerRadii[0] = a.getDimensionPixelSize(R.styleable.ShapeBlurView_blur_corner_radius_top_left, -1);
            this.mCornerRadii[1] = a.getDimensionPixelSize(R.styleable.ShapeBlurView_blur_corner_radius_top_right, -1);
            this.mCornerRadii[2] = a.getDimensionPixelSize(R.styleable.ShapeBlurView_blur_corner_radius_bottom_right, -1);
            this.mCornerRadii[3] = a.getDimensionPixelSize(R.styleable.ShapeBlurView_blur_corner_radius_bottom_left, -1);
            this.initCornerData(cornerRadiusOverride);
            this.blurMode = a.getInt(R.styleable.ShapeBlurView_blur_mode, 0);
            this.mBorderWidth = a.getDimensionPixelSize(R.styleable.ShapeBlurView_blur_border_width, -1);
            if (this.mBorderWidth < 0.0f) {
                this.mBorderWidth = 0.0f;
            }
            this.mBorderColor = a.getColorStateList(R.styleable.ShapeBlurView_blur_border_color);
            if (this.mBorderColor == null) {
                this.mBorderColor = ColorStateList.valueOf((int)-1);
            }
            a.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setAntiAlias(true);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -1));
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
    }

    private void initCornerData(float cornerRadiusOverride) {
        int i;
        boolean any = false;
        int len = this.mCornerRadii.length;
        for (i = 0; i < len; ++i) {
            if (this.mCornerRadii[i] < 0.0f) {
                this.mCornerRadii[i] = 0.0f;
                continue;
            }
            any = true;
        }
        if (!any) {
            if (cornerRadiusOverride < 0.0f) {
                cornerRadiusOverride = 0.0f;
            }
            len = this.mCornerRadii.length;
            for (i = 0; i < len; ++i) {
                this.mCornerRadii[i] = cornerRadiusOverride;
            }
        }
        this.initCornerRids();
    }

    private void initCornerRids() {
        if (this.cornerRids == null) {
            this.cornerRids = new float[]{this.mCornerRadii[0], this.mCornerRadii[0], this.mCornerRadii[1], this.mCornerRadii[1], this.mCornerRadii[2], this.mCornerRadii[2], this.mCornerRadii[3], this.mCornerRadii[3]};
        } else {
            this.cornerRids[0] = this.mCornerRadii[0];
            this.cornerRids[1] = this.mCornerRadii[0];
            this.cornerRids[2] = this.mCornerRadii[1];
            this.cornerRids[3] = this.mCornerRadii[1];
            this.cornerRids[4] = this.mCornerRadii[2];
            this.cornerRids[5] = this.mCornerRadii[2];
            this.cornerRids[6] = this.mCornerRadii[3];
            this.cornerRids[7] = this.mCornerRadii[3];
        }
    }

    protected BlurImpl getBlurImpl() {
        Bitmap bmp;
        BlurImpl impl2;
        if (BLUR_IMPL == 0 && Build.VERSION.SDK_INT >= 17) {
            try {
                impl2 = new AndroidStockBlurImpl();
                bmp = Bitmap.createBitmap((int)4, (int)4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                ((AndroidStockBlurImpl)impl2).prepare(this.getContext(), bmp, 4.0f);
                ((AndroidStockBlurImpl)impl2).release();
                bmp.recycle();
                BLUR_IMPL = 3;
            }
            catch (Throwable impl2) {
                // empty catch block
            }
        }
        if (BLUR_IMPL == 0) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass("androidx.renderscript.RenderScript");
                impl2 = new AndroidXBlurImpl();
                bmp = Bitmap.createBitmap((int)4, (int)4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                ((AndroidXBlurImpl)impl2).prepare(this.getContext(), bmp, 4.0f);
                ((AndroidXBlurImpl)impl2).release();
                bmp.recycle();
                BLUR_IMPL = 1;
            }
            catch (Throwable impl3) {
                // empty catch block
            }
        }
        if (BLUR_IMPL == 0) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass("android.support.v8.renderscript.RenderScript");
                impl2 = new SupportLibraryBlurImpl();
                bmp = Bitmap.createBitmap((int)4, (int)4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                ((SupportLibraryBlurImpl)impl2).prepare(this.getContext(), bmp, 4.0f);
                ((SupportLibraryBlurImpl)impl2).release();
                bmp.recycle();
                BLUR_IMPL = 2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (BLUR_IMPL == 0) {
            BLUR_IMPL = -1;
        }
        switch (BLUR_IMPL) {
            case 1: {
                return new AndroidXBlurImpl();
            }
            case 2: {
                return new SupportLibraryBlurImpl();
            }
            case 3: {
                return new AndroidStockBlurImpl();
            }
        }
        return new EmptyBlurImpl();
    }

    public float getCornerRadius() {
        return this.getMaxCornerRadius();
    }

    public float getMaxCornerRadius() {
        float maxRadius = 0.0f;
        for (float r : this.mCornerRadii) {
            maxRadius = Math.max(r, maxRadius);
        }
        return maxRadius;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    @ColorInt
    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public int getBlurMode() {
        return this.blurMode;
    }

    private void releaseBitmap() {
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
        if (this.matrix != null) {
            this.matrix = null;
        }
        if (this.shader != null) {
            this.shader = null;
        }
        this.mContext = null;
    }

    protected void release() {
        this.releaseBitmap();
        this.mBlurImpl.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepare() {
        if (this.mBlurRadius == 0.0f) {
            this.release();
            return false;
        }
        float downSampleFactor = this.mDownSampleFactor;
        float radius = this.mBlurRadius / downSampleFactor;
        if (radius > 25.0f) {
            downSampleFactor = downSampleFactor * radius / 25.0f;
            radius = 25.0f;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int scaledWidth = Math.max(1, (int)((float)width / downSampleFactor));
        int scaledHeight = Math.max(1, (int)((float)height / downSampleFactor));
        boolean dirty = this.mDirty;
        if (this.mBlurringCanvas == null || this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
            dirty = true;
            this.releaseBitmap();
            boolean r = false;
            try {
                this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (this.mBitmapToBlur == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
                this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (this.mBlurredBitmap == null) {
                    boolean bl = false;
                    return bl;
                }
                r = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!r) {
                    this.release();
                    return false;
                }
            }
            finally {
                if (!r) {
                    this.release();
                    return false;
                }
            }
        }
        if (dirty) {
            if (this.mBlurImpl.prepare(this.getContext(), this.mBitmapToBlur, radius)) {
                this.mDirty = false;
            } else {
                return false;
            }
        }
        return true;
    }

    protected void blur(Bitmap bitmapToBlur, Bitmap blurredBitmap) {
        this.shader = new BitmapShader(blurredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBlurImpl.blur(bitmapToBlur, blurredBitmap);
    }

    protected View getActivityDecorView() {
        Context ctx = this.getContext();
        for (int i = 0; i < 4 && !(ctx instanceof Activity) && ctx instanceof ContextWrapper; ++i) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        if (ctx instanceof Activity) {
            return ((Activity)ctx).getWindow().getDecorView();
        }
        return null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mDecorView = this.getActivityDecorView();
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
            boolean bl = this.mDifferentRoot = this.mDecorView.getRootView() != this.getRootView();
            if (this.mDifferentRoot) {
                this.mDecorView.postInvalidate();
            }
        } else {
            this.mDifferentRoot = false;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
        }
        this.release();
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        if (this.mIsRendering) {
            throw STOP_EXCEPTION;
        }
        if (RENDERING_COUNT <= 0) {
            super.draw(canvas);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBlurredBitmap(canvas, this.mBlurredBitmap, this.mOverlayColor);
    }

    protected void drawBlurredBitmap(Canvas canvas, Bitmap blurBitmap, int overlayColor) {
        if (blurBitmap != null) {
            if (this.blurMode == 1) {
                this.drawCircleRectBitmap(canvas, blurBitmap, overlayColor);
            } else if (this.blurMode == 2) {
                this.drawOvalRectBitmap(canvas, blurBitmap, overlayColor);
            } else {
                this.drawRoundRectBitmap(canvas, blurBitmap, overlayColor);
            }
        }
    }

    private void drawRoundRectBitmap(Canvas canvas, Bitmap blurBitmap, int overlayColor) {
        try {
            this.mRectFDst.right = this.getWidth();
            this.mRectFDst.bottom = this.getHeight();
            this.cornerPath.addRoundRect(this.mRectFDst, this.cornerRids, Path.Direction.CW);
            this.cornerPath.close();
            canvas.clipPath(this.cornerPath);
            this.mRectSrc.right = blurBitmap.getWidth();
            this.mRectSrc.bottom = blurBitmap.getHeight();
            canvas.drawBitmap(blurBitmap, this.mRectSrc, this.mRectFDst, null);
            this.mBitmapPaint.setColor(overlayColor);
            canvas.drawRect(this.mRectFDst, this.mBitmapPaint);
            if (this.mBorderWidth > 0.0f) {
                this.mBorderPaint.setStrokeWidth(this.mBorderWidth * 2.0f);
                canvas.drawPath(this.cornerPath, this.mBorderPaint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawOvalRectBitmap(Canvas canvas, Bitmap blurBitmap, int overlayColor) {
        try {
            this.mRectFDst.right = this.getWidth();
            this.mRectFDst.bottom = this.getHeight();
            this.mBitmapPaint.reset();
            this.mBitmapPaint.setAntiAlias(true);
            if (this.shader == null) {
                this.shader = new BitmapShader(blurBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            }
            if (this.matrix == null) {
                this.matrix = new Matrix();
                this.matrix.postScale(this.mRectFDst.width() / (float)blurBitmap.getWidth(), this.mRectFDst.height() / (float)blurBitmap.getHeight());
            }
            this.shader.setLocalMatrix(this.matrix);
            this.mBitmapPaint.setShader((Shader)this.shader);
            canvas.drawOval(this.mRectFDst, this.mBitmapPaint);
            this.mBitmapPaint.reset();
            this.mBitmapPaint.setAntiAlias(true);
            this.mBitmapPaint.setColor(overlayColor);
            canvas.drawOval(this.mRectFDst, this.mBitmapPaint);
            if (this.mBorderWidth > 0.0f) {
                this.mBorderRect.set(this.mRectFDst);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                canvas.drawOval(this.mBorderRect, this.mBorderPaint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawCircleRectBitmap(Canvas canvas, Bitmap blurBitmap, int overlayColor) {
        try {
            this.mRectFDst.right = this.getMeasuredWidth();
            this.mRectFDst.bottom = this.getMeasuredHeight();
            this.mRectSrc.right = blurBitmap.getWidth();
            this.mRectSrc.bottom = blurBitmap.getHeight();
            this.mBitmapPaint.reset();
            this.mBitmapPaint.setAntiAlias(true);
            if (this.shader == null) {
                this.shader = new BitmapShader(blurBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            }
            if (this.matrix == null) {
                this.matrix = new Matrix();
                this.matrix.postScale(this.mRectFDst.width() / (float)this.mRectSrc.width(), this.mRectFDst.height() / (float)this.mRectSrc.height());
            }
            this.shader.setLocalMatrix(this.matrix);
            this.mBitmapPaint.setShader((Shader)this.shader);
            if (this.mRectFDst.width() >= (float)this.mRectSrc.width()) {
                this.cx = this.mRectFDst.width() / 2.0f;
                this.cy = this.mRectFDst.height() / 2.0f;
                this.cRadius = Math.min(this.mRectFDst.width(), this.mRectFDst.height()) / 2.0f;
                this.mBorderRect.set(this.mRectFDst);
            } else {
                this.cx = (float)this.mRectSrc.width() / 2.0f;
                this.cy = (float)this.mRectSrc.height() / 2.0f;
                this.cRadius = (float)Math.min(this.mRectSrc.width(), this.mRectSrc.height()) / 2.0f;
                this.mBorderRect.set(this.mRectSrc);
            }
            canvas.drawCircle(this.cx, this.cy, this.cRadius, this.mBitmapPaint);
            this.mBitmapPaint.reset();
            this.mBitmapPaint.setAntiAlias(true);
            this.mBitmapPaint.setColor(overlayColor);
            canvas.drawCircle(this.cx, this.cy, this.cRadius, this.mBitmapPaint);
            if (this.mBorderWidth > 0.0f) {
                if (this.mBorderRect.width() > this.mBorderRect.height()) {
                    float dif;
                    this.mBorderRect.left = dif = Math.abs(this.mBorderRect.height() - this.mBorderRect.width()) / 2.0f;
                    this.mBorderRect.right = Math.min(this.mBorderRect.width(), this.mBorderRect.height()) + dif;
                    this.mBorderRect.bottom = Math.min(this.mBorderRect.width(), this.mBorderRect.height());
                } else if (this.mBorderRect.width() < this.mBorderRect.height()) {
                    float dif;
                    this.mBorderRect.top = dif = Math.abs(this.mBorderRect.height() - this.mBorderRect.width()) / 2.0f;
                    this.mBorderRect.right = Math.min(this.mBorderRect.width(), this.mBorderRect.height());
                    this.mBorderRect.bottom = Math.min(this.mBorderRect.width(), this.mBorderRect.height()) + dif;
                } else {
                    this.mBorderRect.right = Math.min(this.mBorderRect.width(), this.mBorderRect.height());
                    this.mBorderRect.bottom = Math.min(this.mBorderRect.width(), this.mBorderRect.height());
                }
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                canvas.drawOval(this.mBorderRect, this.mBorderPaint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int dp2px(float dpValue) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @NonNull
    public int[] getState() {
        return StateSet.WILD_CARD;
    }

    public void refreshView(Builder builder) {
        boolean isInvalidate = false;
        if (builder == null) {
            return;
        }
        if (builder.blurMode != -1 && this.blurMode != builder.blurMode) {
            this.blurMode = builder.blurMode;
            isInvalidate = true;
        }
        if (builder.mBorderColor != null && !this.mBorderColor.equals(builder.mBorderColor)) {
            this.mBorderColor = builder.mBorderColor;
            this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -1));
            if (this.mBorderWidth > 0.0f) {
                isInvalidate = true;
            }
        }
        if (builder.mBorderWidth > 0.0f) {
            this.mBorderWidth = builder.mBorderWidth;
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            isInvalidate = true;
        }
        if (this.mCornerRadii[0] != builder.mCornerRadii[0] || this.mCornerRadii[1] != builder.mCornerRadii[1] || this.mCornerRadii[2] != builder.mCornerRadii[2] || this.mCornerRadii[3] != builder.mCornerRadii[3]) {
            this.mCornerRadii[0] = builder.mCornerRadii[0];
            this.mCornerRadii[1] = builder.mCornerRadii[1];
            this.mCornerRadii[3] = builder.mCornerRadii[3];
            this.mCornerRadii[2] = builder.mCornerRadii[2];
            isInvalidate = true;
            this.initCornerRids();
        }
        if (builder.mOverlayColor != -1 && this.mOverlayColor != builder.mOverlayColor) {
            this.mOverlayColor = builder.mOverlayColor;
            isInvalidate = true;
        }
        if (builder.mBlurRadius > 0.0f && this.mBlurRadius != builder.mBlurRadius) {
            this.mBlurRadius = builder.mBlurRadius;
            this.mDirty = true;
            isInvalidate = true;
        }
        if (builder.mDownSampleFactor > 0.0f && this.mDownSampleFactor != builder.mDownSampleFactor) {
            this.mDownSampleFactor = builder.mDownSampleFactor;
            this.mDirty = true;
            isInvalidate = true;
            this.releaseBitmap();
        }
        if (isInvalidate) {
            this.invalidate();
        }
    }

    public static Builder build(Context context) {
        return new Builder(context);
    }

    static {
        STOP_EXCEPTION = new StopException();
    }

    public static class Builder {
        private float mDownSampleFactor = -1.0f;
        private int mOverlayColor = -1;
        private float mBlurRadius = -1.0f;
        private float mBorderWidth = -1.0f;
        private ColorStateList mBorderColor = null;
        private int blurMode = -1;
        private final float[] mCornerRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        private Context mContext;

        private Builder(Context context) {
            this.mContext = context.getApplicationContext();
        }

        public Builder setBlurRadius(@FloatRange(from=0.0, to=25.0) float radius) {
            this.mBlurRadius = radius;
            return this;
        }

        public Builder setDownSampleFactor(float factor) {
            if (factor <= 0.0f) {
                throw new IllegalArgumentException("DownSample factor must be greater than 0.");
            }
            this.mDownSampleFactor = factor;
            return this;
        }

        public Builder setOverlayColor(int color) {
            this.mOverlayColor = color;
            return this;
        }

        public Builder setCornerRadius(int corner, float radius) {
            this.mCornerRadii[corner] = radius;
            return this;
        }

        public Builder setCornerRadiusDimen(@DimenRes int resId) {
            float radius = this.mContext.getResources().getDimension(resId);
            return this.setCornerRadius(radius, radius, radius, radius);
        }

        public Builder setCornerRadius(float radius) {
            return this.setCornerRadius(radius, radius, radius, radius);
        }

        public Builder setCornerRadius(float topLeft, float topRight, float bottomLeft, float bottomRight) {
            this.mCornerRadii[0] = topLeft;
            this.mCornerRadii[1] = topRight;
            this.mCornerRadii[3] = bottomLeft;
            this.mCornerRadii[2] = bottomRight;
            return this;
        }

        public Builder setBorderWidth(@DimenRes int resId) {
            return this.setBorderWidth(this.mContext.getResources().getDimension(resId));
        }

        public Builder setBorderWidth(float width) {
            this.mBorderWidth = width;
            return this;
        }

        public Builder setBorderColor(@ColorRes int color) {
            return this.setBorderColor(ColorStateList.valueOf((int)ContextCompat.getColor((Context)this.mContext, (int)color)));
        }

        public Builder setBorderColor(ColorStateList colors) {
            this.mBorderColor = colors != null ? colors : ColorStateList.valueOf((int)-1);
            return this;
        }

        public Builder setBlurMode(int blurMode) {
            this.blurMode = blurMode;
            return this;
        }
    }

    private static class StopException
    extends RuntimeException {
        private StopException() {
        }
    }
}

