/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.shuyu.gsyvideoplayer.cache.CacheFactory;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import com.shuyu.gsyvideoplayer.listener.GSYMediaPlayerListener;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.BasePlayerManager;
import com.shuyu.gsyvideoplayer.player.IPlayerInitSuccessListener;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import com.shuyu.gsyvideoplayer.player.PlayerFactory;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoViewBridge;
import java.io.BufferedInputStream;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public abstract class GSYVideoBaseManager
implements IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnCompletionListener,
IMediaPlayer.OnBufferingUpdateListener,
IMediaPlayer.OnSeekCompleteListener,
IMediaPlayer.OnErrorListener,
IMediaPlayer.OnVideoSizeChangedListener,
IMediaPlayer.OnInfoListener,
ICacheManager.ICacheAvailableListener,
GSYVideoViewBridge {
    public static String TAG = "GSYVideoBaseManager";
    protected static final int HANDLER_PREPARE = 0;
    protected static final int HANDLER_SETDISPLAY = 1;
    protected static final int HANDLER_RELEASE = 2;
    protected static final int HANDLER_RELEASE_SURFACE = 3;
    protected static final int BUFFER_TIME_OUT_ERROR = -192;
    protected Context context;
    protected MediaHandler mMediaHandler;
    protected Handler mainThreadHandler;
    protected WeakReference<GSYMediaPlayerListener> listener;
    protected WeakReference<GSYMediaPlayerListener> lastListener;
    protected IPlayerInitSuccessListener mPlayerInitSuccessListener;
    protected List<VideoOptionModel> optionModelList;
    protected String playTag = "";
    protected IPlayerManager playerManager;
    protected ICacheManager cacheManager;
    protected int currentVideoWidth = 0;
    protected int currentVideoHeight = 0;
    protected int lastState;
    protected int playPosition = -22;
    protected int bufferPoint;
    protected int timeOut = 8000;
    protected boolean needMute = false;
    protected boolean needTimeOutOther;
    private Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            if (GSYVideoBaseManager.this.listener() != null) {
                Debuger.printfError("time out for error listener");
                GSYVideoBaseManager.this.listener().onError(-192, -192);
            }
        }
    };

    public void clearAllDefaultCache(Context context) {
        this.clearDefaultCache(context, null, null);
    }

    public void clearDefaultCache(Context context, @Nullable File cacheDir, @Nullable String url) {
        if (this.cacheManager != null) {
            this.cacheManager.clearCache(context, cacheDir, url);
        } else if (this.getCacheManager() != null) {
            this.getCacheManager().clearCache(context, cacheDir, url);
        }
    }

    protected void init() {
        this.mMediaHandler = new MediaHandler(Looper.getMainLooper());
        this.mainThreadHandler = new Handler();
    }

    protected IPlayerManager getPlayManager() {
        return PlayerFactory.getPlayManager();
    }

    protected ICacheManager getCacheManager() {
        return CacheFactory.getCacheManager();
    }

    @Override
    public GSYMediaPlayerListener listener() {
        if (this.listener == null) {
            return null;
        }
        return (GSYMediaPlayerListener)this.listener.get();
    }

    @Override
    public GSYMediaPlayerListener lastListener() {
        if (this.lastListener == null) {
            return null;
        }
        return (GSYMediaPlayerListener)this.lastListener.get();
    }

    @Override
    public void setListener(GSYMediaPlayerListener listener) {
        this.listener = listener == null ? null : new WeakReference<GSYMediaPlayerListener>(listener);
    }

    @Override
    public void setLastListener(GSYMediaPlayerListener lastListener) {
        this.lastListener = lastListener == null ? null : new WeakReference<GSYMediaPlayerListener>(lastListener);
    }

    @Override
    public void setSpeed(float speed, boolean soundTouch) {
        if (this.playerManager != null) {
            this.playerManager.setSpeed(speed, soundTouch);
        }
    }

    @Override
    public void prepare(String url, Map<String, String> mapHeadData, boolean loop, float speed, boolean cache, File cachePath) {
        this.prepare(url, mapHeadData, loop, speed, cache, cachePath, null);
    }

    @Override
    public void prepare(String url, Map<String, String> mapHeadData, boolean loop, float speed, boolean cache, File cachePath, String overrideExtension) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Message msg = new Message();
        msg.what = 0;
        GSYModel fb = new GSYModel(url, mapHeadData, loop, speed, cache, cachePath, overrideExtension);
        msg.obj = fb;
        this.sendMessage(msg);
    }

    @Override
    public void prepare(BufferedInputStream videoBufferedInputStream, Map<String, String> mapHeadData, boolean loop, float speed, boolean cache, File cachePath) {
        this.prepare(videoBufferedInputStream, mapHeadData, loop, speed, cache, cachePath, null);
    }

    @Override
    public void prepare(BufferedInputStream videoBufferedInputStream, Map<String, String> mapHeadData, boolean loop, float speed, boolean cache, File cachePath, String overrideExtension) {
        if (videoBufferedInputStream == null) {
            return;
        }
        Message msg = new Message();
        msg.what = 0;
        msg.obj = new GSYModel(videoBufferedInputStream, mapHeadData, loop, speed, cache, cachePath, null);
        this.sendMessage(msg);
    }

    @Override
    public void releaseMediaPlayer() {
        Message msg = new Message();
        msg.what = 2;
        this.sendMessage(msg);
        this.playTag = "";
        this.playPosition = -22;
    }

    @Override
    public void setDisplay(Surface holder) {
        Message msg = new Message();
        msg.what = 1;
        msg.obj = holder;
        this.showDisplay(msg);
    }

    @Override
    public void releaseSurface(Surface holder) {
        Message msg = new Message();
        msg.what = 3;
        msg.obj = holder;
        this.sendMessage(msg);
    }

    public void onPrepared(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onPrepared();
                }
            }
        });
    }

    public void onCompletion(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onAutoCompletion();
                }
            }
        });
    }

    public void onBufferingUpdate(IMediaPlayer mp, final int percent) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoBaseManager.this.listener() != null) {
                    if (percent > GSYVideoBaseManager.this.bufferPoint) {
                        GSYVideoBaseManager.this.listener().onBufferingUpdate(percent);
                    } else {
                        GSYVideoBaseManager.this.listener().onBufferingUpdate(GSYVideoBaseManager.this.bufferPoint);
                    }
                }
            }
        });
    }

    public void onSeekComplete(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onSeekComplete();
                }
            }
        });
    }

    public boolean onError(IMediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onError(what, extra);
                }
            }
        });
        return true;
    }

    public boolean onInfo(IMediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoBaseManager.this.needTimeOutOther) {
                    if (what == 701) {
                        GSYVideoBaseManager.this.startTimeOutBuffer();
                    } else if (what == 702) {
                        GSYVideoBaseManager.this.cancelTimeOutBuffer();
                    }
                }
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
        this.currentVideoWidth = mp.getVideoWidth();
        this.currentVideoHeight = mp.getVideoHeight();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onVideoSizeChanged();
                }
            }
        });
    }

    public void onCacheAvailable(File cacheFile, String url, int percentsAvailable) {
        this.bufferPoint = percentsAvailable;
    }

    @Override
    public int getLastState() {
        return this.lastState;
    }

    @Override
    public void setLastState(int lastState) {
        this.lastState = lastState;
    }

    @Override
    public int getCurrentVideoWidth() {
        return this.currentVideoWidth;
    }

    @Override
    public int getCurrentVideoHeight() {
        return this.currentVideoHeight;
    }

    @Override
    public void setCurrentVideoHeight(int currentVideoHeight) {
        this.currentVideoHeight = currentVideoHeight;
    }

    @Override
    public void setCurrentVideoWidth(int currentVideoWidth) {
        this.currentVideoWidth = currentVideoWidth;
    }

    @Override
    public String getPlayTag() {
        return this.playTag;
    }

    @Override
    public void setPlayTag(String playTag) {
        this.playTag = playTag;
    }

    @Override
    public int getPlayPosition() {
        return this.playPosition;
    }

    @Override
    public void setPlayPosition(int playPosition) {
        this.playPosition = playPosition;
    }

    @Override
    public boolean isCacheFile() {
        return this.cacheManager != null && this.cacheManager.hadCached();
    }

    @Override
    public boolean cachePreview(Context context, File cacheDir, String url) {
        if (this.getCacheManager() != null) {
            return this.getCacheManager().cachePreview(context, cacheDir, url);
        }
        return false;
    }

    @Override
    public long getNetSpeed() {
        if (this.playerManager != null) {
            return this.playerManager.getNetSpeed();
        }
        return 0L;
    }

    @Override
    public void clearCache(Context context, File cacheDir, String url) {
        this.clearDefaultCache(context, cacheDir, url);
    }

    @Override
    public int getBufferedPercentage() {
        if (this.playerManager != null) {
            return this.playerManager.getBufferedPercentage();
        }
        return 0;
    }

    @Override
    public void setSpeedPlaying(float speed, boolean soundTouch) {
        if (this.playerManager != null) {
            this.playerManager.setSpeedPlaying(speed, soundTouch);
        }
    }

    @Override
    public IPlayerManager getPlayer() {
        return this.playerManager;
    }

    @Override
    public void start() {
        if (this.playerManager != null) {
            this.playerManager.start();
        }
    }

    @Override
    public void stop() {
        if (this.playerManager != null) {
            this.playerManager.stop();
        }
    }

    @Override
    public void pause() {
        if (this.playerManager != null) {
            this.playerManager.pause();
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.playerManager != null) {
            return this.playerManager.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.playerManager != null) {
            return this.playerManager.getVideoHeight();
        }
        return 0;
    }

    @Override
    public boolean isPlaying() {
        if (this.playerManager != null) {
            return this.playerManager.isPlaying();
        }
        return false;
    }

    @Override
    public void seekTo(long time) {
        if (this.playerManager != null) {
            this.playerManager.seekTo(time);
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.playerManager != null) {
            return this.playerManager.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.playerManager != null) {
            return this.playerManager.getDuration();
        }
        return 0L;
    }

    @Override
    public int getVideoSarNum() {
        if (this.playerManager != null) {
            return this.playerManager.getVideoSarNum();
        }
        return 0;
    }

    @Override
    public int getVideoSarDen() {
        if (this.playerManager != null) {
            return this.playerManager.getVideoSarDen();
        }
        return 0;
    }

    @Override
    public int getRotateInfoFlag() {
        return 10001;
    }

    @Override
    public boolean isSurfaceSupportLockCanvas() {
        if (this.playerManager != null) {
            return this.playerManager.isSurfaceSupportLockCanvas();
        }
        return false;
    }

    protected void sendMessage(Message message) {
        this.mMediaHandler.sendMessage(message);
    }

    private void initVideo(Message msg) {
        try {
            this.currentVideoWidth = 0;
            this.currentVideoHeight = 0;
            if (this.playerManager != null) {
                this.playerManager.release();
            }
            this.playerManager = this.getPlayManager();
            this.cacheManager = this.getCacheManager();
            if (this.cacheManager != null) {
                this.cacheManager.setCacheAvailableListener((ICacheManager.ICacheAvailableListener)this);
            }
            if (this.playerManager instanceof BasePlayerManager) {
                ((BasePlayerManager)this.playerManager).setPlayerInitSuccessListener(this.mPlayerInitSuccessListener);
            }
            this.playerManager.initVideoPlayer(this.context, msg, this.optionModelList, this.cacheManager);
            this.setNeedMute(this.needMute);
            IMediaPlayer mediaPlayer = this.playerManager.getMediaPlayer();
            mediaPlayer.setOnCompletionListener((IMediaPlayer.OnCompletionListener)this);
            mediaPlayer.setOnBufferingUpdateListener((IMediaPlayer.OnBufferingUpdateListener)this);
            mediaPlayer.setScreenOnWhilePlaying(true);
            mediaPlayer.setOnPreparedListener((IMediaPlayer.OnPreparedListener)this);
            mediaPlayer.setOnSeekCompleteListener((IMediaPlayer.OnSeekCompleteListener)this);
            mediaPlayer.setOnErrorListener((IMediaPlayer.OnErrorListener)this);
            mediaPlayer.setOnInfoListener((IMediaPlayer.OnInfoListener)this);
            mediaPlayer.setOnVideoSizeChangedListener((IMediaPlayer.OnVideoSizeChangedListener)this);
            mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void startTimeOutBuffer() {
        Debuger.printfError("startTimeOutBuffer");
        this.mainThreadHandler.postDelayed(this.mTimeOutRunnable, (long)this.timeOut);
    }

    protected void cancelTimeOutBuffer() {
        Debuger.printfError("cancelTimeOutBuffer");
        if (this.needTimeOutOther) {
            this.mainThreadHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }

    private void releaseSurface(Message msg) {
        if (msg.obj != null && this.playerManager != null) {
            this.playerManager.releaseSurface();
        }
    }

    private void showDisplay(Message msg) {
        if (this.playerManager != null) {
            this.playerManager.showDisplay(msg);
        }
    }

    public void initContext(Context context) {
        this.context = context.getApplicationContext();
    }

    public void enableRawPlay(Context context) {
        this.context = context.getApplicationContext();
    }

    public List<VideoOptionModel> getOptionModelList() {
        return this.optionModelList;
    }

    public void setOptionModelList(List<VideoOptionModel> optionModelList) {
        this.optionModelList = optionModelList;
    }

    public boolean isNeedMute() {
        return this.needMute;
    }

    public void setNeedMute(boolean needMute) {
        this.needMute = needMute;
        if (this.playerManager != null) {
            this.playerManager.setNeedMute(needMute);
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isNeedTimeOutOther() {
        return this.needTimeOutOther;
    }

    public void setTimeOut(int timeOut, boolean needTimeOutOther) {
        this.timeOut = timeOut;
        this.needTimeOutOther = needTimeOutOther;
    }

    public IPlayerManager getCurPlayerManager() {
        return this.playerManager;
    }

    public ICacheManager getCurCacheManager() {
        return this.cacheManager;
    }

    public IPlayerInitSuccessListener getPlayerPreparedSuccessListener() {
        return this.mPlayerInitSuccessListener;
    }

    public void setPlayerInitSuccessListener(IPlayerInitSuccessListener listener) {
        this.mPlayerInitSuccessListener = listener;
    }

    private class MediaHandler
    extends Handler {
        MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    GSYVideoBaseManager.this.initVideo(msg);
                    if (!GSYVideoBaseManager.this.needTimeOutOther) break;
                    GSYVideoBaseManager.this.startTimeOutBuffer();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (GSYVideoBaseManager.this.playerManager != null) {
                        GSYVideoBaseManager.this.playerManager.release();
                    }
                    if (GSYVideoBaseManager.this.cacheManager != null) {
                        GSYVideoBaseManager.this.cacheManager.release();
                    }
                    GSYVideoBaseManager.this.bufferPoint = 0;
                    GSYVideoBaseManager.this.setNeedMute(false);
                    GSYVideoBaseManager.this.cancelTimeOutBuffer();
                    break;
                }
                case 3: {
                    GSYVideoBaseManager.this.releaseSurface(msg);
                }
            }
        }
    }
}

