/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.TintContextWrapper;
import androidx.fragment.app.FragmentActivity;
import java.io.File;
import java.util.Formatter;
import java.util.Locale;

public class CommonUtil {
    public static String stringForTime(long timeMs) {
        long totalSeconds = timeMs / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0L) {
            return mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo wifiNetworkInfo = connectivityManager.getNetworkInfo(1);
        if (wifiNetworkInfo == null) {
            return false;
        }
        return wifiNetworkInfo.isConnected();
    }

    public static Activity scanForActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof TintContextWrapper) {
            return CommonUtil.scanForActivity(((TintContextWrapper)context).getBaseContext());
        }
        if (context instanceof ContextWrapper) {
            return CommonUtil.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getActionBarHeight(Activity activity) {
        TypedValue tv = new TypedValue();
        if (activity.getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)activity.getResources().getDisplayMetrics());
        }
        return 0;
    }

    @SuppressLint(value={"RestrictedApi"})
    public static void hideSupportActionBar(Context context, boolean actionBar, boolean statusBar) {
        ActionBar ab;
        AppCompatActivity appCompatActivity;
        if (actionBar && (appCompatActivity = CommonUtil.getAppCompActivity(context)) != null && (ab = appCompatActivity.getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
        if (statusBar) {
            if (context instanceof FragmentActivity) {
                FragmentActivity fragmentActivity = (FragmentActivity)context;
                fragmentActivity.getWindow().setFlags(1024, 1024);
            } else if (context instanceof Activity) {
                Activity activity = (Activity)context;
                activity.getWindow().setFlags(1024, 1024);
            } else {
                CommonUtil.getAppCompActivity(context).getWindow().setFlags(1024, 1024);
            }
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public static void showSupportActionBar(Context context, boolean actionBar, boolean statusBar) {
        ActionBar ab;
        AppCompatActivity appCompatActivity;
        if (actionBar && (appCompatActivity = CommonUtil.getAppCompActivity(context)) != null && (ab = appCompatActivity.getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
        if (statusBar) {
            if (context instanceof FragmentActivity) {
                FragmentActivity fragmentActivity = (FragmentActivity)context;
                fragmentActivity.getWindow().clearFlags(1024);
            } else if (context instanceof Activity) {
                Activity activity = (Activity)context;
                activity.getWindow().clearFlags(1024);
            } else {
                CommonUtil.getAppCompActivity(context).getWindow().clearFlags(1024);
            }
        }
    }

    public static void hideNavKey(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            ((Activity)context).getWindow().getDecorView().setSystemUiVisibility(3074);
        } else if (Build.VERSION.SDK_INT >= 19) {
            ((Activity)context).getWindow().getDecorView().setSystemUiVisibility(2562);
        } else {
            ((Activity)context).getWindow().getDecorView().setSystemUiVisibility(514);
        }
    }

    public static void showNavKey(Context context, int systemUiVisibility) {
        ((Activity)context).getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
    }

    public static AppCompatActivity getAppCompActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return CommonUtil.getAppCompActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    public static int dip2px(Context context, float dipValue) {
        float fontScale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * fontScale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int getScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    public static String getTextSpeed(long speed) {
        String text = "";
        if (speed >= 0L && speed < 1024L) {
            text = speed + " KB/s";
        } else if (speed >= 1024L && speed < 0x100000L) {
            text = Long.toString(speed / 1024L) + " KB/s";
        } else if (speed >= 0x100000L && speed < 0x40000000L) {
            text = Long.toString(speed / 0x100000L) + " MB/s";
        }
        return text;
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                String[] filePaths;
                for (String path : filePaths = file.list()) {
                    CommonUtil.deleteFile(filePath + File.separator + path);
                }
                file.delete();
            }
        }
    }

    public static Activity getActivityContext(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof TintContextWrapper) {
            return CommonUtil.scanForActivity(((TintContextWrapper)context).getBaseContext());
        }
        if (context instanceof ContextWrapper) {
            return CommonUtil.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public static boolean getCurrentScreenLand(Activity context) {
        return context.getWindowManager().getDefaultDisplay().getRotation() == 1 || context.getWindowManager().getDefaultDisplay().getRotation() == 3;
    }
}

