/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import com.shuyu.gsyvideoplayer.listener.GSYVideoGifSaveListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.utils.AnimatedGifEncoder;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class GifCreateHelper {
    private boolean mSaveShotBitmapSuccess = true;
    private StandardGSYVideoPlayer mPlayer;
    private TaskLocal mTimerTask;
    private Timer mTimer = new Timer();
    private List<String> mPicList = new ArrayList<String>();
    private File mTmpPath;
    private GSYVideoGifSaveListener mGSYVideoGifSaveListener;
    private int mDelay = 0;
    private int mSampleSize = 1;
    private int mScaleSize = 5;
    private int mFrequencyCount = 50;

    public GifCreateHelper(StandardGSYVideoPlayer standardGSYVideoPlayer, GSYVideoGifSaveListener gsyVideoGifSaveListener) {
        this(standardGSYVideoPlayer, gsyVideoGifSaveListener, 0, 1, 5, 50);
    }

    public GifCreateHelper(StandardGSYVideoPlayer standardGSYVideoPlayer, GSYVideoGifSaveListener gsyVideoGifSaveListener, int delay, int inSampleSize, int scaleSize, int frequencyCount) {
        this.mPlayer = standardGSYVideoPlayer;
        this.mGSYVideoGifSaveListener = gsyVideoGifSaveListener;
        this.mDelay = delay;
        this.mSampleSize = inSampleSize;
        this.mScaleSize = scaleSize;
        this.mFrequencyCount = frequencyCount;
    }

    public void startGif(File tmpPicPath) {
        this.mTmpPath = tmpPicPath;
        this.cancelTask();
        this.mPicList.clear();
        this.mTimerTask = new TaskLocal();
        this.mTimer.schedule((TimerTask)this.mTimerTask, 0L, (long)this.mFrequencyCount);
    }

    public void stopGif(final File path) {
        this.cancelTask();
        this.mSaveShotBitmapSuccess = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (GifCreateHelper.this.mPicList.size() > 2) {
                    GifCreateHelper.this.createGif(path, GifCreateHelper.this.mPicList, GifCreateHelper.this.mDelay, GifCreateHelper.this.mSampleSize, GifCreateHelper.this.mScaleSize, GifCreateHelper.this.mGSYVideoGifSaveListener);
                } else {
                    GifCreateHelper.this.mGSYVideoGifSaveListener.result(false, null);
                }
            }
        }).start();
    }

    public void cancelTask() {
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
    }

    private void startSaveBitmap() {
        File file = new File(this.mTmpPath, "GSY-TMP-FRAME" + System.currentTimeMillis() + ".tmp");
        this.mPlayer.saveFrame(file, new GSYVideoShotSaveListener(){

            @Override
            public void result(boolean success, File file) {
                GifCreateHelper.this.mSaveShotBitmapSuccess = true;
                if (success) {
                    Debuger.printfError(" SUCCESS CREATE FILE " + file.getAbsolutePath());
                    GifCreateHelper.this.mPicList.add(file.getAbsolutePath());
                }
            }
        });
    }

    public void createGif(File file, List<String> pics, int delay, int inSampleSize, int scaleSize, GSYVideoGifSaveListener gsyVideoGifSaveListener) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AnimatedGifEncoder localAnimatedGifEncoder = new AnimatedGifEncoder();
        localAnimatedGifEncoder.start(baos);
        localAnimatedGifEncoder.setRepeat(0);
        localAnimatedGifEncoder.setDelay(delay);
        for (int i = 0; i < pics.size(); ++i) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = inSampleSize;
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)pics.get(i), (BitmapFactory.Options)options);
            double w = (double)options.outWidth / (double)scaleSize;
            double h = (double)options.outHeight / (double)scaleSize;
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeFile((String)pics.get(i), (BitmapFactory.Options)options);
            Bitmap pic = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)((int)w), (int)((int)h));
            localAnimatedGifEncoder.addFrame(pic);
            bitmap.recycle();
            pic.recycle();
            gsyVideoGifSaveListener.process(i + 1, pics.size());
        }
        localAnimatedGifEncoder.finish();
        try {
            FileOutputStream fos = new FileOutputStream(file.getPath());
            baos.writeTo(fos);
            baos.flush();
            fos.flush();
            baos.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            gsyVideoGifSaveListener.result(false, file);
            return;
        }
        gsyVideoGifSaveListener.result(true, file);
    }

    private class TaskLocal
    extends TimerTask {
        private TaskLocal() {
        }

        @Override
        public void run() {
            if (GifCreateHelper.this.mSaveShotBitmapSuccess) {
                GifCreateHelper.this.mSaveShotBitmapSuccess = false;
                GifCreateHelper.this.startSaveBitmap();
            }
        }
    }
}

