/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.shuyu.gsyvideoplayer.render.GSYRenderView;
import com.shuyu.gsyvideoplayer.render.effect.NoEffect;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.render.view.listener.IGSYSurfaceListener;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;

public abstract class GSYTextureRenderView
extends FrameLayout
implements IGSYSurfaceListener,
MeasureHelper.MeasureFormVideoParamsListener {
    protected Surface mSurface;
    protected GSYRenderView mTextureView;
    protected ViewGroup mTextureViewContainer;
    protected Bitmap mFullPauseBitmap;
    protected GSYVideoGLView.ShaderInterface mEffectFilter = new NoEffect();
    protected GSYVideoGLViewBaseRender mRenderer;
    protected float[] mMatrixGL = null;
    protected int mRotate;
    protected int mMode = 0;

    public GSYTextureRenderView(@NonNull Context context) {
        super(context);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void onSurfaceAvailable(Surface surface) {
        this.pauseLogic(surface, this.mTextureView != null && this.mTextureView.getShowView() instanceof TextureView);
    }

    @Override
    public void onSurfaceSizeChanged(Surface surface, int width, int height) {
    }

    @Override
    public boolean onSurfaceDestroyed(Surface surface) {
        this.setDisplay(null);
        this.releaseSurface(surface);
        return true;
    }

    @Override
    public void onSurfaceUpdated(Surface surface) {
        this.releasePauseCover();
    }

    protected void pauseLogic(Surface surface, boolean pauseLogic) {
        this.mSurface = surface;
        if (pauseLogic) {
            this.showPauseCover();
        }
        this.setDisplay(this.mSurface);
    }

    protected void addTextureView() {
        this.mTextureView = new GSYRenderView();
        this.mTextureView.addView(this.getContext(), this.mTextureViewContainer, this.mRotate, this, this, this.mEffectFilter, this.mMatrixGL, this.mRenderer, this.mMode);
    }

    protected int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }

    protected void changeTextureViewShowType() {
        if (this.mTextureView != null) {
            int params = this.getTextureParams();
            ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
            layoutParams.width = params;
            layoutParams.height = params;
            this.mTextureView.setLayoutParams(layoutParams);
        }
    }

    protected void initCover() {
        if (this.mTextureView != null) {
            this.mFullPauseBitmap = this.mTextureView.initCover();
        }
    }

    protected void setSmallVideoTextureView(View.OnTouchListener onTouchListener) {
        this.mTextureViewContainer.setOnTouchListener(onTouchListener);
        this.mTextureViewContainer.setOnClickListener(null);
        this.setSmallVideoTextureView();
    }

    public GSYVideoGLView.ShaderInterface getEffectFilter() {
        return this.mEffectFilter;
    }

    public GSYRenderView getRenderProxy() {
        return this.mTextureView;
    }

    public void setEffectFilter(GSYVideoGLView.ShaderInterface effectFilter) {
        this.mEffectFilter = effectFilter;
        if (this.mTextureView != null) {
            this.mTextureView.setEffectFilter(effectFilter);
        }
    }

    public void setMatrixGL(float[] matrixGL) {
        this.mMatrixGL = matrixGL;
        if (this.mTextureView != null) {
            this.mTextureView.setMatrixGL(this.mMatrixGL);
        }
    }

    public void setCustomGLRenderer(GSYVideoGLViewBaseRender renderer) {
        this.mRenderer = renderer;
        if (this.mTextureView != null) {
            this.mTextureView.setGLRenderer(renderer);
        }
    }

    public void setGLRenderMode(int mode) {
        this.mMode = mode;
        if (this.mTextureView != null) {
            this.mTextureView.setGLRenderMode(mode);
        }
    }

    protected abstract void showPauseCover();

    protected abstract void releasePauseCover();

    protected abstract void setSmallVideoTextureView();

    protected abstract void setDisplay(Surface var1);

    protected abstract void releaseSurface(Surface var1);
}

