/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.ctc.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.swing.annotation.GUITestFinder;
import org.assertj.swing.junit.runner.FailureScreenshotTaker;
import org.assertj.swing.junit.runner.Formatter;
import org.assertj.swing.junit.runner.ImageFolderCreator;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class ScreenshotFailureExtension
implements TestExecutionExceptionHandler,
LifecycleMethodExecutionExceptionHandler {
    private final FailureScreenshotTaker screenshotTaker;

    public ScreenshotFailureExtension() {
        System.setProperty("org.assertj.swing.preserve_screenshots", "true");
        this.screenshotTaker = new FailureScreenshotTaker(new ImageFolderCreator().createImageFolder());
        try {
            Field loggerField = FailureScreenshotTaker.class.getDeclaredField("logger");
            loggerField.setAccessible(true);
            Logger logger = (Logger)loggerField.get(null);
            logger.setLevel(Level.FINE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.takeScreenshot(context);
        throw throwable;
    }

    private void takeScreenshot(ExtensionContext context) {
        if (GUITestFinder.isGUITest((Class)context.getRequiredTestClass(), (Method)context.getRequiredTestMethod())) {
            this.screenshotTaker.saveScreenshot(Formatter.testNameFrom((Class)context.getRequiredTestClass(), (Method)context.getRequiredTestMethod()));
        }
    }

    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.takeScreenshot(context);
        throw throwable;
    }

    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.takeScreenshot(context);
        throw throwable;
    }

    public void handleAfterEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.takeScreenshot(context);
        throw throwable;
    }

    public void handleAfterAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.takeScreenshot(context);
        throw throwable;
    }
}

