/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.ctc.junit;

import com.github.caciocavallosilano.cacio.ctc.CTCGraphicsConfiguration;
import com.github.caciocavallosilano.cacio.ctc.CTCGraphicsDevice;
import com.github.caciocavallosilano.cacio.ctc.CTCGraphicsEnvironment;
import com.github.caciocavallosilano.cacio.ctc.CTCSurfaceManagerFactory;
import com.github.caciocavallosilano.cacio.ctc.CTCToolkit;
import com.github.caciocavallosilano.cacio.ctc.CTCVolatileSurfaceManager;
import com.github.caciocavallosilano.cacio.ctc.junit.CTCInterceptor;
import com.github.caciocavallosilano.cacio.ctc.junit.CacioTest;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import com.github.caciocavallosilano.cacio.peer.managed.FullScreenWindowFactory;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class CacioExtension
implements ExecutionCondition {
    private static final VarHandle MODIFIERS;

    public static void injectCTCGraphicsEnvironment() throws ClassNotFoundException, IOException {
        CacioExtension.injectClassIntoBootstrapClassLoader(CTCInterceptor.class, CTCGraphicsEnvironment.class, CTCSurfaceManagerFactory.class, CTCGraphicsConfiguration.class, PlatformWindowFactory.class, FullScreenWindowFactory.class, CTCGraphicsDevice.class, CTCVolatileSurfaceManager.class);
        ByteBuddy byteBuddy = new ByteBuddy();
        byteBuddy.redefine(TypePool.Default.ofSystemLoader().describe("java.awt.GraphicsEnvironment").resolve(), ClassFileLocator.ForClassLoader.ofSystemLoader()).method((ElementMatcher)ElementMatchers.named((String)"getLocalGraphicsEnvironment")).intercept((Implementation)MethodDelegation.to(CTCInterceptor.class)).make().load(Object.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
        TypeDescription platformGraphicInfosType = TypePool.Default.ofSystemLoader().describe("sun.awt.PlatformGraphicsInfo").resolve();
        ClassFileLocator locator = ClassFileLocator.ForClassLoader.ofSystemLoader();
        byteBuddy.redefine(platformGraphicInfosType, locator).method((ElementMatcher)ElementMatchers.nameStartsWith((String)"createGE")).intercept((Implementation)MethodDelegation.to(GraphicsEnvironmentInterceptor.class)).make().load(Thread.currentThread().getContextClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    public final ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotatedElement element = context.getElement().orElse(null);
        return AnnotationUtils.findAnnotation((AnnotatedElement)element, CacioTest.class).map(annotation -> ConditionEvaluationResult.enabled((String)"@GUITest is present")).orElse(ConditionEvaluationResult.enabled((String)"@GUITest is not present"));
    }

    private static void injectClassIntoBootstrapClassLoader(Class ... classes) throws IOException {
        for (Class clazz : classes) {
            byte[] buffer = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/').concat(".class")).readAllBytes();
            ClassInjector.UsingUnsafe injector = new ClassInjector.UsingUnsafe(null);
            injector.injectRaw(Map.of(clazz.getName(), buffer));
        }
    }

    static {
        try {
            ByteBuddyAgent.install();
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
            MODIFIERS = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
        try {
            CacioExtension.injectCTCGraphicsEnvironment();
            Field toolkit = Toolkit.class.getDeclaredField("toolkit");
            toolkit.setAccessible(true);
            toolkit.set(null, (Object)new CTCToolkit());
            Field defaultHeadlessField = GraphicsEnvironment.class.getDeclaredField("defaultHeadless");
            defaultHeadlessField.setAccessible(true);
            defaultHeadlessField.set(null, Boolean.FALSE);
            Field headlessField = GraphicsEnvironment.class.getDeclaredField("headless");
            headlessField.setAccessible(true);
            headlessField.set(null, Boolean.FALSE);
            Class<?> smfCls = Class.forName("sun.java2d.SurfaceManagerFactory");
            Field smf = smfCls.getDeclaredField("instance");
            smf.setAccessible(true);
            smf.set(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setProperty("swing.defaultlaf", MetalLookAndFeel.class.getName());
    }

    public static class GraphicsEnvironmentInterceptor {
        @RuntimeType
        public static Object intercept(@Origin Method method, @AllArguments Object[] args) throws Exception {
            return CTCGraphicsEnvironment.getInstance();
        }
    }
}

