/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer.managed;

import com.github.caciocavallosilano.cacio.peer.CacioComponent;
import com.github.caciocavallosilano.cacio.peer.PlatformToplevelWindow;
import com.github.caciocavallosilano.cacio.peer.managed.AbstractManagedWindowContainer;
import com.github.caciocavallosilano.cacio.peer.managed.EventData;
import com.github.caciocavallosilano.cacio.peer.managed.FocusManager;
import com.github.caciocavallosilano.cacio.peer.managed.ManagedWindowContainer;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.peer.ContainerPeer;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sun.awt.ConstrainableGraphics;
import sun.java2d.pipe.Region;

class ManagedWindow
extends AbstractManagedWindowContainer
implements PlatformToplevelWindow {
    private ManagedWindowContainer parent;
    private CacioComponent cacioComponent;
    private int x;
    private int y;
    private int width;
    private int height;
    private Color background;
    private Color foreground;
    private Font font;
    private boolean visible;

    ManagedWindow(ManagedWindowContainer p, CacioComponent cacioComp) {
        this.parent = p;
        this.cacioComponent = cacioComp;
        this.parent.add(this);
        Component c = this.cacioComponent.getAWTComponent();
        this.setBounds(c.getX(), c.getY(), c.getWidth(), c.getHeight(), 0);
    }

    @Override
    public ColorModel getColorModel() {
        return this.parent.getColorModel();
    }

    @Override
    public Graphics2D getClippedGraphics(Color bg, Color fg, Font font, List<Rectangle> clipRects) {
        if (clipRects != null) {
            for (Rectangle r : clipRects) {
                r.x += this.x;
                r.y += this.y;
            }
        }
        return this.prepareClippedGraphics(bg, fg, font, clipRects);
    }

    @Override
    public Graphics2D getGraphics(Color fg, Color bg, Font font) {
        LinkedList<Rectangle> clips;
        Deque children = this.getChildren();
        if (children != null && ((LinkedList)children).size() > 0) {
            clips = new LinkedList<Rectangle>();
            for (ManagedWindow child : children) {
                if (!child.isVisible()) continue;
                clips.add(child.getBounds());
            }
        } else {
            clips = null;
        }
        Graphics2D g2d = this.getClippedGraphics(fg, bg, font, clips);
        return g2d;
    }

    private Graphics2D prepareClippedGraphics(Color fg, Color bg, Font font, List<Rectangle> clipRects) {
        Graphics2D pg = this.parent.getClippedGraphics(fg, bg, font, clipRects = this.addClipRects(clipRects));
        if (pg instanceof ConstrainableGraphics) {
            ((ConstrainableGraphics)((Object)pg)).constrain(this.x, this.y, this.width, this.height);
        } else {
            pg = (Graphics2D)pg.create(this.x, this.y, this.width, this.height);
        }
        return pg;
    }

    private List<Rectangle> addClipRects(List<Rectangle> clipRects) {
        Deque<ManagedWindow> siblings = this.parent.getChildren();
        if (siblings.getLast() != this) {
            ManagedWindow sibling;
            if (clipRects == null) {
                clipRects = new LinkedList<Rectangle>();
            }
            Iterator<ManagedWindow> i = siblings.descendingIterator();
            Rectangle myBounds = this.getBounds();
            while (i.hasNext() && (sibling = i.next()) != this) {
                Rectangle bounds;
                if (!sibling.isVisible() || !(bounds = sibling.getBounds()).intersects(myBounds)) continue;
                clipRects.add(bounds);
            }
        }
        return clipRects;
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.parent.getGraphicsConfiguration();
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        this.parent.remove(this);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        int oldX = this.x;
        int oldY = this.y;
        int oldW = this.width;
        int oldH = this.height;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (this.isVisible()) {
            this.parent.repaint(oldX, oldY, oldW, oldH);
            this.parent.repaint(x, y, width, height);
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Point getLocationOnScreen() {
        Point p = this.parent.getLocationOnScreen();
        p.x += this.x;
        p.y += this.y;
        return p;
    }

    @Override
    public boolean canDetermineObscurity() {
        return true;
    }

    @Override
    public boolean isObscured() {
        return this.isRegionObscured(0, 0, this.width, this.height);
    }

    private boolean isRegionObscured(int x, int y, int w, int h) {
        return this.isParentObscured(x, y, w, h) || this.hasOverlappingSiblings(x, y, w, h);
    }

    private boolean isParentObscured(int x, int y, int w, int h) {
        boolean isParentObscured;
        ManagedWindowContainer parent = this.getParent();
        if (parent instanceof ManagedWindow) {
            ManagedWindow p = (ManagedWindow)parent;
            isParentObscured = p.isRegionObscured(x + this.x, y + this.y, w, h);
        } else {
            isParentObscured = false;
        }
        return isParentObscured;
    }

    private boolean hasOverlappingSiblings(int x, int y, int w, int h) {
        ManagedWindow sibling;
        Deque<ManagedWindow> siblings = this.getParent().getChildren();
        boolean hasOverlappingSiblings = false;
        Rectangle myBounds = new Rectangle(x, y, w, h);
        Iterator<ManagedWindow> descIter = siblings.descendingIterator();
        while (descIter.hasNext() && !hasOverlappingSiblings && (sibling = descIter.next()) != this) {
            Rectangle siblingBounds = sibling.getBounds();
            hasOverlappingSiblings = myBounds.intersects(siblingBounds);
        }
        return hasOverlappingSiblings;
    }

    @Override
    public void applyShape(Region shape) {
    }

    @Override
    public boolean isReparentSuppored() {
        return false;
    }

    @Override
    public void reparent(ContainerPeer newContainer) {
    }

    @Override
    public boolean isRestackSupported() {
        return false;
    }

    @Override
    public void restack() {
    }

    @Override
    public void setVisible(boolean v) {
        if (v != this.visible) {
            this.visible = v;
            Rectangle b = this.getBounds();
            b.y = 0;
            b.x = 0;
            this.triggerRepaint(b);
            for (ManagedWindow w : this.getChildren()) {
                if (!w.getCacioComponent().getAWTComponent().isVisible()) continue;
                w.setVisible(v);
            }
            FocusManager.getInstance().setVisible(this, v);
        }
    }

    private void triggerRepaint(Rectangle b) {
        Rectangle myBounds = this.getBounds();
        myBounds.y = 0;
        myBounds.x = 0;
        if (this.isVisible() && myBounds.contains(b) && !this.isRegionObscured(b.x, b.y, b.width, b.height)) {
            this.repaint(b.x, b.y, b.width, b.height);
        } else {
            ManagedWindowContainer c = this.getParent();
            if (c instanceof ManagedWindow) {
                ManagedWindow mw = (ManagedWindow)c;
                if (mw.isVisible()) {
                    b.x += this.x;
                    b.y += this.y;
                    ((ManagedWindow)c).triggerRepaint(b);
                }
            } else {
                c.repaint(b.x + this.x, b.y + this.y, b.width, b.height);
            }
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public void setMaximizedBounds(Rectangle bounds) {
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setBlocked(boolean blocked) {
    }

    CacioComponent getCacioComponent() {
        return this.cacioComponent;
    }

    public void dispatchEvent(AWTEvent event) {
        this.getCacioComponent().handlePeerEvent(event);
    }

    @Override
    protected boolean dispatchEventImpl(EventData event) {
        boolean dispatched = super.dispatchEventImpl(event);
        if (!dispatched) {
            event.setSource(this.cacioComponent.getAWTComponent());
            this.cacioComponent.handlePeerEvent(event.createAWTEvent());
            dispatched = true;
            if (event.getId() == 501) {
                FocusManager.getInstance().mousePressed(this);
            }
        }
        return dispatched;
    }

    void dispatchKeyEvent(EventData ev) {
        ev.setSource(this.cacioComponent.getAWTComponent());
        this.cacioComponent.handlePeerEvent(ev.createAWTEvent());
    }

    @Override
    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        throw new AWTException("Not yet supported.");
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
    }

    @Override
    public Image getBackBuffer() {
        return null;
    }

    ManagedWindowContainer getParent() {
        return this.parent;
    }

    @Override
    public void repaint(int x, int y, int w, int h) {
        CacioComponent cacioComp = this.getCacioComponent();
        Component awtComp = cacioComp.getAWTComponent();
        Rectangle area = new Rectangle(x, y, w, h);
        PaintEvent ev = new PaintEvent(awtComp, 801, area);
        cacioComp.handlePeerEvent(ev);
        super.repaint(x, y, w, h);
    }

    @Override
    public void requestFocus() {
        FocusManager.getInstance().setFocusedWindowNoEvent(this);
    }
}

