/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextAreaPeer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class CacioTextAreaPeer
extends CacioComponentPeer<TextArea, JScrollPane>
implements TextAreaPeer {
    private JTextArea textArea;

    public CacioTextAreaPeer(TextArea awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    JScrollPane initSwingComponent() {
        int vsp;
        int hsp;
        TextArea awtTextArea = (TextArea)this.getAWTComponent();
        this.textArea = new JTextArea();
        int sbv = awtTextArea.getScrollbarVisibility();
        if (sbv == 3) {
            hsp = 31;
            vsp = 21;
        } else if (sbv == 2) {
            hsp = 32;
            vsp = 21;
        } else if (sbv == 1) {
            hsp = 31;
            vsp = 22;
        } else {
            hsp = 32;
            vsp = 22;
        }
        JScrollPane sp = new JScrollPane(this.textArea, vsp, hsp);
        return sp;
    }

    @Override
    void postInitSwingComponent() {
        super.postInitSwingComponent();
        this.setText(((TextArea)this.getAWTComponent()).getText());
    }

    @Override
    public Dimension getMinimumSize(int rows, int columns) {
        return this.getPreferredSize(rows, columns);
    }

    @Override
    public Dimension getPreferredSize(int rows, int columns) {
        Font f = this.textArea.getFont();
        FontMetrics fm = this.textArea.getFontMetrics(f);
        int w = fm.charWidth('m') * columns;
        int h = fm.getHeight() * rows;
        Dimension spSize = ((JScrollPane)this.getSwingComponent()).getMinimumSize();
        spSize.width += w;
        spSize.height += h;
        return spSize;
    }

    @Override
    public void insert(String text, int pos) {
        this.getTextArea().insert(text, pos);
    }

    @Override
    public void replaceRange(String text, int start, int end) {
        this.getTextArea().replaceRange(text, start, end);
    }

    @Override
    public int getCaretPosition() {
        return this.getTextArea().getCaretPosition();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    @Override
    public int getSelectionEnd() {
        return this.getTextArea().getSelectionEnd();
    }

    @Override
    public int getSelectionStart() {
        return this.getTextArea().getSelectionStart();
    }

    @Override
    public String getText() {
        return this.getTextArea().getText();
    }

    @Override
    public void select(int selStart, int selEnd) {
        this.getTextArea().select(selStart, selEnd);
    }

    @Override
    public void setCaretPosition(int pos) {
        this.getTextArea().setCaretPosition(pos);
    }

    @Override
    public void setEditable(boolean editable) {
        this.getTextArea().setEditable(editable);
    }

    @Override
    public void setText(String text) {
        this.getTextArea().setText(text);
    }

    private JTextArea getTextArea() {
        return this.textArea;
    }

    @Override
    void setEnabledImpl(boolean enable) {
        super.setEnabledImpl(enable);
        this.getTextArea().setEnabled(enable);
    }
}

