/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.Scrollbar;
import java.awt.peer.ScrollbarPeer;
import javax.swing.JScrollBar;

class CacioScrollBarPeer
extends CacioComponentPeer<Scrollbar, JScrollBar>
implements ScrollbarPeer {
    CacioScrollBarPeer(Scrollbar sb, PlatformWindowFactory pwf) {
        super(sb, pwf);
    }

    @Override
    JScrollBar initSwingComponent() {
        int swingOrientation;
        Scrollbar sb = (Scrollbar)this.getAWTComponent();
        int orientation = sb.getOrientation();
        if (orientation == 0) {
            swingOrientation = 0;
        } else {
            assert (orientation == 1);
            swingOrientation = 1;
        }
        return new JScrollBar(swingOrientation);
    }

    @Override
    void postInitSwingComponent() {
        super.postInitSwingComponent();
        Scrollbar sb = (Scrollbar)this.getAWTComponent();
        this.setValues(sb.getValue(), sb.getVisibleAmount(), sb.getMinimum(), sb.getMaximum());
        this.setLineIncrement(sb.getUnitIncrement());
        this.setPageIncrement(sb.getBlockIncrement());
    }

    @Override
    public void setValues(int value, int visible, int minimum, int maximum) {
        ((JScrollBar)this.getSwingComponent()).setValues(value, visible, minimum, maximum);
    }

    @Override
    public void setLineIncrement(int l) {
        ((JScrollBar)this.getSwingComponent()).setUnitIncrement(l);
    }

    @Override
    public void setPageIncrement(int l) {
        ((JScrollBar)this.getSwingComponent()).setBlockIncrement(l);
    }
}

