/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioDialogPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.FileDialog;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.JRootPane;
import javax.swing.filechooser.FileFilter;

class CacioFileDialogPeer
extends CacioDialogPeer
implements FileDialogPeer {
    private JFileChooser fileChooser;

    CacioFileDialogPeer(FileDialog d, PlatformWindowFactory pwf) {
        super(d, pwf);
    }

    @Override
    void postInitSwingComponent() {
        super.postInitSwingComponent();
        this.fileChooser = new JFileChooser();
        ((JRootPane)this.getSwingComponent()).getContentPane().add(this.fileChooser);
        ((JRootPane)this.getSwingComponent()).layout();
        FileDialog fd = (FileDialog)this.getAWTComponent();
        this.setFile(fd.getFile());
        this.setDirectory(fd.getDirectory());
        this.setFilenameFilter(fd.getFilenameFilter());
    }

    @Override
    public void setFile(String file) {
        this.fileChooser.setSelectedFile(new File(file));
    }

    @Override
    public void setDirectory(String dir) {
        System.err.println("setting dir: " + dir);
        this.fileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void setFilenameFilter(FilenameFilter filter) {
        this.fileChooser.setFileFilter(new ProxyFilter(filter));
    }

    private static class ProxyFilter
    extends FileFilter {
        private FilenameFilter target;

        ProxyFilter(FilenameFilter f) {
            this.target = f;
        }

        @Override
        public boolean accept(File f) {
            return this.target.accept(f.getAbsoluteFile().getParentFile(), f.getName());
        }

        @Override
        public String getDescription() {
            return "No description";
        }
    }
}

