/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponent;
import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import sun.awt.AWTAutoShutdown;
import sun.awt.PaintEventDispatcher;

public abstract class CacioEventPump<ET>
implements Runnable {
    private static final int BUTTON_DOWN_MASK = 7168;
    private int lastModifierState;

    protected CacioEventPump() {
    }

    protected void start() {
        Thread t = new Thread((Runnable)this, "CacioEventPump");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public final void run() {
        AWTAutoShutdown.notifyToolkitThreadBusy();
        while (!Thread.interrupted()) {
            try {
                AWTAutoShutdown.notifyToolkitThreadFree();
                ET nativeEvent = this.fetchNativeEvent();
                AWTAutoShutdown.notifyToolkitThreadBusy();
                this.dispatchNativeEvent(nativeEvent);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    protected abstract ET fetchNativeEvent() throws InterruptedException;

    protected abstract void dispatchNativeEvent(ET var1);

    protected final void postMouseEvent(CacioComponent source, int id, long time, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
        int button;
        if (id == 506) {
            button = this.getButton(modifiers);
        } else {
            int modifierChange = this.lastModifierState ^ modifiers;
            button = this.getButton(modifierChange);
            this.lastModifierState = modifiers;
        }
        MouseEvent ev = new MouseEvent(source.getAWTComponent(), id, time, modifiers, x, y, clickCount, popupTrigger, button);
        this.postEvent(source, ev);
    }

    private int getButton(int theModifierChange) {
        switch (theModifierChange & 0x1C00) {
            case 1024: {
                return 1;
            }
            case 2048: {
                return 2;
            }
            case 4096: {
                return 3;
            }
        }
        return 0;
    }

    protected final void postKeyEvent(CacioComponent source, int id, long time, int modifiers, int keyCode) {
        KeyEvent ke = new KeyEvent(source.getAWTComponent(), id, time, modifiers, keyCode, '\uffff');
        this.postEvent(source, ke);
    }

    protected final void postKeyTypedEvent(CacioComponent source, int id, long time, int modifiers, char keyChar) {
        KeyEvent ke = new KeyEvent(source.getAWTComponent(), id, time, modifiers, 0, keyChar);
        this.postEvent(source, ke);
    }

    protected final void postComponentEvent(CacioComponent source, int id) {
        ComponentEvent ev = new ComponentEvent(source.getAWTComponent(), id);
        this.postEvent(source, ev);
    }

    protected final void postPaintEvent(CacioComponent source, int x, int y, int width, int height, boolean paintBackground) {
        if (paintBackground) {
            ((CacioComponentPeer)source).clearBackground();
        }
        PaintEvent ev = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent(source.getAWTComponent(), x, y, width, height);
        this.postEvent(source, ev);
    }

    protected final void postPaintEvent(CacioComponent source, int x, int y, int width, int height) {
        this.postPaintEvent(source, x, y, width, height, false);
    }

    protected final void postFocusEvent(CacioComponent source, int id, boolean temporary, CacioComponent opposite) {
        Component awtComponent = null;
        if (opposite != null) {
            awtComponent = opposite.getAWTComponent();
        }
        FocusEvent ev = new FocusEvent(source.getAWTComponent(), id, temporary, awtComponent);
        this.postEvent(source, ev);
    }

    protected final void postWindwoEvent(CacioComponent source, int id, int oldState, int newState) {
        WindowEvent ev = id == 209 ? new WindowEvent((Window)source.getAWTComponent(), id, oldState, newState) : new WindowEvent((Window)source.getAWTComponent(), id);
        this.postEvent(source, ev);
    }

    private void postEvent(CacioComponent c, AWTEvent ev) {
        c.handlePeerEvent(ev);
    }
}

