/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.util;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.util.TTKeyValueStore;
import com.tiktok.util.TTLogger;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class TTUtil {
    private static final String TAG = TTUtil.class.getName();
    private static final TTLogger logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());

    public static void checkThread(String tag) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            TTCrashHandler.handleCrash(tag, new IllegalStateException("Current method should be called in a non-main thread"));
        }
    }

    public static String ppStr(JSONObject o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString(4);
        }
        catch (JSONException e) {
            return "";
        }
    }

    public static String ppStr(String str) {
        try {
            return TTUtil.ppStr(new JSONObject(str));
        }
        catch (JSONException e) {
            return "";
        }
    }

    public static String getOrGenAnoId(Context context, boolean forceGenerate) {
        TTKeyValueStore store = new TTKeyValueStore(context);
        String anoId = store.get("com.tiktok.sdk.anonymousId");
        if (anoId == null || forceGenerate) {
            anoId = UUID.randomUUID().toString();
            store.set("com.tiktok.sdk.anonymousId", anoId);
            logger.info("AnonymousId reset to " + anoId, new Object[0]);
        }
        return anoId;
    }

    public static String escapeHTML(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\'' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String mapToString(Map<String, Object> map, String separator) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            buf.append(entry.getKey() + "=" + TTUtil.escapeHTML(entry.getValue().toString()) + "&");
        }
        String finalStr = buf.toString();
        return finalStr.substring(0, finalStr.length() - 1);
    }

    public static JSONObject getMetaWithTS(@Nullable Long ts) {
        if (ts == null) {
            ts = System.currentTimeMillis();
        }
        try {
            return new JSONObject().put("ts", (Object)ts);
        }
        catch (Exception exception) {
            return new JSONObject();
        }
    }

    public static JSONObject getMonitorException(@Nullable Throwable ex, @Nullable Long ts) {
        JSONObject monitor = new JSONObject();
        try {
            monitor.put("type", (Object)"exception");
            monitor.put("name", (Object)"exception");
            monitor.put("meta", (Object)TTUtil.getMetaException(ex, ts));
            monitor.put("extra", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return monitor;
    }

    public static JSONObject getMetaException(@Nullable Throwable ex, @Nullable Long ts) {
        JSONObject meta = TTUtil.getMetaWithTS(ts);
        try {
            if (ex != null) {
                Throwable rootCause;
                for (rootCause = ex; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
                }
                meta.put("ex_class", (Object)rootCause.getStackTrace()[0].getClassName());
                meta.put("ex_method", (Object)rootCause.getStackTrace()[0].getMethodName());
                String argMsg = rootCause.getStackTrace()[0].getFileName() + " " + rootCause.getStackTrace()[0].getLineNumber();
                meta.put("ex_args", (Object)argMsg);
                meta.put("ex_msg", (Object)rootCause.getMessage());
                int stackLimit = 15;
                Object[] st = new String[15];
                for (int i = 0; i < 15; ++i) {
                    if (rootCause.getStackTrace()[i] == null) continue;
                    st[i] = rootCause.getStackTrace()[i].toString();
                }
                meta.put("ex_stack", (Object)Arrays.toString(st));
                meta.put("success", false);
            } else {
                meta.put("success", true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return meta;
    }
}

