/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.util;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.webkit.WebSettings;
import androidx.annotation.RequiresApi;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.util.TTUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Locale;
import org.json.JSONObject;

public class SystemInfoUtil {
    static PackageManager pm;
    static PackageInfo packageInfo;
    static Application application;
    private static String userAgent;

    public static String getPackageName() {
        return SystemInfoUtil.packageInfo.packageName;
    }

    public static String getAppName() {
        return application.getApplicationInfo().loadLabel(pm).toString();
    }

    public static String getSDKVersion() {
        return "1.2.10";
    }

    public static String getAppVersionName() {
        if (packageInfo == null) {
            return "";
        }
        return SystemInfoUtil.packageInfo.versionName;
    }

    public static int getAppVersionCode() {
        if (packageInfo == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return (int)packageInfo.getLongVersionCode();
        }
        return SystemInfoUtil.packageInfo.versionCode;
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            return "";
        }
        return "";
    }

    public static String getLocale() {
        return Locale.getDefault().getLanguage();
    }

    @RequiresApi(api=17)
    public static void initUserAgent() {
        if (userAgent != null) {
            return;
        }
        long initTimeMS = System.currentTimeMillis();
        TikTokBusinessSdk.getAppEventLogger().monitorMetric("ua_init", TTUtil.getMetaWithTS(initTimeMS), null);
        Exception ex = null;
        try {
            userAgent = WebSettings.getDefaultUserAgent((Context)TikTokBusinessSdk.getApplicationContext());
        }
        catch (Exception e) {
            ex = e;
            userAgent = System.getProperty("http.agent");
        }
        if (userAgent == null) {
            userAgent = "";
        }
        long endTimeMS = System.currentTimeMillis();
        try {
            JSONObject meta = TTUtil.getMetaException(ex, endTimeMS).put("latency", endTimeMS - initTimeMS);
            TikTokBusinessSdk.getAppEventLogger().monitorMetric("ua_end", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            SystemInfoUtil.initUserAgent();
        }
        return userAgent;
    }

    public static String getAndroidVersion() {
        return Build.VERSION.SDK_INT + "";
    }

    public static String getNetworkClass(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getActiveNetworkInfo();
            if (info == null || !info.isConnected()) {
                return "-";
            }
            if (info.getType() == 1) {
                return "WIFI";
            }
            if (info.getType() == 0) {
                int networkType = info.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return "2G";
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return "3G";
                    }
                    case 13: 
                    case 18: 
                    case 19: {
                        return "4G";
                    }
                    case 20: {
                        return "5G";
                    }
                }
                return "?";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "?";
    }

    static {
        try {
            application = TikTokBusinessSdk.getApplicationContext();
            pm = application.getPackageManager();
            packageInfo = pm.getPackageInfo(TikTokBusinessSdk.getApplicationContext().getPackageName(), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        userAgent = null;
    }
}

