/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.util;

import androidx.annotation.Nullable;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.util.TTUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class HttpRequestUtil {
    private static final String MONITOR_API_TYPE = "/app/monitor/";
    private static final String API_ERR = "api_err";
    private static final String TAG = HttpRequestUtil.class.getCanonicalName();

    public static String doGet(String url, Map<String, String> headerParamMap) {
        HttpRequestOptions options = new HttpRequestOptions();
        options.connectTimeout = 2000;
        options.readTimeout = 5000;
        return HttpRequestUtil.doGet(url, headerParamMap, options);
    }

    public static HttpsURLConnection connect(String url, Map<String, String> headerParamMap, HttpRequestOptions options, String method, String contentLength) {
        HttpsURLConnection connection;
        block8: {
            connection = null;
            try {
                URL httpURL = new URL(url);
                connection = (HttpsURLConnection)httpURL.openConnection();
                connection.setRequestMethod(method);
                options.configConnection(connection);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                if (method.equals("GET")) {
                    connection.setDoOutput(false);
                } else if (method.equals("POST")) {
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Content-Length", contentLength);
                }
                for (Map.Entry<String, String> entry : headerParamMap.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                connection.connect();
            }
            catch (Exception e) {
                TTCrashHandler.handleCrash(TAG, e);
                if (connection == null) break block8;
                try {
                    connection.disconnect();
                }
                catch (Exception exc) {
                    TTCrashHandler.handleCrash(TAG, exc);
                }
            }
        }
        return connection;
    }

    public static boolean shouldRedirect(int status) {
        return status != 200 && (status == 302 || status == 301 || status == 303 || status == 307);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> headerParamMap, HttpRequestOptions options) {
        long initTimeMS = System.currentTimeMillis();
        String result = null;
        int responseCode = 0;
        String apiType = "";
        try {
            URL uri = new URL(url);
            apiType = uri.getPath().contains(TikTokBusinessSdk.getApiAvailableVersion()) ? uri.getPath().split(TikTokBusinessSdk.getApiAvailableVersion())[1] : uri.getPath().split("open_api")[1];
        }
        catch (MalformedURLException uri) {
            // empty catch block
        }
        HttpsURLConnection connection = HttpRequestUtil.connect(url, headerParamMap, options, "GET", null);
        if (connection == null) {
            return result;
        }
        try {
            boolean redirect = HttpRequestUtil.shouldRedirect(connection.getResponseCode());
            if (redirect) {
                String redirectUrl = connection.getHeaderField("Location");
                connection.disconnect();
                connection = HttpRequestUtil.connect(redirectUrl, headerParamMap, options, "GET", null);
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                result = HttpRequestUtil.streamToString(connection.getInputStream());
            }
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    TTCrashHandler.handleCrash(TAG, e);
                }
            }
        }
        long endTimeMS = System.currentTimeMillis();
        try {
            if (HttpRequestUtil.getCodeFromApi(result) != 0) {
                JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS).put("api_type", (Object)apiType).put("status_code", responseCode).put("log_id", (Object)HttpRequestUtil.getLogIDFromApi(result));
                TikTokBusinessSdk.getAppEventLogger().monitorMetric(API_ERR, meta, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String doPost(String url, Map<String, String> headerParamMap, String jsonStr) {
        HttpRequestOptions options = new HttpRequestOptions();
        options.connectTimeout = 2000;
        options.readTimeout = 5000;
        return HttpRequestUtil.doPost(url, headerParamMap, jsonStr, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> headerParamMap, String jsonStr, HttpRequestOptions options) {
        long initTimeMS = System.currentTimeMillis();
        String result = null;
        int responseCode = 0;
        String apiType = "";
        try {
            URL uri = new URL(url);
            apiType = uri.getPath().contains(TikTokBusinessSdk.getApiAvailableVersion()) ? uri.getPath().split(TikTokBusinessSdk.getApiAvailableVersion())[1] : uri.getPath().split("open_api")[1];
        }
        catch (MalformedURLException uri) {
            // empty catch block
        }
        HttpURLConnection connection = null;
        OutputStream outputStream = null;
        try {
            byte[] writeBytes = jsonStr.getBytes("UTF-8");
            String contentLength = String.valueOf(writeBytes.length);
            connection = HttpRequestUtil.connect(url, headerParamMap, options, "POST", contentLength);
            if (connection == null) {
                String string = result;
                return string;
            }
            outputStream = connection.getOutputStream();
            outputStream.write(writeBytes);
            outputStream.flush();
            boolean redirect = HttpRequestUtil.shouldRedirect(connection.getResponseCode());
            if (redirect) {
                String redirectUrl = connection.getHeaderField("Location");
                connection.disconnect();
                connection = HttpRequestUtil.connect(redirectUrl, headerParamMap, options, "POST", contentLength);
                outputStream = connection.getOutputStream();
                outputStream.write(writeBytes);
                outputStream.flush();
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                result = HttpRequestUtil.streamToString(connection.getInputStream());
            }
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    TTCrashHandler.handleCrash(TAG, e);
                }
            }
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    TTCrashHandler.handleCrash(TAG, e);
                }
            }
        }
        long endTimeMS = System.currentTimeMillis();
        try {
            if (HttpRequestUtil.getCodeFromApi(result) != 0 && !url.contains(MONITOR_API_TYPE)) {
                JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS).put("api_type", (Object)apiType).put("status_code", responseCode).put("log_id", (Object)HttpRequestUtil.getLogIDFromApi(result));
                TikTokBusinessSdk.getAppEventLogger().monitorMetric(API_ERR, meta, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String streamToString(InputStream is) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString().trim();
            return string;
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
            return null;
        }
    }

    public static int getCodeFromApi(@Nullable String resp) {
        if (resp != null) {
            try {
                JSONObject respJson = new JSONObject(resp);
                return respJson.getInt("code");
            }
            catch (Exception ignored) {
                return -2;
            }
        }
        return -1;
    }

    public static String getLogIDFromApi(@Nullable String resp) {
        if (resp != null) {
            try {
                JSONObject respJson = new JSONObject(resp);
                return respJson.getString("request_id");
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public static class HttpRequestOptions {
        private static int UNSET = -1;
        public int connectTimeout = UNSET;
        public int readTimeout = UNSET;

        public void configConnection(HttpURLConnection connection) {
            if (this.connectTimeout != UNSET) {
                connection.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != UNSET) {
                connection.setReadTimeout(this.readTimeout);
            }
        }
    }
}

