/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.content.Context;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.util.TTUtil;
import java.io.Serializable;
import java.security.MessageDigest;
import org.json.JSONObject;

public class TTUserInfo
implements Cloneable,
Serializable {
    static final String TAG = TTUserInfo.class.getName();
    String anonymousId;
    String externalId;
    String externalUserName;
    String phoneNumber;
    String email;
    transient boolean isIdentified = false;
    public static volatile TTUserInfo sharedInstance = new TTUserInfo();

    public static void reset(Context context, boolean forceGenerateAnoId) {
        TTUserInfo.sharedInstance.anonymousId = TTUtil.getOrGenAnoId(context, forceGenerateAnoId);
        TTUserInfo.sharedInstance.externalId = null;
        TTUserInfo.sharedInstance.externalUserName = null;
        TTUserInfo.sharedInstance.phoneNumber = null;
        TTUserInfo.sharedInstance.email = null;
        TTUserInfo.sharedInstance.isIdentified = false;
    }

    private String toSha256(String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes());
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            return result.toString();
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
            return null;
        }
    }

    public boolean isIdentified() {
        return this.isIdentified;
    }

    public void setIdentified() {
        this.isIdentified = true;
    }

    public void setExternalId(String externalId) {
        this.externalId = this.toSha256(externalId);
    }

    public void setExternalUserName(String externalUserName) {
        this.externalUserName = this.toSha256(externalUserName);
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = this.toSha256(phoneNumber);
    }

    public void setEmail(String email) {
        this.email = this.toSha256(email);
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("anonymous_id", (Object)this.anonymousId);
            if (this.externalId != null) {
                jsonObject.put("external_id", (Object)this.externalId);
            }
            if (this.externalUserName != null) {
                jsonObject.put("external_username", (Object)this.externalUserName);
            }
            if (this.phoneNumber != null) {
                jsonObject.put("phone_number", (Object)this.phoneNumber);
            }
            if (this.email != null) {
                jsonObject.put("email", (Object)this.email);
            }
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
        return jsonObject;
    }

    public TTUserInfo clone() {
        try {
            return (TTUserInfo)super.clone();
        }
        catch (Exception e) {
            return new TTUserInfo();
        }
    }
}

