/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEvent;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.appevents.TTIdentifierFactory;
import com.tiktok.util.SystemInfoUtil;
import com.tiktok.util.TTUtil;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class TTRequestBuilder {
    private static final String TAG = TTRequestBuilder.class.getCanonicalName();
    private static JSONObject basePayloadCache = null;
    private static JSONObject healthBasePayloadCache = null;
    private static JSONObject contextForApiCache = null;

    TTRequestBuilder() {
    }

    public static JSONObject getBasePayload() {
        TTUtil.checkThread(TAG);
        if (basePayloadCache != null) {
            return basePayloadCache;
        }
        JSONObject result = new JSONObject();
        try {
            if (TikTokBusinessSdk.onlyAppIdProvided()) {
                result.put("app_id", (Object)TikTokBusinessSdk.getAppId());
            } else {
                result.put("tiktok_app_id", (Object)TikTokBusinessSdk.getTTAppId());
            }
            if (TikTokBusinessSdk.isInSdkDebugMode().booleanValue()) {
                result.put("test_event_code", (Object)TikTokBusinessSdk.getTestEventCode());
            }
            result.put("event_source", (Object)"APP_EVENTS_SDK");
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
            basePayloadCache = new JSONObject();
            return basePayloadCache;
        }
        basePayloadCache = result;
        return result;
    }

    private static JSONObject getImmutableContextForApi() throws JSONException {
        if (contextForApiCache != null) {
            return contextForApiCache;
        }
        TTIdentifierFactory.AdIdInfo adIdInfo = null;
        long initTimeMS = System.currentTimeMillis();
        TikTokBusinessSdk.getAppEventLogger().monitorMetric("did_start", TTUtil.getMetaWithTS(initTimeMS), null);
        if (TikTokBusinessSdk.isGaidCollectionEnabled()) {
            adIdInfo = TTIdentifierFactory.getGoogleAdIdInfo((Context)TikTokBusinessSdk.getApplicationContext());
        }
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(endTimeMS).put("latency", endTimeMS - initTimeMS).put("success", adIdInfo.getAdId() != null && adIdInfo.getAdId() != "");
            TikTokBusinessSdk.getAppEventLogger().monitorMetric("did_end", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        contextForApiCache = TTRequestBuilder.contextBuilder(adIdInfo);
        return contextForApiCache;
    }

    public static JSONObject getContextForApi(TTAppEvent event) throws JSONException {
        JSONObject immutablePart = TTRequestBuilder.getImmutableContextForApi();
        JSONObject finalObj = new JSONObject(immutablePart.toString());
        finalObj.put("user", (Object)event.getUserInfo().toJsonObject());
        return finalObj;
    }

    private static Locale getCurrentLocale() {
        Application context = TikTokBusinessSdk.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 24) {
            return context.getResources().getConfiguration().getLocales().get(0);
        }
        return context.getResources().getConfiguration().locale;
    }

    static String getBcp47Language() {
        Locale loc = TTRequestBuilder.getCurrentLocale();
        if (Build.VERSION.SDK_INT >= 21) {
            return loc.toLanguageTag();
        }
        int SEP = 45;
        String language = loc.getLanguage();
        String region = loc.getCountry();
        String variant = loc.getVariant();
        if (language.equals("no") && region.equals("NO") && variant.equals("NY")) {
            language = "nn";
            region = "NO";
            variant = "";
        }
        if (language.isEmpty() || !language.matches("\\p{Alpha}{2,8}")) {
            language = "und";
        } else if (language.equals("iw")) {
            language = "he";
        } else if (language.equals("in")) {
            language = "id";
        } else if (language.equals("ji")) {
            language = "yi";
        }
        if (!region.matches("\\p{Alpha}{2}|\\p{Digit}{3}")) {
            region = "";
        }
        if (!variant.matches("\\p{Alnum}{5,8}|\\p{Digit}\\p{Alnum}{3}")) {
            variant = "";
        }
        StringBuilder bcp47Tag = new StringBuilder(language);
        if (!region.isEmpty()) {
            bcp47Tag.append('-').append(region);
        }
        if (!variant.isEmpty()) {
            bcp47Tag.append('-').append(variant);
        }
        return bcp47Tag.toString();
    }

    private static JSONObject contextBuilder(@Nullable TTIdentifierFactory.AdIdInfo adIdInfo) throws JSONException {
        JSONObject app = new JSONObject();
        if (TikTokBusinessSdk.bothIdsProvided()) {
            app.put("id", (Object)TikTokBusinessSdk.getAppId());
        }
        app.put("name", (Object)SystemInfoUtil.getAppName());
        app.put("namespace", (Object)SystemInfoUtil.getPackageName());
        app.put("version", (Object)SystemInfoUtil.getAppVersionName());
        app.put("build", (Object)(SystemInfoUtil.getAppVersionCode() + ""));
        JSONObject device = new JSONObject();
        device.put("platform", (Object)"Android");
        device.put("version", (Object)SystemInfoUtil.getAndroidVersion());
        if (adIdInfo != null) {
            device.put("gaid", (Object)adIdInfo.getAdId());
        }
        JSONObject library = new JSONObject();
        library.put("name", (Object)"bytedance/tiktok-business-android-sdk");
        library.put("version", (Object)SystemInfoUtil.getSDKVersion());
        JSONObject context = new JSONObject();
        context.put("app", (Object)app);
        context.put("library", (Object)library);
        context.put("device", (Object)device);
        context.put("locale", (Object)TTRequestBuilder.getBcp47Language());
        context.put("ip", (Object)SystemInfoUtil.getLocalIpAddress());
        String userAgent = SystemInfoUtil.getUserAgent();
        if (userAgent != null) {
            context.put("user_agent", (Object)userAgent);
        }
        return context;
    }

    private static JSONObject enrichDeviceBase(JSONObject d) throws JSONException {
        JSONObject device = new JSONObject(d.toString());
        device.put("id", (Object)TTUtil.getOrGenAnoId((Context)TikTokBusinessSdk.getApplicationContext(), false));
        device.put("user_agent", (Object)SystemInfoUtil.getUserAgent());
        device.put("ip", (Object)SystemInfoUtil.getLocalIpAddress());
        device.put("network", (Object)SystemInfoUtil.getNetworkClass((Context)TikTokBusinessSdk.getApplicationContext()));
        device.put("session", (Object)TikTokBusinessSdk.getSessionID());
        device.put("locale", (Object)TTRequestBuilder.getBcp47Language());
        device.put("ts", System.currentTimeMillis() - SystemClock.elapsedRealtime());
        return device;
    }

    public static JSONObject getHealthMonitorBase() throws JSONException {
        if (healthBasePayloadCache != null) {
            healthBasePayloadCache.put("device", (Object)TTRequestBuilder.enrichDeviceBase(healthBasePayloadCache.getJSONObject("device")));
            return healthBasePayloadCache;
        }
        JSONObject finalObj = new JSONObject();
        JSONObject app = new JSONObject(TTRequestBuilder.getImmutableContextForApi().getJSONObject("app").toString());
        app.put("app_namespace", (Object)SystemInfoUtil.getPackageName());
        finalObj.put("app", (Object)app);
        finalObj.put("library", TTRequestBuilder.getImmutableContextForApi().get("library"));
        finalObj.put("device", (Object)TTRequestBuilder.enrichDeviceBase(TTRequestBuilder.getImmutableContextForApi().getJSONObject("device")));
        finalObj.put("log_extra", null);
        healthBasePayloadCache = finalObj;
        return healthBasePayloadCache;
    }
}

