/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TTPurchaseItem {
    private final double price;
    private final int quantity;
    private final String contentType;
    private final String contentId;

    public TTPurchaseItem(double price, int quantity, String contentType, String contentId) {
        this.price = price;
        this.quantity = quantity;
        this.contentType = contentType;
        this.contentId = contentId;
    }

    public JSONObject toJSONObject() throws JSONException {
        return new JSONObject().put("price", this.price).put("quantity", this.quantity).put("content_type", (Object)this.contentType).put("content_id", (Object)this.contentId);
    }

    public static JSONObject buildPurchaseProperties(String currency, TTPurchaseItem ... items) throws JSONException {
        double value = 0.0;
        JSONArray contents = new JSONArray();
        for (TTPurchaseItem item : items) {
            double price = item.price;
            int quantity = item.quantity;
            contents.put((Object)item.toJSONObject());
            if (price == 0.0 || quantity == 0) continue;
            value += price * (double)quantity;
        }
        return new JSONObject().put("currency", (Object)currency).put("value", value).put("contents", (Object)contents);
    }
}

