/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import org.json.JSONObject;

public class TTPurchaseInfo {
    private final JSONObject purchase;
    private final JSONObject skuDetails;

    public TTPurchaseInfo(JSONObject purchase, JSONObject skuDetails) throws InvalidTTPurchaseInfoException {
        if (!this.isValidPurchase(purchase)) {
            throw new InvalidTTPurchaseInfoException("Not a valid purchase object");
        }
        if (!this.isValidSkuDetails(skuDetails)) {
            throw new InvalidTTPurchaseInfoException("Not a valid skuDetails Object");
        }
        if (!purchase.optString("productId").equals(skuDetails.optString("productId"))) {
            throw new InvalidTTPurchaseInfoException("Product Id does not match");
        }
        this.purchase = purchase;
        this.skuDetails = skuDetails;
    }

    public JSONObject getPurchase() {
        return this.purchase;
    }

    public JSONObject getSkuDetails() {
        return this.skuDetails;
    }

    private boolean isValidPurchase(JSONObject purchase) {
        return !purchase.isNull("orderId") && !purchase.isNull("productId");
    }

    private boolean isValidSkuDetails(JSONObject skuDetails) {
        return !skuDetails.isNull("price") && !skuDetails.isNull("productId");
    }

    public static class InvalidTTPurchaseInfoException
    extends Exception {
        public InvalidTTPurchaseInfoException(String str) {
            super(str);
        }
    }
}

