/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.appevents.TTPurchaseInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TTInAppPurchaseManager {
    static final String TAG = TTInAppPurchaseManager.class.getName();

    TTInAppPurchaseManager() {
    }

    static JSONObject getPurchaseProps(TTPurchaseInfo purchaseInfo) {
        String productId = null;
        try {
            productId = purchaseInfo.getPurchase().getString("productId");
            JSONObject skuDetail = purchaseInfo.getSkuDetails();
            return TTInAppPurchaseManager.getPurchaseProperties(productId, skuDetail);
        }
        catch (JSONException e) {
            TTCrashHandler.handleCrash(TAG, e);
            return null;
        }
    }

    private static JSONObject getPurchaseProperties(String sku, JSONObject skuDetails) throws JSONException {
        JSONObject props = new JSONObject();
        JSONObject content = new JSONObject().put("content_id", (Object)sku);
        if (skuDetails != null) {
            content.put("content_type", (Object)TTInAppPurchaseManager.safeJsonGetString(skuDetails, "type"));
            String currencyCode = TTInAppPurchaseManager.safeJsonGetString(skuDetails, "price_currency_code");
            props.put("currency", (Object)currencyCode);
            content.put("quantity", 1);
            String price = TTInAppPurchaseManager.safeJsonGetString(skuDetails, "price");
            double dPrice = 0.0;
            try {
                Pattern regex;
                Matcher matcher;
                if (!currencyCode.equals("") && !price.equals("") && (matcher = (regex = Pattern.compile("(\\d+(?:\\.\\d+)?)")).matcher(price)).find()) {
                    price = matcher.group(1);
                    dPrice = Double.parseDouble(price);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            content.put("price", dPrice);
            props.put("value", dPrice);
        }
        props.put("contents", (Object)new JSONArray().put((Object)content));
        return props;
    }

    private static String safeJsonGetString(JSONObject jsonObject, String key) {
        try {
            return jsonObject.get(key).toString();
        }
        catch (JSONException e) {
            return "";
        }
    }
}

