/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tiktok.appevents.TTAppEventLogger;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.appevents.TTPurchaseInfo;
import com.tiktok.appevents.TTUserInfo;
import com.tiktok.util.TTConst;
import com.tiktok.util.TTLogger;
import com.tiktok.util.TTUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class TikTokBusinessSdk {
    static final String TAG = TikTokBusinessSdk.class.getName();
    static volatile TikTokBusinessSdk ttSdk = null;
    public static volatile boolean isActivatedLogicRun = false;
    static TTAppEventLogger appEventLogger;
    private static final AtomicBoolean globalConfigFetched;
    private static Boolean sdkGlobalSwitch;
    private static String apiAvailableVersion;
    private static String apiTrackDomain;
    private static LogLevel logLevel;
    private static AtomicBoolean networkSwitch;
    private static AtomicBoolean sdkDebugModeSwitch;
    private static AtomicBoolean sdkLDUModeSwitch;
    private static String testEventCode;
    private static TTConfig config;
    private static TTLogger logger;
    private static final String sessionID;
    private static CrashListener onCrashListener;
    public static DiskStatusListener diskListener;
    public static MemoryListener memoryListener;
    public static NetworkListener networkListener;
    public static NextTimeFlushListener nextTimeFlushListener;

    private TikTokBusinessSdk(@NonNull TTConfig ttConfig) {
        logLevel = ttConfig.logLevel;
        logger = new TTLogger(TAG, logLevel);
        if (ttConfig.appId == null) {
            throw new IllegalArgumentException("app id not set");
        }
        if (ttConfig.ttAppId == null) {
            logger.warn("ttAppId not set, but its usage is encouraged", new Object[0]);
        }
        config = ttConfig;
        networkSwitch = new AtomicBoolean(ttConfig.autoStart);
        sdkDebugModeSwitch.set(ttConfig.debugModeSwitch);
        if (sdkDebugModeSwitch.get()) {
            testEventCode = this.createTestEventCode(ttConfig);
        }
        sdkLDUModeSwitch.set(ttConfig.lduModeSwitch);
    }

    private String createTestEventCode(@NonNull TTConfig ttConfig) {
        return ttConfig.ttAppId.toString();
    }

    public static synchronized boolean isInitialized() {
        return ttSdk != null;
    }

    public static synchronized void initializeSdk(TTConfig ttConfig) {
        if (ttSdk != null) {
            return;
        }
        long initTimeMS = System.currentTimeMillis();
        try {
            final Thread.UncaughtExceptionHandler existingExHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
                    if (TTCrashHandler.isTTSDKRelatedException(throwable)) {
                        TTCrashHandler.handleCrash(TAG, throwable);
                    }
                    if (TikTokBusinessSdk.getCrashListener() != null) {
                        TikTokBusinessSdk.getCrashListener().onCrash(thread, throwable);
                    }
                    if (existingExHandler != null) {
                        existingExHandler.uncaughtException(thread, throwable);
                    }
                }
            });
        }
        catch (Exception existingExHandler) {
            // empty catch block
        }
        ttSdk = new TikTokBusinessSdk(ttConfig);
        TTUserInfo.reset((Context)TikTokBusinessSdk.getApplicationContext(), false);
        appEventLogger = new TTAppEventLogger(ttConfig.autoEvent, ttConfig.disabledEvents, ttConfig.flushTime, ttConfig.disableMetrics, initTimeMS);
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(null).put("latency", endTimeMS - initTimeMS);
            appEventLogger.monitorMetric("init_end", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void startTrack() {
        if (!networkSwitch.get()) {
            networkSwitch.set(true);
            appEventLogger.forceFlush();
        }
    }

    public static void destroy() {
        ttSdk = null;
        memoryListener = null;
        diskListener = null;
        networkListener = null;
        nextTimeFlushListener = null;
        if (appEventLogger != null) {
            appEventLogger.destroy();
        }
    }

    public static synchronized void setUpSdkListeners(MemoryListener ml, DiskStatusListener dl, NetworkListener nl, NextTimeFlushListener nfl) {
        if (ml != null) {
            memoryListener = ml;
        }
        if (dl != null) {
            diskListener = dl;
        }
        if (nl != null) {
            networkListener = nl;
        }
        if (nfl != null) {
            nextTimeFlushListener = nfl;
        }
        TikTokBusinessSdk.flush();
    }

    public static void trackEvent(String event) {
        appEventLogger.track(event, null);
    }

    public static void trackEvent(String event, @Nullable JSONObject props) {
        appEventLogger.track(event, props);
    }

    public static void trackGooglePlayPurchase(List<TTPurchaseInfo> purchaseInfos) {
        appEventLogger.trackPurchase(purchaseInfos);
    }

    public static void trackGooglePlayPurchase(TTPurchaseInfo info) {
        TikTokBusinessSdk.trackGooglePlayPurchase(Collections.singletonList(info));
    }

    public static void flush() {
        appEventLogger.forceFlush();
    }

    public static void clearAll() {
        appEventLogger.clearAll();
    }

    public static Application getApplicationContext() {
        if (ttSdk == null) {
            throw new RuntimeException("TikTokBusinessSdk instance is not initialized");
        }
        return config.application;
    }

    public static boolean getNetworkSwitch() {
        return networkSwitch.get();
    }

    public static boolean isGaidCollectionEnabled() {
        return config.advertiserIDCollectionEnable;
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static String getAppId() {
        return config.appId;
    }

    public static BigInteger getTTAppId() {
        return config.ttAppId;
    }

    public static boolean onlyAppIdProvided() {
        if (config.appId == null) {
            throw new IllegalStateException("AppId should be checked before, this path should not be accessed");
        }
        return config.ttAppId == null;
    }

    public static boolean bothIdsProvided() {
        return !TikTokBusinessSdk.onlyAppIdProvided();
    }

    public static Boolean getSdkGlobalSwitch() {
        return sdkGlobalSwitch;
    }

    public static boolean isSystemActivated() {
        Boolean sdkGlobalSwitch = TikTokBusinessSdk.getSdkGlobalSwitch();
        if (!sdkGlobalSwitch.booleanValue()) {
            logger.info("Global switch is off, ignore all operations", new Object[0]);
        }
        return sdkGlobalSwitch;
    }

    public static Boolean isGlobalConfigFetched() {
        return globalConfigFetched.get();
    }

    public static void setGlobalConfigFetched() {
        globalConfigFetched.set(true);
    }

    public static Boolean isInSdkDebugMode() {
        return sdkDebugModeSwitch.get();
    }

    public static Boolean isInSdkLDUMode() {
        return sdkLDUModeSwitch.get();
    }

    public static String getTestEventCode() {
        return testEventCode;
    }

    public static void setSdkGlobalSwitch(Boolean sdkGlobalSwitch) {
        TikTokBusinessSdk.sdkGlobalSwitch = sdkGlobalSwitch;
    }

    public static String getApiAvailableVersion() {
        return apiAvailableVersion;
    }

    public static void setApiAvailableVersion(String apiAvailableVersion) {
        TikTokBusinessSdk.apiAvailableVersion = apiAvailableVersion;
    }

    public static String getApiTrackDomain() {
        return apiTrackDomain;
    }

    public static void setApiTrackDomain(String apiTrackDomain) {
        TikTokBusinessSdk.apiTrackDomain = apiTrackDomain;
    }

    public static synchronized void identify(String externalId, @Nullable String externalUserName, @Nullable String phoneNumber, @Nullable String email) {
        long initTimeMS = System.currentTimeMillis();
        appEventLogger.identify(externalId, externalUserName, phoneNumber, email);
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS).put("extid", externalId != null).put("username", externalUserName != null).put("phone", phoneNumber != null).put("email", email != null);
            appEventLogger.monitorMetric("identify", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void logout() {
        long initTimeMS = System.currentTimeMillis();
        appEventLogger.logout();
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS);
            appEventLogger.monitorMetric("logout", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSessionID() {
        return sessionID;
    }

    public static TTAppEventLogger getAppEventLogger() {
        StackTraceElement[] stackTraceElts = Thread.currentThread().getStackTrace();
        if (TTCrashHandler.isTTSDKRelatedException(Arrays.copyOfRange(stackTraceElts, 3, stackTraceElts.length))) {
            return appEventLogger;
        }
        return null;
    }

    public static void crashSDK() {
        throw new RuntimeException("force crash from sdk");
    }

    public static void setOnCrashListener(CrashListener crashListener) {
        onCrashListener = crashListener;
    }

    public static CrashListener getCrashListener() {
        return onCrashListener;
    }

    static {
        globalConfigFetched = new AtomicBoolean(false);
        sdkGlobalSwitch = true;
        apiAvailableVersion = "v1.2";
        apiTrackDomain = "business-api.tiktok.com";
        logLevel = LogLevel.INFO;
        sdkDebugModeSwitch = new AtomicBoolean(false);
        sdkLDUModeSwitch = new AtomicBoolean(false);
        testEventCode = "";
        sessionID = UUID.randomUUID().toString();
    }

    public static interface CrashListener {
        public void onCrash(Thread var1, Throwable var2);
    }

    public static enum LogLevel {
        NONE,
        INFO,
        WARN,
        DEBUG;


        public boolean log() {
            return this != NONE;
        }
    }

    public static class TTConfig {
        private final Application application;
        private String appId;
        private BigInteger ttAppId;
        private int flushTime = 15;
        private LogLevel logLevel = LogLevel.NONE;
        private boolean autoEvent = true;
        private boolean advertiserIDCollectionEnable = true;
        private boolean autoStart = true;
        private final List<TTConst.AutoEvents> disabledEvents;
        private boolean disableMetrics = false;
        private boolean debugModeSwitch = false;
        private boolean lduModeSwitch = false;

        public TTConfig(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            this.application = (Application)context.getApplicationContext();
            this.disabledEvents = new ArrayList<TTConst.AutoEvents>();
        }

        public TTConfig setLogLevel(LogLevel ll) {
            this.logLevel = ll;
            return this;
        }

        public TTConfig setTTAppId(String ttAppId) {
            this.ttAppId = new BigInteger(ttAppId);
            return this;
        }

        public TTConfig setAppId(String apiId) {
            this.appId = apiId;
            return this;
        }

        public TTConfig disableAutoStart() {
            this.autoStart = false;
            return this;
        }

        public TTConfig disableAutoEvents() {
            this.autoEvent = false;
            return this;
        }

        public TTConfig disableInstallLogging() {
            this.disabledEvents.add(TTConst.AutoEvents.InstallApp);
            return this;
        }

        public TTConfig disableLaunchLogging() {
            this.disabledEvents.add(TTConst.AutoEvents.LaunchAPP);
            return this;
        }

        public TTConfig disableRetentionLogging() {
            this.disabledEvents.add(TTConst.AutoEvents.SecondDayRetention);
            return this;
        }

        public TTConfig disableAdvertiserIDCollection() {
            this.advertiserIDCollectionEnable = false;
            return this;
        }

        public TTConfig setFlushTimeInterval(int seconds) {
            if (seconds < 0) {
                throw new RuntimeException("Invalid Flush interval");
            }
            this.flushTime = seconds;
            return this;
        }

        public TTConfig disableMonitor() {
            this.disableMetrics = true;
            return this;
        }

        public TTConfig openDebugMode() {
            this.debugModeSwitch = true;
            return this;
        }

        public TTConfig enableLimitedDataUse() {
            this.lduModeSwitch = true;
            return this;
        }
    }

    public static interface NetworkListener {
        public void onNetworkChange(int var1, int var2, int var3, int var4, int var5);
    }

    public static interface MemoryListener {
        public void onMemoryChange(int var1);
    }

    public static interface NextTimeFlushListener {
        public void timeLeft(int var1);

        public void thresholdLeft(int var1, int var2);
    }

    public static interface DiskStatusListener {
        public void onDiskChange(int var1, boolean var2);

        public void onDumped(int var1);
    }
}

