/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import android.content.Context;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.bumptech.glide.integration.volley.VolleyRequestFactory;
import com.bumptech.glide.integration.volley.VolleyRequestFuture;
import com.bumptech.glide.integration.volley.VolleyStreamFetcher;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.stream.StreamModelLoader;
import java.io.InputStream;

public class VolleyUrlLoader
implements StreamModelLoader<GlideUrl> {
    private final RequestQueue requestQueue;
    private final VolleyRequestFactory requestFactory;

    public VolleyUrlLoader(RequestQueue requestQueue) {
        this(requestQueue, VolleyStreamFetcher.DEFAULT_REQUEST_FACTORY);
    }

    public VolleyUrlLoader(RequestQueue requestQueue, VolleyRequestFactory requestFactory) {
        this.requestQueue = requestQueue;
        this.requestFactory = requestFactory;
    }

    public DataFetcher<InputStream> getResourceFetcher(GlideUrl url, int width, int height) {
        return new VolleyStreamFetcher(this.requestQueue, url, new VolleyRequestFuture<InputStream>(), this.requestFactory);
    }

    public static class Factory
    implements ModelLoaderFactory<GlideUrl, InputStream> {
        private static RequestQueue internalQueue;
        private RequestQueue requestQueue;
        private final VolleyRequestFactory requestFactory;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static RequestQueue getInternalQueue(Context context) {
            if (internalQueue != null) return internalQueue;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (internalQueue != null) return internalQueue;
                internalQueue = Volley.newRequestQueue((Context)context);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return internalQueue;
            }
        }

        public Factory(Context context) {
            this(Factory.getInternalQueue(context));
        }

        public Factory(RequestQueue requestQueue) {
            this(requestQueue, VolleyStreamFetcher.DEFAULT_REQUEST_FACTORY);
        }

        public Factory(RequestQueue requestQueue, VolleyRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            this.requestQueue = requestQueue;
        }

        public ModelLoader<GlideUrl, InputStream> build(Context context, GenericLoaderFactory factories) {
            return new VolleyUrlLoader(this.requestQueue, this.requestFactory);
        }

        public void teardown() {
        }
    }
}

