/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.okhttp;

import android.content.Context;
import com.bumptech.glide.integration.okhttp.OkHttpStreamFetcher;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.squareup.okhttp.OkHttpClient;
import java.io.InputStream;

public class OkHttpUrlLoader
implements ModelLoader<GlideUrl, InputStream> {
    private final OkHttpClient client;

    public OkHttpUrlLoader(OkHttpClient client) {
        this.client = client;
    }

    public DataFetcher<InputStream> getResourceFetcher(GlideUrl model, int width, int height) {
        return new OkHttpStreamFetcher(this.client, model);
    }

    public static class Factory
    implements ModelLoaderFactory<GlideUrl, InputStream> {
        private static volatile OkHttpClient internalClient;
        private OkHttpClient client;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static OkHttpClient getInternalClient() {
            if (internalClient != null) return internalClient;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (internalClient != null) return internalClient;
                internalClient = new OkHttpClient();
                // ** MonitorExit[var0] (shouldn't be in output)
                return internalClient;
            }
        }

        public Factory() {
            this(Factory.getInternalClient());
        }

        public Factory(OkHttpClient client) {
            this.client = client;
        }

        public ModelLoader<GlideUrl, InputStream> build(Context context, GenericLoaderFactory factories) {
            return new OkHttpUrlLoader(this.client);
        }

        public void teardown() {
        }
    }
}

