/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.Excludes;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterizedTypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class AppModuleGenerator {
    private final ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;

    AppModuleGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
    }

    TypeSpec generate(TypeElement appGlideModule, Set<String> libraryGlideModuleClassNames) {
        ClassName appGlideModuleClassName = ClassName.get(appGlideModule);
        List<String> excludedGlideModuleClassNames = this.getExcludedGlideModuleClassNames(appGlideModule);
        ArrayList<String> orderedLibraryGlideModuleClassNames = new ArrayList<String>(libraryGlideModuleClassNames);
        Collections.sort(orderedLibraryGlideModuleClassNames);
        MethodSpec constructor = this.generateConstructor(appGlideModuleClassName, orderedLibraryGlideModuleClassNames, excludedGlideModuleClassNames);
        MethodSpec registerComponents = this.generateRegisterComponents(orderedLibraryGlideModuleClassNames, excludedGlideModuleClassNames);
        MethodSpec getExcludedModuleClasses = this.generateGetExcludedModuleClasses(excludedGlideModuleClassNames);
        MethodSpec applyOptions = MethodSpec.methodBuilder("applyOptions").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter(ParameterSpec.builder(ClassName.get("android.content", "Context", new String[0]), "context", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(ClassName.get("com.bumptech.glide", "GlideBuilder", new String[0]), "builder", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("appGlideModule.applyOptions(context, builder)", appGlideModule).build();
        MethodSpec isManifestParsingEnabled = MethodSpec.methodBuilder("isManifestParsingEnabled").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(Boolean.TYPE).addStatement("return appGlideModule.isManifestParsingEnabled()", appGlideModule).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder("GeneratedAppGlideModuleImpl").addModifiers(Modifier.FINAL).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "deprecation").build()).superclass(ClassName.get("com.bumptech.glide", "GeneratedAppGlideModule", new String[0])).addField(appGlideModuleClassName, "appGlideModule", Modifier.PRIVATE, Modifier.FINAL).addMethod(constructor).addMethod(applyOptions).addMethod(registerComponents).addMethod(isManifestParsingEnabled).addMethod(getExcludedModuleClasses);
        ClassName generatedRequestManagerFactoryClassName = ClassName.get("com.bumptech.glide", "GeneratedRequestManagerFactory", new String[0]);
        builder.addMethod(MethodSpec.methodBuilder("getRequestManagerFactory").addAnnotation(Override.class).addAnnotation(this.processorUtil.nonNull()).returns(generatedRequestManagerFactoryClassName).addStatement("return new $T()", generatedRequestManagerFactoryClassName).build());
        return builder.build();
    }

    private MethodSpec generateGetExcludedModuleClasses(Collection<String> excludedClassNames) {
        WildcardTypeName wildCardOfObject = WildcardTypeName.subtypeOf(Object.class);
        ParameterizedTypeName classOfWildcardOfObjet = ParameterizedTypeName.get(ClassName.get(Class.class), wildCardOfObject);
        ParameterizedTypeName setOfClassOfWildcardOfObject = ParameterizedTypeName.get(ClassName.get(Set.class), classOfWildcardOfObjet);
        ParameterizedTypeName hashSetOfClassOfWildcardOfObject = ParameterizedTypeName.get(ClassName.get(HashSet.class), classOfWildcardOfObjet);
        MethodSpec.Builder builder = MethodSpec.methodBuilder("getExcludedModuleClasses").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addAnnotation(this.processorUtil.nonNull()).returns(setOfClassOfWildcardOfObject);
        if (excludedClassNames.isEmpty()) {
            builder.addStatement("return $T.emptySet()", Collections.class);
        } else {
            builder.addStatement("$T excludedClasses = new $T()", setOfClassOfWildcardOfObject, hashSetOfClassOfWildcardOfObject);
            for (String excludedClassName : excludedClassNames) {
                builder.addStatement("excludedClasses.add($L.class)", excludedClassName);
            }
            builder.addStatement("return excludedClasses", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec generateRegisterComponents(Collection<String> libraryGlideModuleClassNames, Collection<String> excludedGlideModuleClassNames) {
        MethodSpec.Builder registerComponents = MethodSpec.methodBuilder("registerComponents").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter(ParameterSpec.builder(ClassName.get("android.content", "Context", new String[0]), "context", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(ClassName.get("com.bumptech.glide", "Glide", new String[0]), "glide", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(ClassName.get("com.bumptech.glide", "Registry", new String[0]), "registry", new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build());
        for (String glideModule : libraryGlideModuleClassNames) {
            if (excludedGlideModuleClassNames.contains(glideModule)) continue;
            ClassName moduleClassName = ClassName.bestGuess(glideModule);
            registerComponents.addStatement("new $T().registerComponents(context, glide, registry)", moduleClassName);
        }
        registerComponents.addStatement("appGlideModule.registerComponents(context, glide, registry)", new Object[0]);
        return registerComponents.build();
    }

    private boolean doesAppGlideModuleConstructorAcceptContext(ClassName appGlideModule) {
        TypeElement appGlideModuleType = this.processingEnv.getElementUtils().getTypeElement(appGlideModule.reflectionName());
        for (Element element : appGlideModuleType.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableElement constructor = (ExecutableElement)element;
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (parameters.isEmpty()) {
                return false;
            }
            if (parameters.size() > 1) {
                throw new IllegalStateException("Constructor for " + appGlideModule + " accepts too many parameters, it should accept no parameters, or a single Context");
            }
            VariableElement parameter = parameters.get(0);
            TypeMirror parameterType = parameter.asType();
            TypeMirror contextType = this.processingEnv.getElementUtils().getTypeElement("android.content.Context").asType();
            if (!this.processingEnv.getTypeUtils().isSameType(parameterType, contextType)) {
                throw new IllegalStateException("Unrecognized type: " + parameterType);
            }
            return true;
        }
        return false;
    }

    private MethodSpec generateConstructor(ClassName appGlideModule, Collection<String> libraryGlideModuleClassNames, Collection<String> excludedGlideModuleClassNames) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(ClassName.get("android.content", "Context", new String[0]), "context", new Modifier[0]).build());
        if (this.doesAppGlideModuleConstructorAcceptContext(appGlideModule)) {
            constructorBuilder.addStatement("appGlideModule = new $T(context)", appGlideModule);
        } else {
            constructorBuilder.addStatement("appGlideModule = new $T()", appGlideModule);
        }
        ClassName androidLogName = ClassName.get("android.util", "Log", new String[0]);
        constructorBuilder.beginControlFlow("if ($T.isLoggable($S, $T.DEBUG))", androidLogName, "Glide", androidLogName);
        constructorBuilder.addStatement("$T.d($S, $S)", androidLogName, "Glide", "Discovered AppGlideModule from annotation: " + appGlideModule);
        for (String glideModule : libraryGlideModuleClassNames) {
            if (excludedGlideModuleClassNames.contains(glideModule)) {
                constructorBuilder.addStatement("$T.d($S, $S)", androidLogName, "Glide", "AppGlideModule excludes LibraryGlideModule from annotation: " + glideModule);
                continue;
            }
            constructorBuilder.addStatement("$T.d($S, $S)", androidLogName, "Glide", "Discovered LibraryGlideModule from annotation: " + glideModule);
        }
        constructorBuilder.endControlFlow();
        return constructorBuilder.build();
    }

    private List<String> getExcludedGlideModuleClassNames(TypeElement appGlideModule) {
        Set<String> names = this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(appGlideModule, Excludes.class);
        ArrayList<String> result = new ArrayList<String>(names);
        Collections.sort(result);
        return result;
    }
}

