/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.annotation.compiler.RequestOptionsExtensionGenerator;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class RequestBuilderGenerator {
    private static final String REQUEST_OPTIONS_PACKAGE_NAME = "com.bumptech.glide.request";
    private static final String REQUEST_OPTIONS_SIMPLE_NAME = "RequestOptions";
    private static final String REQUEST_OPTIONS_QUALIFIED_NAME = "com.bumptech.glide.request.RequestOptions";
    private static final String REQUEST_BUILDER_PACKAGE_NAME = "com.bumptech.glide";
    private static final String REQUEST_BUILDER_SIMPLE_NAME = "RequestBuilder";
    static final String REQUEST_BUILDER_QUALIFIED_NAME = "com.bumptech.glide.RequestBuilder";
    private static final String GENERATED_REQUEST_BUILDER_SIMPLE_NAME = "GlideRequest";
    private static final String TRANSCODE_TYPE_NAME = "TranscodeType";
    private static final ImmutableSet<String> EXCLUDED_METHODS_FROM_BASE_REQUEST_OPTIONS = ImmutableSet.of((Object)"clone", (Object)"apply");
    private final ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;
    private final TypeVariableName transcodeTypeName;
    private final TypeElement requestOptionsType;
    private final TypeElement requestBuilderType;
    private ClassName generatedRequestBuilderClassName;
    private ClassName requestOptionsClassName;
    private ParameterizedTypeName generatedRequestBuilderOfTranscodeType;

    RequestBuilderGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
        this.requestBuilderType = processingEnv.getElementUtils().getTypeElement(REQUEST_BUILDER_QUALIFIED_NAME);
        this.transcodeTypeName = TypeVariableName.get((String)TRANSCODE_TYPE_NAME);
        this.requestOptionsType = processingEnv.getElementUtils().getTypeElement(REQUEST_OPTIONS_QUALIFIED_NAME);
    }

    TypeSpec generate(String generatedCodePackageName, Set<String> glideExtensionClassNames, @Nullable TypeSpec generatedOptions) {
        this.requestOptionsClassName = generatedOptions != null ? ClassName.get((String)generatedCodePackageName, (String)generatedOptions.name, (String[])new String[0]) : ClassName.get((String)REQUEST_OPTIONS_PACKAGE_NAME, (String)"BaseRequestOptions", (String[])new String[0]);
        this.generatedRequestBuilderClassName = ClassName.get((String)generatedCodePackageName, (String)GENERATED_REQUEST_BUILDER_SIMPLE_NAME, (String[])new String[0]);
        this.generatedRequestBuilderOfTranscodeType = ParameterizedTypeName.get((ClassName)this.generatedRequestBuilderClassName, (TypeName[])new TypeName[]{this.transcodeTypeName});
        RequestOptionsExtensionGenerator requestOptionsExtensionGenerator = new RequestOptionsExtensionGenerator((TypeName)this.generatedRequestBuilderOfTranscodeType, this.processorUtil);
        ParameterizedTypeName requestBuilderOfTranscodeType = ParameterizedTypeName.get((ClassName)ClassName.get((String)REQUEST_BUILDER_PACKAGE_NAME, (String)REQUEST_BUILDER_SIMPLE_NAME, (String[])new String[0]), (TypeName[])new TypeName[]{this.transcodeTypeName});
        List<MethodSpec> requestOptionsExtensionMethods = requestOptionsExtensionGenerator.generateInstanceMethodsForExtensions(glideExtensionClassNames);
        return TypeSpec.classBuilder((String)GENERATED_REQUEST_BUILDER_SIMPLE_NAME).addJavadoc("Contains all public methods from {@link $T}, all options from\n", new Object[]{this.requestBuilderType}).addJavadoc("{@link $T} and all generated options from\n", new Object[]{this.requestOptionsType}).addJavadoc("{@link $T} in annotated methods in\n", new Object[]{GlideOption.class}).addJavadoc("{@link $T} annotated classes.\n", new Object[]{GlideExtension.class}).addJavadoc("\n", new Object[0]).addJavadoc("<p>Generated code, do not modify.\n", new Object[0]).addJavadoc("\n", new Object[0]).addJavadoc("@see $T\n", new Object[]{this.requestBuilderType}).addJavadoc("@see $T\n", new Object[]{this.requestOptionsType}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unused"}).addMember("value", "$S", new Object[]{"deprecation"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(this.transcodeTypeName).superclass((TypeName)requestBuilderOfTranscodeType).addSuperinterface(Cloneable.class).addMethods(this.generateConstructors()).addMethod(this.generateDownloadOnlyRequestMethod()).addMethods(this.generateGeneratedRequestOptionsEquivalents(requestOptionsExtensionMethods, generatedOptions)).addMethods(this.generateRequestBuilderOverrides()).addMethods(requestOptionsExtensionMethods).build();
    }

    private List<MethodSpec> generateGeneratedRequestOptionsEquivalents(final List<MethodSpec> requestOptionsExtensionMethods, @Nullable TypeSpec generatedOptions) {
        if (generatedOptions == null) {
            return Collections.emptyList();
        }
        return FluentIterable.from((Iterable)generatedOptions.methodSpecs).filter((Predicate)new Predicate<MethodSpec>(){

            public boolean apply(MethodSpec input) {
                return RequestBuilderGenerator.this.isUsefulGeneratedRequestOption(requestOptionsExtensionMethods, input);
            }
        }).transform((Function)new Function<MethodSpec, MethodSpec>(){

            public MethodSpec apply(MethodSpec input) {
                return RequestBuilderGenerator.this.generateGeneratedRequestOptionEquivalent(input);
            }
        }).toList();
    }

    private boolean isUsefulGeneratedRequestOption(List<MethodSpec> requestOptionsExtensionMethods, MethodSpec requestOptionsMethod) {
        return !EXCLUDED_METHODS_FROM_BASE_REQUEST_OPTIONS.contains((Object)requestOptionsMethod.name) && requestOptionsMethod.hasModifier(Modifier.PUBLIC) && !requestOptionsMethod.hasModifier(Modifier.STATIC) && requestOptionsMethod.returnType.toString().equals(this.requestOptionsClassName.toString()) && !this.isExtensionMethod(requestOptionsExtensionMethods, requestOptionsMethod);
    }

    private boolean isExtensionMethod(List<MethodSpec> requestOptionsExtensionMethods, final MethodSpec requestOptionsMethod) {
        return FluentIterable.from(requestOptionsExtensionMethods).anyMatch((Predicate)new Predicate<MethodSpec>(){

            public boolean apply(MethodSpec input) {
                return input.name.equals(requestOptionsMethod.name) && input.parameters.equals(requestOptionsMethod.parameters);
            }
        });
    }

    private MethodSpec generateGeneratedRequestOptionEquivalent(MethodSpec requestOptionMethod) {
        CodeBlock callRequestOptionsMethod = CodeBlock.builder().add(".$N(", new Object[]{requestOptionMethod.name}).add(FluentIterable.from((Iterable)requestOptionMethod.parameters).transform((Function)new Function<ParameterSpec, String>(){

            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on((String)", ")), new Object[0]).add(");\n", new Object[0]).build();
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)requestOptionMethod.name).addJavadoc(this.processorUtil.generateSeeMethodJavadoc((TypeName)this.requestOptionsClassName, requestOptionMethod)).addModifiers(new Modifier[]{Modifier.PUBLIC}).varargs(requestOptionMethod.varargs).addAnnotations((Iterable)FluentIterable.from((Iterable)requestOptionMethod.annotations).filter((Predicate)new Predicate<AnnotationSpec>(){

            public boolean apply(AnnotationSpec input) {
                return !input.type.equals((Object)TypeName.get(Override.class)) && !input.type.equals((Object)TypeName.get(SafeVarargs.class)) && !input.type.equals((Object)TypeName.get(SuppressWarnings.class));
            }
        }).toList()).addTypeVariables((Iterable)requestOptionMethod.typeVariables).addParameters((Iterable)requestOptionMethod.parameters).returns((TypeName)this.generatedRequestBuilderOfTranscodeType).addCode("return ($T) super", new Object[]{this.generatedRequestBuilderOfTranscodeType}).addCode(callRequestOptionsMethod);
        AnnotationSpec suppressWarnings = this.buildSuppressWarnings(requestOptionMethod);
        if (suppressWarnings != null) {
            result.addAnnotation(suppressWarnings);
        }
        return result.build();
    }

    @Nullable
    private AnnotationSpec buildSuppressWarnings(MethodSpec requestOptionMethod) {
        HashSet<String> suppressions = new HashSet<String>();
        if (requestOptionMethod.annotations.contains(AnnotationSpec.builder(SuppressWarnings.class).build())) {
            for (AnnotationSpec annotation : requestOptionMethod.annotations) {
                if (!annotation.type.equals((Object)TypeName.get(SuppressWarnings.class))) continue;
                List codeBlocks = (List)annotation.members.get("value");
                suppressions.addAll((Collection<String>)FluentIterable.from((Iterable)codeBlocks).transform((Function)new Function<CodeBlock, String>(){

                    public String apply(CodeBlock input) {
                        return input.toString();
                    }
                }).toSet());
            }
        }
        if (requestOptionMethod.annotations.contains(AnnotationSpec.builder(SafeVarargs.class).build())) {
            suppressions.add("unchecked");
            suppressions.add("varargs");
        }
        if (suppressions.isEmpty()) {
            return null;
        }
        ArrayList suppressionsList = new ArrayList(suppressions);
        Collections.sort(suppressionsList);
        AnnotationSpec.Builder builder = AnnotationSpec.builder(SuppressWarnings.class);
        for (String suppression : suppressionsList) {
            builder.addMember("value", "$S", new Object[]{suppression});
        }
        return builder.build();
    }

    private List<MethodSpec> generateRequestBuilderOverrides() {
        TypeMirror rawRequestBuilderType = this.processingEnv.getTypeUtils().erasure(this.requestBuilderType.asType());
        return Lists.transform(this.processorUtil.findInstanceMethodsReturning(this.requestBuilderType, rawRequestBuilderType), (Function)new Function<ExecutableElement, MethodSpec>(){

            public MethodSpec apply(ExecutableElement input) {
                return RequestBuilderGenerator.this.generateRequestBuilderOverride(input);
            }
        });
    }

    private MethodSpec generateRequestBuilderOverride(ExecutableElement methodToOverride) {
        TypeMirror typeArgument = ((DeclaredType)methodToOverride.getReturnType()).getTypeArguments().get(0);
        ParameterizedTypeName generatedRequestBuilderOfType = ParameterizedTypeName.get((ClassName)this.generatedRequestBuilderClassName, (TypeName[])new TypeName[]{ClassName.get((TypeMirror)typeArgument)});
        MethodSpec.Builder builder = this.processorUtil.overriding(methodToOverride).returns((TypeName)generatedRequestBuilderOfType);
        builder.addCode(CodeBlock.builder().add("return ($T) super.$N(", new Object[]{generatedRequestBuilderOfType, methodToOverride.getSimpleName()}).add(FluentIterable.from((Iterable)builder.build().parameters).transform((Function)new Function<ParameterSpec, String>(){

            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on((String)", ")), new Object[0]).add(");\n", new Object[0]).build());
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            builder = builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        if (methodToOverride.isVarArgs()) {
            builder = builder.addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(SafeVarargs.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"varargs"}).build());
        }
        return builder.build();
    }

    private List<MethodSpec> generateConstructors() {
        ParameterizedTypeName classOfTranscodeType = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{this.transcodeTypeName});
        WildcardTypeName wildcardOfObject = WildcardTypeName.subtypeOf(Object.class);
        ParameterizedTypeName requestBuilderOfWildcardOfObject = ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)this.requestBuilderType), (TypeName[])new TypeName[]{wildcardOfObject});
        MethodSpec firstConstructor = MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)classOfTranscodeType, (String)"transcodeClass", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)requestBuilderOfWildcardOfObject, (String)"other", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("super($N, $N)", new Object[]{"transcodeClass", "other"}).build();
        ClassName context = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
        ClassName glide = ClassName.get((String)REQUEST_BUILDER_PACKAGE_NAME, (String)"Glide", (String[])new String[0]);
        ClassName requestManager = ClassName.get((String)REQUEST_BUILDER_PACKAGE_NAME, (String)"RequestManager", (String[])new String[0]);
        MethodSpec secondConstructor = MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)glide, (String)"glide", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)requestManager, (String)"requestManager", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)classOfTranscodeType, (String)"transcodeClass", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)context, (String)"context", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("super($N, $N ,$N, $N)", new Object[]{"glide", "requestManager", "transcodeClass", "context"}).build();
        return ImmutableList.of((Object)firstConstructor, (Object)secondConstructor);
    }

    private MethodSpec generateDownloadOnlyRequestMethod() {
        ParameterizedTypeName generatedRequestBuilderOfFile = ParameterizedTypeName.get((ClassName)this.generatedRequestBuilderClassName, (TypeName[])new TypeName[]{ClassName.get(File.class)});
        return MethodSpec.methodBuilder((String)"getDownloadOnlyRequest").addAnnotation(Override.class).addAnnotation(this.processorUtil.checkResult()).addAnnotation(this.processorUtil.nonNull()).returns((TypeName)generatedRequestBuilderOfFile).addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("return new $T<>($T.class, $N).apply($N)", new Object[]{this.generatedRequestBuilderClassName, File.class, "this", "DOWNLOAD_ONLY_OPTIONS"}).build();
    }
}

