/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Joiner;
import com.bumptech.glide.repackaged.com.google.common.base.Predicate;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeBlock;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class RequestOptionsOverrideGenerator {
    private final TypeElement baseRequestOptionsType;
    private ProcessorUtil processorUtil;

    RequestOptionsOverrideGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processorUtil = processorUtil;
        this.baseRequestOptionsType = processingEnv.getElementUtils().getTypeElement("com.bumptech.glide.request.BaseRequestOptions");
    }

    List<MethodSpec> generateInstanceMethodOverridesForRequestOptions(TypeName typeToOverrideIn) {
        return this.generateInstanceMethodOverridesForRequestOptions(typeToOverrideIn, Collections.emptySet());
    }

    List<MethodSpec> generateInstanceMethodOverridesForRequestOptions(final TypeName typeToOverrideIn, final Set<String> excludedMethods) {
        return FluentIterable.from(this.processorUtil.findInstanceMethodsReturning(this.baseRequestOptionsType, this.baseRequestOptionsType)).filter(new Predicate<ExecutableElement>(){

            @Override
            public boolean apply(ExecutableElement input) {
                return !excludedMethods.contains(input.getSimpleName().toString());
            }
        }).transform(new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                return RequestOptionsOverrideGenerator.this.generateRequestOptionOverride(typeToOverrideIn, input);
            }
        }).toList();
    }

    private MethodSpec generateRequestOptionOverride(TypeName typeToOverrideIn, ExecutableElement methodToOverride) {
        MethodSpec.Builder result = ProcessorUtil.overriding(methodToOverride).returns(typeToOverrideIn);
        result.addCode(CodeBlock.builder().add("return ($T) super.$N(", typeToOverrideIn, methodToOverride.getSimpleName()).add(FluentIterable.from(result.build().parameters).transform(new Function<ParameterSpec, String>(){

            @Override
            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on(", ")), new Object[0]).add(");\n", new Object[0]).build());
        if (methodToOverride.getSimpleName().toString().contains("transform") && methodToOverride.isVarArgs()) {
            result.addModifiers(Modifier.FINAL).addAnnotation(SafeVarargs.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "varargs").build());
        }
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            result.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
        return result.build();
    }
}

