/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.compiler.AppModuleProcessor;
import com.bumptech.glide.annotation.compiler.ExtensionProcessor;
import com.bumptech.glide.annotation.compiler.IndexerGenerator;
import com.bumptech.glide.annotation.compiler.LibraryModuleProcessor;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

public final class GlideAnnotationProcessor
extends AbstractProcessor {
    private ProcessorUtil processorUtil;
    private LibraryModuleProcessor libraryModuleProcessor;
    private AppModuleProcessor appModuleProcessor;
    private boolean isGeneratedAppGlideModuleWritten;
    private ExtensionProcessor extensionProcessor;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.processorUtil = new ProcessorUtil(processingEnvironment);
        IndexerGenerator indexerGenerator = new IndexerGenerator(this.processorUtil);
        this.libraryModuleProcessor = new LibraryModuleProcessor(this.processorUtil, indexerGenerator);
        this.appModuleProcessor = new AppModuleProcessor(processingEnvironment, this.processorUtil);
        this.extensionProcessor = new ExtensionProcessor(processingEnvironment, this.processorUtil, indexerGenerator);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.libraryModuleProcessor.getSupportedAnnotationTypes());
        result.addAll(this.extensionProcessor.getSupportedAnnotationTypes());
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment env) {
        this.processorUtil.process();
        boolean newModulesWritten = this.libraryModuleProcessor.processModules(env);
        boolean newExtensionWritten = this.extensionProcessor.processExtensions(env);
        this.appModuleProcessor.processModules(set, env);
        if (newExtensionWritten || newModulesWritten) {
            if (this.isGeneratedAppGlideModuleWritten) {
                throw new IllegalStateException("Cannot process annotations after writing AppGlideModule");
            }
            return true;
        }
        if (!this.isGeneratedAppGlideModuleWritten) {
            this.isGeneratedAppGlideModuleWritten = this.appModuleProcessor.maybeWriteAppModule();
        }
        return true;
    }
}

