/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.avif;

import android.graphics.Bitmap;
import com.bumptech.glide.integration.avif.AvifByteBufferBitmapDecoder;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.util.ByteBufferUtil;
import com.bumptech.glide.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;

public final class AvifStreamBitmapDecoder
implements ResourceDecoder<InputStream, Bitmap> {
    private static final String TAG = "AvifStreamBitmapDecoder";
    private final List<ImageHeaderParser> parsers;
    private final AvifByteBufferBitmapDecoder avifByteBufferDecoder;
    private final ArrayPool arrayPool;

    public AvifStreamBitmapDecoder(List<ImageHeaderParser> parsers, AvifByteBufferBitmapDecoder avifByteBufferDecoder, ArrayPool arrayPool) {
        this.parsers = parsers;
        this.avifByteBufferDecoder = (AvifByteBufferBitmapDecoder)Preconditions.checkNotNull((Object)avifByteBufferDecoder);
        this.arrayPool = (ArrayPool)Preconditions.checkNotNull((Object)arrayPool);
    }

    @Nullable
    public Resource<Bitmap> decode(InputStream source, int width, int height, Options options) throws IOException {
        return this.avifByteBufferDecoder.decode(ByteBufferUtil.fromStream((InputStream)source), width, height, options);
    }

    public boolean handles(InputStream source, Options options) throws IOException {
        return ImageHeaderParser.ImageType.AVIF.equals((Object)ImageHeaderParserUtils.getType(this.parsers, (InputStream)source, (ArrayPool)this.arrayPool));
    }
}

