/*
 * Decompiled with CFR 0.152.
 */
package com.github.brunodles.simplepreferences.lib.parsers;

import android.content.SharedPreferences;
import com.github.brunodles.simplepreferences.lib.Parser;
import com.github.brunodles.simplepreferences.lib.ParserHelper;
import com.github.brunodles.simplepreferences.lib.Property;
import java.lang.reflect.Field;

public class FloatParser
implements Parser {
    @Override
    public boolean canResolve(Class<?> fieldType) {
        return fieldType.isAssignableFrom(Float.class) || fieldType.isAssignableFrom(Float.TYPE);
    }

    @Override
    public void save(SharedPreferences.Editor editor, Field field, Object object, Property annotation) throws IllegalAccessException {
        editor.putFloat(ParserHelper.resolveKey(field), field.getFloat(object));
    }

    @Override
    public void load(SharedPreferences preferences, Field field, Object object, Property annotation) throws IllegalAccessException {
        float defValue = ParserHelper.getValue(field, object, Float.valueOf(0.0f)).floatValue();
        float value = preferences.getFloat(ParserHelper.resolveKey(field), defValue);
        field.set(object, Float.valueOf(value));
    }
}

