/*
 * Decompiled with CFR 0.152.
 */
package com.github.brunodles.simplepreferences.lib.parsers;

import android.content.SharedPreferences;
import com.github.brunodles.simplepreferences.lib.Parser;
import com.github.brunodles.simplepreferences.lib.ParserHelper;
import com.github.brunodles.simplepreferences.lib.Property;
import java.lang.reflect.Field;

public class BooleanParser
implements Parser {
    @Override
    public boolean canResolve(Class<?> fieldType) {
        return fieldType.isAssignableFrom(Boolean.class) || fieldType.isAssignableFrom(Boolean.TYPE);
    }

    @Override
    public void save(SharedPreferences.Editor editor, Field field, Object object, Property annotation) throws IllegalAccessException {
        editor.putBoolean(ParserHelper.resolveKey(field), ParserHelper.getValue(field, object, false).booleanValue());
    }

    @Override
    public void load(SharedPreferences preferences, Field field, Object object, Property annotation) throws IllegalAccessException {
        boolean defValue = ParserHelper.getValue(field, object, false);
        field.set(object, preferences.getBoolean(ParserHelper.resolveKey(field), defValue));
    }
}

