/*
 * Decompiled with CFR 0.152.
 */
package com.github.brunodles.simplepreferences.lib;

import android.content.Context;
import android.content.SharedPreferences;
import com.github.brunodles.simplepreferences.lib.CommonPreferences;

public abstract class ActivePreferences {
    private Context context;
    private String preferenceName;

    protected ActivePreferences(Context context) {
        this.context = context;
        this.preferenceName = this.getClass().getName();
        this.reload();
    }

    public void reload() {
        SharedPreferences preferences = this.getSharedPreferences();
        CommonPreferences.load(preferences, this);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(this.preferenceName, 0);
    }

    protected ActivePreferences(Context context, String preferenceName) {
        this.context = context;
        this.preferenceName = preferenceName;
        this.reload();
    }

    public void apply() {
        CommonPreferences.apply(this.getSharedPreferences(), this);
    }

    public void commit() {
        CommonPreferences.commit(this.getSharedPreferences(), this);
    }

    public void clear() {
        CommonPreferences.clear(this.getSharedPreferences());
    }
}

