/*
 * Decompiled with CFR 0.152.
 */
package com.github.brunodles.simplepreferences.lib.parsers;

import android.content.SharedPreferences;
import com.github.brunodles.simplepreferences.lib.Parser;
import com.github.brunodles.simplepreferences.lib.ParserHelper;
import com.github.brunodles.simplepreferences.lib.Property;
import java.lang.reflect.Field;

public class StringParser
implements Parser {
    @Override
    public boolean canResolve(Class<?> fieldType) {
        return fieldType.isAssignableFrom(String.class);
    }

    @Override
    public void save(SharedPreferences.Editor editor, Field field, Object object, Property annotation) throws IllegalAccessException {
        String key = ParserHelper.resolveKey(field);
        String value = String.valueOf(field.get(object));
        editor.putString(key, value);
    }

    @Override
    public void load(SharedPreferences preferences, Field field, Object object, Property annotation) throws IllegalAccessException {
        String key = ParserHelper.resolveKey(field);
        Object currentValue = field.get(object);
        String defValue = currentValue == null ? null : String.valueOf(currentValue);
        String value = preferences.getString(key, defValue);
        field.set(object, value);
    }
}

