/*
 * Decompiled with CFR 0.152.
 */
package com.wafflecopter.multicontactpicker.Views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.wafflecopter.multicontactpicker.R;

public class RoundLetterView
extends View {
    private static int DEFAULT_TITLE_COLOR = -1;
    private static int DEFAULT_BACKGROUND_COLOR = -16711681;
    private static final int DEFAULT_VIEW_SIZE = 96;
    private static float DEFAULT_TITLE_SIZE = 25.0f;
    private static String DEFAULT_TITLE = "A";
    private int mTitleColor = DEFAULT_TITLE_COLOR;
    private int mBackgroundColor = DEFAULT_BACKGROUND_COLOR;
    private String mTitleText = DEFAULT_TITLE;
    private float mTitleSize = DEFAULT_TITLE_SIZE;
    private TextPaint mTitleTextPaint;
    private Paint mBackgroundPaint;
    private RectF mInnerRectF;
    private int mViewSize;
    private Typeface mFont = Typeface.defaultFromStyle((int)1);

    public RoundLetterView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public RoundLetterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public RoundLetterView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RoundedLetterView, defStyle, 0);
        if (a.hasValue(R.styleable.RoundedLetterView_rlv_titleText)) {
            this.mTitleText = a.getString(R.styleable.RoundedLetterView_rlv_titleText);
        }
        this.mTitleColor = a.getColor(R.styleable.RoundedLetterView_rlv_titleColor, DEFAULT_TITLE_COLOR);
        this.mBackgroundColor = a.getColor(R.styleable.RoundedLetterView_rlv_backgroundColorValue, DEFAULT_BACKGROUND_COLOR);
        this.mTitleSize = a.getDimension(R.styleable.RoundedLetterView_rlv_titleSize, DEFAULT_TITLE_SIZE);
        a.recycle();
        this.mTitleTextPaint = new TextPaint();
        this.mTitleTextPaint.setFlags(1);
        this.mTitleTextPaint.setTypeface(this.mFont);
        this.mTitleTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTitleTextPaint.setLinearText(true);
        this.mTitleTextPaint.setColor(this.mTitleColor);
        this.mTitleTextPaint.setTextSize(this.mTitleSize);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setFlags(1);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mInnerRectF = new RectF();
    }

    private void invalidateTextPaints() {
        this.mTitleTextPaint.setTypeface(this.mFont);
        this.mTitleTextPaint.setTextSize(this.mTitleSize);
        this.mTitleTextPaint.setColor(this.mTitleColor);
    }

    private void invalidatePaints() {
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = RoundLetterView.resolveSize((int)96, (int)widthMeasureSpec);
        int height = RoundLetterView.resolveSize((int)96, (int)heightMeasureSpec);
        this.mViewSize = Math.min(width, height);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        this.mInnerRectF.set(0.0f, 0.0f, (float)this.mViewSize, (float)this.mViewSize);
        this.mInnerRectF.offset((float)((this.getWidth() - this.mViewSize) / 2), (float)((this.getHeight() - this.mViewSize) / 2));
        float centerX = this.mInnerRectF.centerX();
        float centerY = this.mInnerRectF.centerY();
        int xPos = (int)centerX;
        int yPos = (int)(centerY - (this.mTitleTextPaint.descent() + this.mTitleTextPaint.ascent()) / 2.0f);
        canvas.drawOval(this.mInnerRectF, this.mBackgroundPaint);
        canvas.drawText(this.mTitleText, (float)xPos, (float)yPos, (Paint)this.mTitleTextPaint);
    }

    public String getTitleText() {
        return this.mTitleText;
    }

    public void setTitleText(String title) {
        this.mTitleText = title;
        this.invalidate();
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.invalidatePaints();
    }

    public float getTitleSize() {
        return this.mTitleSize;
    }

    public void setTitleSize(float titleSize) {
        this.mTitleSize = titleSize;
        this.invalidateTextPaints();
    }

    public void setTextTypeface(Typeface font) {
        this.mFont = font;
        this.invalidateTextPaints();
    }

    public void setTitleColor(int titleColor) {
        this.mTitleColor = titleColor;
        this.invalidateTextPaints();
    }
}

