/*
 * Decompiled with CFR 0.152.
 */
package com.wafflecopter.multicontactpicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.style.TextAppearanceSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.l4digital.fastscroll.FastScroller;
import com.wafflecopter.multicontactpicker.R;
import com.wafflecopter.multicontactpicker.RxContacts.Contact;
import com.wafflecopter.multicontactpicker.Views.RoundLetterView;
import java.util.ArrayList;
import java.util.List;

class MultiContactPickerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FastScroller.SectionIndexer,
Filterable {
    private List<Contact> contactItemList;
    private List<Contact> contactItemListOriginal;
    private ContactSelectListener listener;
    private String currentFilterQuery;

    MultiContactPickerAdapter(List<Contact> contactItemList, ContactSelectListener listener) {
        this.contactItemList = contactItemList;
        this.contactItemListOriginal = contactItemList;
        this.listener = listener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.list_row_contact_pick_item, viewGroup, false);
        return new ContactViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int i) {
        if (holder instanceof ContactViewHolder) {
            ContactViewHolder contactViewHolder = (ContactViewHolder)holder;
            final Contact contactItem = this.getItem(i);
            contactViewHolder.tvContactName.setText((CharSequence)contactItem.getDisplayName());
            contactViewHolder.vRoundLetterView.setTitleText(String.valueOf(contactItem.getDisplayName().charAt(0)));
            contactViewHolder.vRoundLetterView.setBackgroundColor(contactItem.getBackgroundColor());
            if (contactItem.getPhoneNumbers().size() > 0) {
                String displayName;
                String phoneNumber = contactItem.getPhoneNumbers().get(0).getNumber().replaceAll("\\s+", "");
                if (!phoneNumber.equals(displayName = contactItem.getDisplayName().replaceAll("\\s+", ""))) {
                    contactViewHolder.tvNumber.setVisibility(0);
                    contactViewHolder.tvNumber.setText((CharSequence)phoneNumber);
                } else {
                    contactViewHolder.tvNumber.setVisibility(8);
                }
            } else if (contactItem.getEmails().size() > 0) {
                String displayName;
                String email = contactItem.getEmails().get(0).replaceAll("\\s+", "");
                if (!email.equals(displayName = contactItem.getDisplayName().replaceAll("\\s+", ""))) {
                    contactViewHolder.tvNumber.setVisibility(0);
                    contactViewHolder.tvNumber.setText((CharSequence)email);
                } else {
                    contactViewHolder.tvNumber.setVisibility(8);
                }
            } else {
                contactViewHolder.tvNumber.setVisibility(8);
            }
            this.highlightTerm(contactViewHolder.tvContactName, this.currentFilterQuery, contactViewHolder.tvContactName.getText().toString());
            if (contactItem.isSelected()) {
                contactViewHolder.ivSelectedState.setVisibility(0);
            } else {
                contactViewHolder.ivSelectedState.setVisibility(4);
            }
            contactViewHolder.mView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MultiContactPickerAdapter.this.setContactSelected(contactItem.getId());
                    if (MultiContactPickerAdapter.this.listener != null) {
                        MultiContactPickerAdapter.this.listener.onContactSelected(MultiContactPickerAdapter.this.getItem(i), MultiContactPickerAdapter.this.getSelectedContactsCount());
                    }
                    MultiContactPickerAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    private void highlightTerm(TextView tv, String query, String originalString) {
        if (query != null && !query.isEmpty()) {
            int startPos = originalString.toLowerCase().indexOf(query.toLowerCase());
            int endPos = startPos + query.length();
            if (startPos != -1) {
                SpannableString spannable = new SpannableString((CharSequence)originalString);
                ColorStateList blackColor = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{-16777216});
                TextAppearanceSpan highlightSpan = new TextAppearanceSpan(null, 1, -1, blackColor, null);
                spannable.setSpan((Object)highlightSpan, startPos, endPos, 33);
                tv.setText((CharSequence)spannable);
            } else {
                tv.setText((CharSequence)originalString);
            }
        } else {
            tv.setText((CharSequence)originalString);
        }
    }

    protected void setAllSelected(boolean isAll) {
        for (Contact c : this.contactItemList) {
            c.setSelected(isAll);
            if (this.listener == null) continue;
            this.listener.onContactSelected(c, this.getSelectedContactsCount());
        }
        this.notifyDataSetChanged();
    }

    protected void setContactSelected(long id2) {
        int pos;
        this.contactItemList.get(pos).setSelected(!this.contactItemList.get(pos = this.getItemPosition(this.contactItemList, id2)).isSelected());
    }

    private int getItemPosition(List<Contact> list, long mid) {
        int i = 0;
        for (Contact contact : list) {
            if (contact.getId() == mid) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getSelectedContactsCount() {
        return this.getSelectedContacts() != null ? this.getSelectedContacts().size() : 0;
    }

    List<Contact> getSelectedContacts() {
        ArrayList<Contact> selectedContacts = new ArrayList<Contact>();
        for (Contact contact : this.contactItemListOriginal) {
            if (!contact.isSelected()) continue;
            selectedContacts.add(contact);
        }
        return selectedContacts;
    }

    public int getItemCount() {
        return null != this.contactItemList ? this.contactItemList.size() : 0;
    }

    private Contact getItem(int pos) {
        return this.contactItemList.get(pos);
    }

    public String getSectionText(int position) {
        try {
            return String.valueOf(this.contactItemList.get(position).getDisplayName().charAt(0));
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void filterOnText(String query) {
        this.currentFilterQuery = query;
        this.getFilter().filter((CharSequence)this.currentFilterQuery);
    }

    public Filter getFilter() {
        return new Filter(){

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                MultiContactPickerAdapter.this.contactItemList = (List)results.values;
                MultiContactPickerAdapter.this.notifyDataSetChanged();
            }

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                List filteredResults = null;
                if (constraint.length() == 0) {
                    filteredResults = MultiContactPickerAdapter.this.contactItemListOriginal;
                    MultiContactPickerAdapter.this.currentFilterQuery = null;
                } else {
                    filteredResults = MultiContactPickerAdapter.this.getFilteredResults(constraint.toString().toLowerCase());
                }
                Filter.FilterResults results = new Filter.FilterResults();
                results.values = filteredResults;
                return results;
            }
        };
    }

    private List<Contact> getFilteredResults(String constraint) {
        ArrayList<Contact> results = new ArrayList<Contact>();
        for (Contact item : this.contactItemListOriginal) {
            if (!item.getDisplayName().toLowerCase().contains(constraint)) continue;
            results.add(item);
        }
        return results;
    }

    private class ContactViewHolder
    extends RecyclerView.ViewHolder {
        private final View mView;
        private TextView tvContactName;
        private TextView tvNumber;
        private RoundLetterView vRoundLetterView;
        private ImageView ivSelectedState;

        ContactViewHolder(View view) {
            super(view);
            this.mView = view;
            this.vRoundLetterView = (RoundLetterView)view.findViewById(R.id.vRoundLetterView);
            this.tvContactName = (TextView)view.findViewById(R.id.tvContactName);
            this.tvNumber = (TextView)view.findViewById(R.id.tvNumber);
            this.ivSelectedState = (ImageView)view.findViewById(R.id.ivSelectedState);
        }
    }

    static interface ContactSelectListener {
        public void onContactSelected(Contact var1, int var2);
    }
}

