/*
 * Decompiled with CFR 0.152.
 */
package com.wafflecopter.multicontactpicker;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.l4digital.fastscroll.FastScrollRecyclerView;
import com.miguelcatalan.materialsearchview.MaterialSearchView;
import com.wafflecopter.multicontactpicker.MultiContactPicker;
import com.wafflecopter.multicontactpicker.MultiContactPickerAdapter;
import com.wafflecopter.multicontactpicker.R;
import com.wafflecopter.multicontactpicker.RxContacts.Contact;
import com.wafflecopter.multicontactpicker.RxContacts.RxContacts;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MultiContactPickerActivity
extends AppCompatActivity
implements MaterialSearchView.OnQueryTextListener {
    public static final String EXTRA_RESULT_SELECTION = "extra_result_selection";
    private FastScrollRecyclerView recyclerView;
    private List<Contact> contactList = new ArrayList<Contact>();
    private TextView tvSelectAll;
    private TextView tvSelectBtn;
    private TextView tvNoContacts;
    private LinearLayout controlPanel;
    private MultiContactPickerAdapter adapter;
    private Toolbar toolbar;
    private MaterialSearchView searchView;
    private ProgressBar progressBar;
    private MenuItem searchMenuItem;
    private MultiContactPicker.Builder builder;
    private boolean allSelected = false;
    private CompositeDisposable disposables;
    private Integer animationCloseEnter;
    private Integer animationCloseExit;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent == null) {
            return;
        }
        this.builder = (MultiContactPicker.Builder)intent.getSerializableExtra("builder");
        this.disposables = new CompositeDisposable();
        this.setTheme(this.builder.theme);
        this.setContentView(R.layout.activity_multi_contact_picker);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.searchView = (MaterialSearchView)this.findViewById(R.id.search_view);
        this.controlPanel = (LinearLayout)this.findViewById(R.id.controlPanel);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.tvSelectAll = (TextView)this.findViewById(R.id.tvSelectAll);
        this.tvSelectBtn = (TextView)this.findViewById(R.id.tvSelect);
        this.tvNoContacts = (TextView)this.findViewById(R.id.tvNoContacts);
        this.recyclerView = (FastScrollRecyclerView)this.findViewById(R.id.recyclerView);
        this.initialiseUI(this.builder);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.adapter = new MultiContactPickerAdapter(this.contactList, new MultiContactPickerAdapter.ContactSelectListener(){

            @Override
            public void onContactSelected(Contact contact, int totalSelectedContacts) {
                MultiContactPickerActivity.this.updateSelectBarContents(totalSelectedContacts);
                if (((MultiContactPickerActivity)MultiContactPickerActivity.this).builder.selectionMode == 1) {
                    MultiContactPickerActivity.this.finishPicking();
                }
            }
        });
        this.loadContacts();
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.tvSelectBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MultiContactPickerActivity.this.finishPicking();
            }
        });
        this.tvSelectAll.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MultiContactPickerActivity.this.allSelected = !MultiContactPickerActivity.this.allSelected;
                if (MultiContactPickerActivity.this.adapter != null) {
                    MultiContactPickerActivity.this.adapter.setAllSelected(MultiContactPickerActivity.this.allSelected);
                }
                if (MultiContactPickerActivity.this.allSelected) {
                    MultiContactPickerActivity.this.tvSelectAll.setText((CharSequence)MultiContactPickerActivity.this.getString(R.string.tv_unselect_all_btn_text));
                } else {
                    MultiContactPickerActivity.this.tvSelectAll.setText((CharSequence)MultiContactPickerActivity.this.getString(R.string.tv_select_all_btn_text));
                }
            }
        });
    }

    private void finishPicking() {
        Intent result = new Intent();
        result.putExtra(EXTRA_RESULT_SELECTION, MultiContactPicker.buildResult(this.adapter.getSelectedContacts()));
        this.setResult(-1, result);
        this.finish();
        this.overrideAnimation();
    }

    private void overrideAnimation() {
        if (this.animationCloseEnter != null && this.animationCloseExit != null) {
            this.overridePendingTransition(this.animationCloseEnter, this.animationCloseExit);
        }
    }

    private void updateSelectBarContents(int totalSelectedContacts) {
        this.tvSelectBtn.setEnabled(totalSelectedContacts > 0);
        if (totalSelectedContacts > 0) {
            this.tvSelectBtn.setText((CharSequence)this.getString(R.string.tv_select_btn_text_enabled, new Object[]{String.valueOf(totalSelectedContacts)}));
        } else {
            this.tvSelectBtn.setText((CharSequence)this.getString(R.string.tv_select_btn_text_disabled));
        }
    }

    private void initialiseUI(MultiContactPicker.Builder builder) {
        this.setSupportActionBar(this.toolbar);
        this.searchView.setOnQueryTextListener((MaterialSearchView.OnQueryTextListener)this);
        this.animationCloseEnter = builder.animationCloseEnter;
        this.animationCloseExit = builder.animationCloseExit;
        if (builder.bubbleColor != 0) {
            this.recyclerView.setBubbleColor(builder.bubbleColor);
        }
        if (builder.handleColor != 0) {
            this.recyclerView.setHandleColor(builder.handleColor);
        }
        if (builder.bubbleTextColor != 0) {
            this.recyclerView.setBubbleTextColor(builder.bubbleTextColor);
        }
        if (builder.trackColor != 0) {
            this.recyclerView.setTrackColor(builder.trackColor);
        }
        this.recyclerView.setHideScrollbar(builder.hideScrollbar);
        this.recyclerView.setTrackVisible(builder.showTrack);
        if (builder.selectionMode == 1) {
            this.controlPanel.setVisibility(8);
        } else {
            this.controlPanel.setVisibility(0);
        }
        if (builder.selectionMode == 1 && builder.selectedItems.size() > 0) {
            throw new RuntimeException("You must be using MultiContactPicker.CHOICE_MODE_MULTIPLE in order to use setSelectedContacts()");
        }
        if (builder.titleText != null) {
            this.setTitle(builder.titleText);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.setResult(0);
                this.finish();
                this.overrideAnimation();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void loadContacts() {
        this.tvSelectAll.setEnabled(false);
        this.progressBar.setVisibility(0);
        RxContacts.fetch(this.builder.columnLimit, (Context)this).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) throws Exception {
                MultiContactPickerActivity.this.disposables.add(disposable);
            }
        }).filter((Predicate)new Predicate<Contact>(){

            public boolean test(Contact contact) throws Exception {
                return contact.getDisplayName() != null;
            }
        }).subscribe((Observer)new Observer<Contact>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(Contact value) {
                MultiContactPickerActivity.this.contactList.add(value);
                if (((MultiContactPickerActivity)MultiContactPickerActivity.this).builder.selectedItems.contains(value.getId())) {
                    MultiContactPickerActivity.this.adapter.setContactSelected(value.getId());
                }
                Collections.sort(MultiContactPickerActivity.this.contactList, new Comparator<Contact>(){

                    @Override
                    public int compare(Contact contact, Contact t1) {
                        return contact.getDisplayName().compareToIgnoreCase(t1.getDisplayName());
                    }
                });
                if (((MultiContactPickerActivity)MultiContactPickerActivity.this).builder.loadingMode == 0) {
                    if (MultiContactPickerActivity.this.adapter != null) {
                        MultiContactPickerActivity.this.adapter.notifyDataSetChanged();
                    }
                    MultiContactPickerActivity.this.progressBar.setVisibility(8);
                }
            }

            public void onError(Throwable e) {
                MultiContactPickerActivity.this.progressBar.setVisibility(8);
                e.printStackTrace();
            }

            public void onComplete() {
                if (MultiContactPickerActivity.this.contactList.size() == 0) {
                    MultiContactPickerActivity.this.tvNoContacts.setVisibility(0);
                }
                if (MultiContactPickerActivity.this.adapter != null && ((MultiContactPickerActivity)MultiContactPickerActivity.this).builder.loadingMode == 1) {
                    MultiContactPickerActivity.this.adapter.notifyDataSetChanged();
                }
                if (MultiContactPickerActivity.this.adapter != null) {
                    MultiContactPickerActivity.this.updateSelectBarContents(MultiContactPickerActivity.this.adapter.getSelectedContactsCount());
                }
                MultiContactPickerActivity.this.progressBar.setVisibility(8);
                MultiContactPickerActivity.this.tvSelectAll.setEnabled(true);
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.mcp_menu_main, menu2);
        this.searchMenuItem = menu2.findItem(R.id.mcp_action_search);
        this.setSearchIconColor(this.searchMenuItem, this.builder.searchIconColor);
        this.searchView.setMenuItem(this.searchMenuItem);
        return true;
    }

    private void setSearchIconColor(MenuItem menuItem, Integer color) {
        Drawable drawable;
        if (color != null && (drawable = menuItem.getIcon()) != null) {
            drawable = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.setTint((Drawable)drawable.mutate(), (int)color);
            menuItem.setIcon(drawable);
        }
    }

    public boolean onQueryTextSubmit(String query) {
        if (this.adapter != null) {
            this.adapter.filterOnText(query);
        }
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        if (this.adapter != null) {
            this.adapter.filterOnText(newText);
        }
        return false;
    }

    public void onBackPressed() {
        if (this.searchView.isSearchOpen()) {
            this.searchView.closeSearch();
        } else {
            super.onBackPressed();
            this.overrideAnimation();
        }
    }

    public void onDestroy() {
        this.disposables.clear();
        super.onDestroy();
    }
}

