/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import java.util.Date;
import java.util.logging.Level;
import pl.brightinventions.slf4android.LogLevel;

public class LogRecord
extends java.util.logging.LogRecord {
    private static ThreadLocal<String> currentThreadName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return Thread.currentThread().getName();
        }
    };
    private final String threadName = currentThreadName.get();
    private final LogLevel logLevel = LogLevel.valueOf(this.getLevel());
    private final Date date = new Date(this.getMillis());

    public LogRecord(Level level, String msg) {
        super(level, msg);
    }

    public static LogRecord fromRecord(java.util.logging.LogRecord r) {
        if (r instanceof LogRecord) {
            return (LogRecord)r;
        }
        LogRecord wrapped = new LogRecord(r.getLevel(), r.getMessage());
        wrapped.setParameters(r.getParameters());
        wrapped.setLoggerName(r.getLoggerName());
        wrapped.setThreadID(r.getThreadID());
        return wrapped;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public Date getDate() {
        return this.date;
    }
}

