/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import java.util.concurrent.ConcurrentLinkedQueue;
import pl.brightinventions.slf4android.LogRecord;
import pl.brightinventions.slf4android.LogRecordFormatter;
import pl.brightinventions.slf4android.LoggerPatternValueSupplier;

class ListLogRecordFormatter
implements LogRecordFormatter {
    private ConcurrentLinkedQueue<LoggerPatternValueSupplier> valueSuppliers = new ConcurrentLinkedQueue();

    ListLogRecordFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder logMessage = new StringBuilder();
        for (LoggerPatternValueSupplier supplier : this.valueSuppliers) {
            supplier.append(record, logMessage);
        }
        return logMessage.toString();
    }

    public void add(LoggerPatternValueSupplier supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier must not be null");
        }
        this.valueSuppliers.add(supplier);
    }
}

