/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import pl.brightinventions.slf4android.ActivityStateListener;
import pl.brightinventions.slf4android.ConstLoggerValueSupplier;
import pl.brightinventions.slf4android.DateValueSupplier;
import pl.brightinventions.slf4android.Disposable;
import pl.brightinventions.slf4android.FileLogHandler;
import pl.brightinventions.slf4android.FileLogHandlerConfiguration;
import pl.brightinventions.slf4android.HandlerFormatterCompiler;
import pl.brightinventions.slf4android.LevelValueSupplier;
import pl.brightinventions.slf4android.LogRecordFormatter;
import pl.brightinventions.slf4android.LogcatHandler;
import pl.brightinventions.slf4android.LoggerNameValueSupplier;
import pl.brightinventions.slf4android.LoggerPattern;
import pl.brightinventions.slf4android.LoggerPatternConfiguration;
import pl.brightinventions.slf4android.LoggerPatternValueSupplier;
import pl.brightinventions.slf4android.MakeScreenShotAsyncTask;
import pl.brightinventions.slf4android.MessageValueSupplier;
import pl.brightinventions.slf4android.NotifyDeveloperHandler;
import pl.brightinventions.slf4android.ReadLogcatEntriesAsyncTask;
import pl.brightinventions.slf4android.ThreadValueSupplier;

public class LoggerConfiguration
implements LoggerPatternConfiguration {
    private static boolean initialized = false;
    private static LoggerConfiguration configuration;
    private final ArrayList<LoggerPattern> loggerPatterns = new ArrayList();
    private final ArrayList<Disposable> disposeThingsOnReset = new ArrayList();
    private final HandlerFormatterCompiler compiler = new HandlerFormatterCompiler(this);

    public static LoggerConfiguration resetConfigurationToDefault() {
        if (configuration != null) {
            configuration.dispose();
        }
        LoggerConfiguration.configureDefaults();
        return configuration;
    }

    private void dispose() {
        for (Disposable dispose : this.disposeThingsOnReset) {
            dispose.dispose();
        }
    }

    private static void configureDefaults() {
        LoggerConfiguration.defaultConfiguration();
        LoggerConfiguration.setupDefaultRootLoggerHandler();
    }

    private static void defaultConfiguration() {
        configuration = new LoggerConfiguration();
        configuration.registerPattern("%newline", new ConstLoggerValueSupplier(System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "\n"));
        configuration.registerPattern("%message", new MessageValueSupplier());
        configuration.registerPattern("%thread", new ThreadValueSupplier());
        configuration.registerPattern("%name", new LoggerNameValueSupplier());
        configuration.registerPattern("%level", new LevelValueSupplier());
        configuration.registerPattern("%date", new DateValueSupplier());
    }

    private static void setupDefaultRootLoggerHandler() {
        Logger rootLogger = LoggerConfiguration.removeRootLogHandlers();
        rootLogger.addHandler(new LogcatHandler(LoggerConfiguration.configuration.compiler.compile("%message")));
    }

    public void registerPattern(String pattern, LoggerPatternValueSupplier valueSupplier) {
        this.loggerPatterns.add(0, new LoggerPattern(pattern, valueSupplier));
    }

    private static Logger removeRootLogHandlers() {
        return LoggerConfiguration.removeLogHandlers("");
    }

    private static Logger removeLogHandlers(String loggerName) {
        Logger rootLogger = LogManager.getLogManager().getLogger(loggerName);
        for (Handler handler : Arrays.asList(rootLogger.getHandlers())) {
            rootLogger.removeHandler(handler);
        }
        return rootLogger;
    }

    public static FileLogHandlerConfiguration fileLogHandler(Context context) {
        LogRecordFormatter formatter = LoggerConfiguration.configuration().compiler.compile("%date %level [%thread] %name - %message%newline");
        return new FileLogHandler(context, formatter);
    }

    public static LoggerConfiguration configuration() {
        LoggerConfiguration.ensureInitialized();
        return configuration;
    }

    static synchronized void ensureInitialized() {
        if (!initialized) {
            initialized = true;
            LoggerConfiguration.configureDefaults();
        }
    }

    public Iterable<LoggerPattern> getPatterns() {
        return this.loggerPatterns;
    }

    public LoggerConfiguration removeRootLogcatHandler() {
        return this.removeRootLogHandler(LogcatHandler.class);
    }

    private LoggerConfiguration removeRootLogHandler(Class<LogcatHandler> handlerToRemoveClass) {
        return this.removeHandlerFromLogger("", handlerToRemoveClass);
    }

    public LoggerConfiguration removeHandlerFromLogger(String loggerName, Class<? extends Handler> handlerToRemoveClass) {
        Logger rootLogger = LogManager.getLogManager().getLogger(loggerName);
        for (Handler handler : Arrays.asList(rootLogger.getHandlers())) {
            if (!handlerToRemoveClass.isAssignableFrom(handler.getClass())) continue;
            rootLogger.removeHandler(handler);
        }
        return this;
    }

    public NotifyDeveloperHandler notifyDeveloperHandler(Application context, String email) {
        ActivityStateListener stateListener = this.getStateListener(context);
        ArrayList<String> emails = new ArrayList<String>();
        emails.add(email);
        NotifyDeveloperHandler handler = new NotifyDeveloperHandler(context, emails, stateListener);
        handler.addAttachmentClass(ReadLogcatEntriesAsyncTask.class);
        handler.addAttachmentClass(MakeScreenShotAsyncTask.class);
        return handler;
    }

    @TargetApi(value=14)
    private ActivityStateListener getStateListener(final Application context) {
        if (Build.VERSION.SDK_INT >= 14) {
            final ActivityStateListener stateListener = new ActivityStateListener();
            this.disposeThingsOnReset.add(new Disposable(){

                @Override
                public void dispose() {
                    context.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)stateListener);
                }
            });
            context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)stateListener);
            return stateListener;
        }
        return null;
    }

    public Logger addHandlerToLogger(String loggerName, Handler handler) {
        Logger logger = Logger.getLogger(loggerName);
        logger.addHandler(handler);
        return logger;
    }

    public Logger addHandlerToRootLogger(Handler handler) {
        Logger logger = Logger.getLogger("");
        logger.addHandler(handler);
        return logger;
    }
}

