/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import android.util.Log;
import java.util.logging.Handler;
import pl.brightinventions.slf4android.LogRecord;
import pl.brightinventions.slf4android.LogRecordFormatter;

public class LogcatHandler
extends Handler {
    private final LogRecordFormatter logRecordFormatter;

    public LogcatHandler(LogRecordFormatter logRecordFormatter) {
        this.logRecordFormatter = logRecordFormatter;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(java.util.logging.LogRecord record) {
        LogRecord slfRecord = LogRecord.fromRecord(record);
        int level = slfRecord.getLogLevel().getAndroidLevel();
        String tag = record.getLoggerName();
        try {
            String message = this.logRecordFormatter.format(slfRecord);
            Log.println((int)level, (String)tag, (String)message);
        }
        catch (RuntimeException e) {
            Log.e((String)"LogcatHandler", (String)"Error logging message.", (Throwable)e);
        }
    }
}

