/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.DefaultVideoControls;
import com.devbrackets.android.exomedia.util.LongExtensionsKt;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001BB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020(H\u0014J\b\u00102\u001a\u00020.H\u0016J\u0010\u00103\u001a\u00020.2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020.H\u0014J\u0010\u00107\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0015H\u0016J\b\u00108\u001a\u00020.H\u0014J\u0012\u00109\u001a\u00020.2\b\b\u0001\u0010:\u001a\u000205H\u0016J\u0012\u0010;\u001a\u00020.2\b\b\u0001\u0010<\u001a\u000205H\u0016J\u0010\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020(H\u0016J&\u0010?\u001a\u00020.2\b\b\u0001\u0010<\u001a\u0002052\b\b\u0001\u0010:\u001a\u0002052\b\b\u0001\u0010@\u001a\u00020\tH\u0016J\b\u0010A\u001a\u00020.H\u0014R\u001a\u0010\r\u001a\u00020\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006C"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "container", "Landroid/view/ViewGroup;", "getContainer", "()Landroid/view/ViewGroup;", "setContainer", "(Landroid/view/ViewGroup;)V", "extraViews", "", "Landroid/view/View;", "getExtraViews", "()Ljava/util/List;", "extraViewsContainer", "Landroid/widget/LinearLayout;", "getExtraViewsContainer", "()Landroid/widget/LinearLayout;", "setExtraViewsContainer", "(Landroid/widget/LinearLayout;)V", "layoutResource", "getLayoutResource", "()I", "seekBar", "Landroid/widget/SeekBar;", "getSeekBar", "()Landroid/widget/SeekBar;", "setSeekBar", "(Landroid/widget/SeekBar;)V", "userInteracting", "", "getUserInteracting", "()Z", "setUserInteracting", "(Z)V", "addExtraView", "", "view", "animateVisibility", "toVisible", "finishLoading", "hideDelayed", "delay", "", "registerListeners", "removeExtraView", "retrieveViews", "setDuration", "duration", "setPosition", "position", "showLoading", "initialLoad", "updateProgress", "bufferPercent", "updateTextContainerVisibility", "SeekBarChanged", "library_release"})
public final class VideoControlsMobile
extends DefaultVideoControls {
    protected SeekBar seekBar;
    protected LinearLayout extraViewsContainer;
    protected ViewGroup container;
    private boolean userInteracting;

    @NotNull
    protected final SeekBar getSeekBar() {
        SeekBar seekBar = this.seekBar;
        if (seekBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
        }
        return seekBar;
    }

    protected final void setSeekBar(@NotNull SeekBar seekBar) {
        Intrinsics.checkNotNullParameter((Object)seekBar, (String)"<set-?>");
        this.seekBar = seekBar;
    }

    @NotNull
    protected final LinearLayout getExtraViewsContainer() {
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
        }
        return linearLayout;
    }

    protected final void setExtraViewsContainer(@NotNull LinearLayout linearLayout) {
        Intrinsics.checkNotNullParameter((Object)linearLayout, (String)"<set-?>");
        this.extraViewsContainer = linearLayout;
    }

    @NotNull
    protected final ViewGroup getContainer() {
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return viewGroup;
    }

    protected final void setContainer(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"<set-?>");
        this.container = viewGroup;
    }

    protected final boolean getUserInteracting() {
        return this.userInteracting;
    }

    protected final void setUserInteracting(boolean bl) {
        this.userInteracting = bl;
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_default_controls_mobile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<View> getExtraViews() {
        int childCount;
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
        }
        if ((childCount = linearLayout.getChildCount()) <= 0) {
            return super.getExtraViews();
        }
        LinkedList<View> children = new LinkedList<View>();
        int n = 0;
        int n2 = childCount;
        while (n < n2) {
            void i;
            LinearLayout linearLayout2 = this.extraViewsContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
            }
            children.add(linearLayout2.getChildAt((int)i));
            ++i;
        }
        return children;
    }

    @Override
    public void setPosition(@IntRange(from=0L) long position) {
        this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedTimeString(position));
        SeekBar seekBar = this.seekBar;
        if (seekBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
        }
        seekBar.setProgress((int)position);
    }

    @Override
    public void setDuration(@IntRange(from=0L) long duration) {
        SeekBar seekBar = this.seekBar;
        if (seekBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
        }
        if (duration != (long)seekBar.getMax()) {
            this.getEndTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedTimeString(duration));
            SeekBar seekBar2 = this.seekBar;
            if (seekBar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
            }
            seekBar2.setMax((int)duration);
        }
    }

    @Override
    public void updateProgress(@IntRange(from=0L) long position, @IntRange(from=0L) long duration, @IntRange(from=0L, to=100L) int bufferPercent) {
        if (!this.userInteracting) {
            SeekBar seekBar = this.seekBar;
            if (seekBar == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
            }
            SeekBar seekBar2 = this.seekBar;
            if (seekBar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
            }
            seekBar.setSecondaryProgress((int)((float)seekBar2.getMax() * ((float)bufferPercent / (float)100)));
            SeekBar seekBar3 = this.seekBar;
            if (seekBar3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
            }
            seekBar3.setProgress((int)position);
            this.updateCurrentTime(position);
        }
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        SeekBar seekBar = this.seekBar;
        if (seekBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"seekBar");
        }
        seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new SeekBarChanged());
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        View view = this.findViewById(R.id.exomedia_controls_video_seek);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.exomedia_controls_video_seek)");
        this.seekBar = (SeekBar)view;
        View view2 = this.findViewById(R.id.exomedia_controls_extra_container);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.exomed\u2026controls_extra_container)");
        this.extraViewsContainer = (LinearLayout)view2;
        View view3 = this.findViewById(R.id.exomedia_controls_container);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.exomedia_controls_container)");
        this.container = (ViewGroup)view3;
    }

    @Override
    public void addExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
        }
        linearLayout.addView(view);
    }

    @Override
    public void removeExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LinearLayout linearLayout = this.extraViewsContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extraViewsContainer");
        }
        linearLayout.removeView(view);
    }

    @Override
    public void hideDelayed(long delay) {
        this.setHideDelay(delay);
        if (delay < 0L || !this.getCanViewHide() || this.isLoading()) {
            return;
        }
        if (!this.userInteracting) {
            this.getVisibilityHandler().postDelayed(new Runnable(this){
                final /* synthetic */ VideoControlsMobile this$0;

                public final void run() {
                    this.this$0.animateVisibility(false);
                }
                {
                    this.this$0 = videoControlsMobile;
                }
            }, delay);
        }
    }

    @Override
    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible() == toVisible) {
            return;
        }
        float endAlpha = toVisible ? 1.0f : 0.0f;
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        viewGroup.animate().alpha(endAlpha).start();
        this.setVisible(toVisible);
        this.onVisibilityChanged();
    }

    @Override
    protected void updateTextContainerVisibility() {
    }

    @Override
    public void showLoading(boolean initialLoad) {
        if (this.isLoading()) {
            return;
        }
        this.setLoading(true);
        this.getLoadingProgressBar().setVisibility(0);
        this.getPlayPauseButton().setVisibility(4);
        if (!initialLoad) {
            this.getPlayPauseButton().setEnabled(false);
            this.getPreviousButton().setEnabled(false);
            this.getNextButton().setEnabled(false);
        }
        this.show();
    }

    @Override
    public void finishLoading() {
        if (!this.isLoading()) {
            return;
        }
        this.setLoading(false);
        this.getLoadingProgressBar().setVisibility(8);
        ViewGroup viewGroup = this.container;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        viewGroup.setVisibility(0);
        this.getPlayPauseButton().setEnabled(true);
        this.getPlayPauseButton().setVisibility(0);
        this.getPreviousButton().setEnabled(this.getEnabledViews().get(R.id.exomedia_controls_previous_btn, true));
        this.getNextButton().setEnabled(this.getEnabledViews().get(R.id.exomedia_controls_next_btn, true));
        VideoView videoView = this.getVideoView();
        this.updatePlaybackState(videoView != null && videoView.isPlaying());
    }

    public VideoControlsMobile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public VideoControlsMobile(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
    }

    public VideoControlsMobile(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
    }

    public VideoControlsMobile(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile$SeekBarChanged;", "Landroid/widget/SeekBar$OnSeekBarChangeListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsMobile;)V", "seekToTime", "", "onProgressChanged", "", "seekBar", "Landroid/widget/SeekBar;", "progress", "", "fromUser", "", "onStartTrackingTouch", "onStopTrackingTouch", "library_release"})
    protected final class SeekBarChanged
    implements SeekBar.OnSeekBarChangeListener {
        private long seekToTime;

        public void onProgressChanged(@NotNull SeekBar seekBar, int progress, boolean fromUser) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            if (!fromUser) {
                return;
            }
            this.seekToTime = progress;
            VideoControlsMobile.this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedTimeString(this.seekToTime));
        }

        public void onStartTrackingTouch(@NotNull SeekBar seekBar) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            VideoControlsMobile.this.setUserInteracting(true);
            VideoControlsSeekListener videoControlsSeekListener = VideoControlsMobile.this.getSeekListener();
            if (videoControlsSeekListener == null || !videoControlsSeekListener.onSeekStarted()) {
                VideoControlsMobile.this.getInternalListener().onSeekStarted();
            }
        }

        public void onStopTrackingTouch(@NotNull SeekBar seekBar) {
            Intrinsics.checkNotNullParameter((Object)seekBar, (String)"seekBar");
            VideoControlsMobile.this.setUserInteracting(false);
            VideoControlsSeekListener videoControlsSeekListener = VideoControlsMobile.this.getSeekListener();
            if (videoControlsSeekListener == null || !videoControlsSeekListener.onSeekEnded(this.seekToTime)) {
                VideoControlsMobile.this.getInternalListener().onSeekEnded(this.seekToTime);
            }
        }
    }
}

