/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsButtonListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsVisibilityListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControls;
import com.devbrackets.android.exomedia.util.LongExtensionsKt;
import com.devbrackets.android.exomedia.util.Repeater;
import com.devbrackets.android.exomedia.util.ResourceExtensionsKt;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b*\n\u0002\u0010\r\n\u0002\b\u0011\b&\u0018\u0000 \u00c2\u00012\u00020\u00012\u00020\u0002:\u0004\u00c2\u0001\u00c3\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020+H\u0016J\u0013\u0010\u008a\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008b\u0001\u001a\u00020\u0015H$J\b\u0010\u008c\u0001\u001a\u00030\u0088\u0001J\u0013\u0010\u008c\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u0015H\u0016J\b\u0010\u008e\u0001\u001a\u00030\u0088\u0001J\u0013\u0010\u008e\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008f\u0001\u001a\u00020/H\u0016J\u0012\u0010\u0090\u0001\u001a\u00030\u0088\u00012\u0006\u0010u\u001a\u00020vH\u0016J\n\u0010\u0091\u0001\u001a\u00030\u0088\u0001H\u0014J\u0012\u0010\u0092\u0001\u001a\u00030\u0088\u00012\u0006\u0010u\u001a\u00020vH\u0016J\n\u0010\u0093\u0001\u001a\u00030\u0088\u0001H\u0014J\n\u0010\u0094\u0001\u001a\u00030\u0088\u0001H\u0004J\n\u0010\u0095\u0001\u001a\u00030\u0088\u0001H\u0004J\n\u0010\u0096\u0001\u001a\u00030\u0088\u0001H\u0004J\n\u0010\u0097\u0001\u001a\u00030\u0088\u0001H\u0004J\n\u0010\u0098\u0001\u001a\u00030\u0088\u0001H\u0014J\u0013\u0010\u0099\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020+H\u0016J\n\u0010\u009a\u0001\u001a\u00030\u0088\u0001H\u0014J\u0013\u0010\u009b\u0001\u001a\u00030\u0088\u00012\t\u0010\u009c\u0001\u001a\u0004\u0018\u00010\u000fJ\u0011\u0010\u009d\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u009e\u0001\u001a\u00020\u0015J\u0013\u0010\u009f\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0015H\u0016J\u0013\u0010\u00a1\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u0015H\u0016J\u0013\u0010\u00a3\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a4\u0001\u001a\u00020UH\u0016J\u0011\u0010\u00a5\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0015J\u0011\u0010\u00a6\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u0015J\u0011\u0010\u00a7\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a4\u0001\u001a\u00020UJ\u0018\u0010\u00a8\u0001\u001a\u00030\u0088\u00012\u0006\u0010Z\u001a\u00020U2\u0006\u0010T\u001a\u00020UJ\u0015\u0010\u00a9\u0001\u001a\u00030\u0088\u00012\t\b\u0001\u0010\u00aa\u0001\u001a\u00020/H&J\u0011\u0010\u00ab\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0015J\u0011\u0010\u00ac\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u0015J\u0011\u0010\u00ad\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a4\u0001\u001a\u00020UJ\u0013\u0010\u00ae\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0015H\u0016J\u0013\u0010\u00af\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u0015H\u0016J\u0013\u0010\u00b0\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00a4\u0001\u001a\u00020UH\u0016J\u0014\u0010\u00b1\u0001\u001a\u00030\u0088\u00012\n\u0010\u00b2\u0001\u001a\u0005\u0018\u00010\u00b3\u0001J\u0014\u0010\u00b4\u0001\u001a\u00030\u0088\u00012\n\u0010\u00b5\u0001\u001a\u0005\u0018\u00010\u00b3\u0001J\u0012\u0010\u00b6\u0001\u001a\u00030\u0088\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\n\u0010\u00b7\u0001\u001a\u00030\u0088\u0001H\u0016J\n\u0010\u00b8\u0001\u001a\u00030\u0088\u0001H\u0014J\u0015\u0010\u00b8\u0001\u001a\u00030\u0088\u00012\t\b\u0001\u0010\u00b9\u0001\u001a\u00020\nH\u0014J\u0013\u0010\u00ba\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00aa\u0001\u001a\u00020/H\u0004J\u0011\u0010\u00bb\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00bc\u0001\u001a\u00020\u0015J\u0013\u0010\u00bd\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u00bc\u0001\u001a\u00020\u0015H\u0016J\n\u0010\u00be\u0001\u001a\u00030\u0088\u0001H\u0004J+\u0010\u00be\u0001\u001a\u00030\u0088\u00012\t\b\u0001\u0010\u00aa\u0001\u001a\u00020/2\t\b\u0001\u0010\u00bf\u0001\u001a\u00020/2\t\b\u0001\u0010\u00c0\u0001\u001a\u00020\nH&J\n\u0010\u00c1\u0001\u001a\u00030\u0088\u0001H$R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010\u001fR\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00105\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0015@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0017\"\u0004\b7\u0010\u0019R\u001e\u00108\u001a\u000609R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0017\"\u0004\b?\u0010\u0019R\u0014\u0010@\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0017R$\u0010B\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u0015@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0017\"\u0004\bC\u0010\u0019R\u000e\u0010D\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u00020\n8eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020IX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001a\u0010N\u001a\u00020OX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020UX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020UX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010W\"\u0004\b\\\u0010YR\u001a\u0010]\u001a\u00020OX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010Q\"\u0004\b_\u0010SR\u001a\u0010`\u001a\u00020OX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010Q\"\u0004\bb\u0010SR\u001a\u0010c\u001a\u00020dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010f\"\u0004\bg\u0010hR\u001c\u0010i\u001a\u0004\u0018\u00010jX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u001a\u0010o\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010\u001d\"\u0004\bq\u0010\u001fR\u001a\u0010r\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010\u001d\"\u0004\bt\u0010\u001fR\u001c\u0010u\u001a\u0004\u0018\u00010vX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u001b\u0010{\u001a\u00020|X\u0084\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b}\u0010~\"\u0005\b\u007f\u0010\u0080\u0001R\"\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001\"\u0006\b\u0085\u0001\u0010\u0086\u0001\u00a8\u0006\u00c4\u0001"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "Landroid/widget/RelativeLayout;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "buttonsListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "getButtonsListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "setButtonsListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;)V", "canViewHide", "", "getCanViewHide", "()Z", "setCanViewHide", "(Z)V", "currentTimeTextView", "Landroid/widget/TextView;", "getCurrentTimeTextView", "()Landroid/widget/TextView;", "setCurrentTimeTextView", "(Landroid/widget/TextView;)V", "enabledViews", "Landroid/util/SparseBooleanArray;", "getEnabledViews", "()Landroid/util/SparseBooleanArray;", "setEnabledViews", "(Landroid/util/SparseBooleanArray;)V", "endTimeTextView", "getEndTimeTextView", "setEndTimeTextView", "extraViews", "", "Landroid/view/View;", "getExtraViews", "()Ljava/util/List;", "hideDelay", "", "getHideDelay", "()J", "setHideDelay", "(J)V", "value", "hideEmptyTextContainer", "getHideEmptyTextContainer", "setHideEmptyTextContainer", "internalListener", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "getInternalListener", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "setInternalListener", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;)V", "isLoading", "setLoading", "isTextContainerEmpty", "<set-?>", "isVisible", "setVisible", "lastUpdatedPosition", "layoutResource", "getLayoutResource", "()I", "loadingProgressBar", "Landroid/widget/ProgressBar;", "getLoadingProgressBar", "()Landroid/widget/ProgressBar;", "setLoadingProgressBar", "(Landroid/widget/ProgressBar;)V", "nextButton", "Landroid/widget/ImageButton;", "getNextButton", "()Landroid/widget/ImageButton;", "setNextButton", "(Landroid/widget/ImageButton;)V", "pauseDrawable", "Landroid/graphics/drawable/Drawable;", "getPauseDrawable", "()Landroid/graphics/drawable/Drawable;", "setPauseDrawable", "(Landroid/graphics/drawable/Drawable;)V", "playDrawable", "getPlayDrawable", "setPlayDrawable", "playPauseButton", "getPlayPauseButton", "setPlayPauseButton", "previousButton", "getPreviousButton", "setPreviousButton", "progressPollRepeater", "Lcom/devbrackets/android/exomedia/util/Repeater;", "getProgressPollRepeater", "()Lcom/devbrackets/android/exomedia/util/Repeater;", "setProgressPollRepeater", "(Lcom/devbrackets/android/exomedia/util/Repeater;)V", "seekListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "getSeekListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "setSeekListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;)V", "subTitleTextView", "getSubTitleTextView", "setSubTitleTextView", "titleTextView", "getTitleTextView", "setTitleTextView", "videoView", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "getVideoView", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "setVideoView", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "visibilityHandler", "Landroid/os/Handler;", "getVisibilityHandler", "()Landroid/os/Handler;", "setVisibilityHandler", "(Landroid/os/Handler;)V", "visibilityListener", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;", "getVisibilityListener", "()Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;", "setVisibilityListener", "(Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsVisibilityListener;)V", "addExtraView", "", "view", "animateVisibility", "toVisible", "hide", "delayed", "hideDelayed", "delay", "onAttachedToView", "onAttachedToWindow", "onDetachedFromView", "onDetachedFromWindow", "onNextClick", "onPlayPauseClick", "onPreviousClick", "onVisibilityChanged", "registerListeners", "removeExtraView", "retrieveViews", "setButtonListener", "callback", "setCanHide", "canHide", "setFastForwardButtonEnabled", "enabled", "setFastForwardButtonRemoved", "removed", "setFastForwardDrawable", "drawable", "setNextButtonEnabled", "setNextButtonRemoved", "setNextDrawable", "setPlayPauseDrawables", "setPosition", "position", "setPreviousButtonEnabled", "setPreviousButtonRemoved", "setPreviousDrawable", "setRewindButtonEnabled", "setRewindButtonRemoved", "setRewindDrawable", "setSubTitle", "subTitle", "", "setTitle", "title", "setup", "show", "updateButtonDrawables", "tintList", "updateCurrentTime", "updatePlayPauseImage", "isPlaying", "updatePlaybackState", "updateProgress", "duration", "bufferPercent", "updateTextContainerVisibility", "Companion", "InternalListener", "library_release"})
public abstract class DefaultVideoControls
extends RelativeLayout
implements VideoControls {
    protected TextView currentTimeTextView;
    protected TextView endTimeTextView;
    protected TextView titleTextView;
    protected TextView subTitleTextView;
    protected ImageButton playPauseButton;
    protected ImageButton previousButton;
    protected ImageButton nextButton;
    protected ProgressBar loadingProgressBar;
    protected Drawable playDrawable;
    protected Drawable pauseDrawable;
    @NotNull
    private Handler visibilityHandler;
    @NotNull
    private Repeater progressPollRepeater;
    @Nullable
    private VideoView videoView;
    @Nullable
    private VideoControlsSeekListener seekListener;
    @Nullable
    private VideoControlsButtonListener buttonsListener;
    @Nullable
    private VideoControlsVisibilityListener visibilityListener;
    @NotNull
    private InternalListener internalListener;
    @NotNull
    private SparseBooleanArray enabledViews;
    private long hideDelay;
    private boolean isLoading;
    private boolean isVisible;
    private boolean canViewHide;
    private boolean hideEmptyTextContainer;
    private long lastUpdatedPosition;
    private static final int DEFAULT_CONTROL_HIDE_DELAY;
    private static final long CONTROL_VISIBILITY_ANIMATION_LENGTH;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected final TextView getCurrentTimeTextView() {
        TextView textView = this.currentTimeTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentTimeTextView");
        }
        return textView;
    }

    protected final void setCurrentTimeTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.currentTimeTextView = textView;
    }

    @NotNull
    protected final TextView getEndTimeTextView() {
        TextView textView = this.endTimeTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endTimeTextView");
        }
        return textView;
    }

    protected final void setEndTimeTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.endTimeTextView = textView;
    }

    @NotNull
    protected final TextView getTitleTextView() {
        TextView textView = this.titleTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleTextView");
        }
        return textView;
    }

    protected final void setTitleTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.titleTextView = textView;
    }

    @NotNull
    protected final TextView getSubTitleTextView() {
        TextView textView = this.subTitleTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subTitleTextView");
        }
        return textView;
    }

    protected final void setSubTitleTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.subTitleTextView = textView;
    }

    @NotNull
    protected final ImageButton getPlayPauseButton() {
        ImageButton imageButton = this.playPauseButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playPauseButton");
        }
        return imageButton;
    }

    protected final void setPlayPauseButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.playPauseButton = imageButton;
    }

    @NotNull
    protected final ImageButton getPreviousButton() {
        ImageButton imageButton = this.previousButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        }
        return imageButton;
    }

    protected final void setPreviousButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.previousButton = imageButton;
    }

    @NotNull
    protected final ImageButton getNextButton() {
        ImageButton imageButton = this.nextButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        }
        return imageButton;
    }

    protected final void setNextButton(@NotNull ImageButton imageButton) {
        Intrinsics.checkNotNullParameter((Object)imageButton, (String)"<set-?>");
        this.nextButton = imageButton;
    }

    @NotNull
    protected final ProgressBar getLoadingProgressBar() {
        ProgressBar progressBar = this.loadingProgressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingProgressBar");
        }
        return progressBar;
    }

    protected final void setLoadingProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"<set-?>");
        this.loadingProgressBar = progressBar;
    }

    @NotNull
    protected final Drawable getPlayDrawable() {
        Drawable drawable2 = this.playDrawable;
        if (drawable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playDrawable");
        }
        return drawable2;
    }

    protected final void setPlayDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.playDrawable = drawable2;
    }

    @NotNull
    protected final Drawable getPauseDrawable() {
        Drawable drawable2 = this.pauseDrawable;
        if (drawable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pauseDrawable");
        }
        return drawable2;
    }

    protected final void setPauseDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"<set-?>");
        this.pauseDrawable = drawable2;
    }

    @NotNull
    protected final Handler getVisibilityHandler() {
        return this.visibilityHandler;
    }

    protected final void setVisibilityHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.visibilityHandler = handler;
    }

    @NotNull
    protected final Repeater getProgressPollRepeater() {
        return this.progressPollRepeater;
    }

    protected final void setProgressPollRepeater(@NotNull Repeater repeater) {
        Intrinsics.checkNotNullParameter((Object)repeater, (String)"<set-?>");
        this.progressPollRepeater = repeater;
    }

    @Nullable
    protected final VideoView getVideoView() {
        return this.videoView;
    }

    protected final void setVideoView(@Nullable VideoView videoView) {
        this.videoView = videoView;
    }

    @Nullable
    public final VideoControlsSeekListener getSeekListener() {
        return this.seekListener;
    }

    public final void setSeekListener(@Nullable VideoControlsSeekListener videoControlsSeekListener) {
        this.seekListener = videoControlsSeekListener;
    }

    @Nullable
    public final VideoControlsButtonListener getButtonsListener() {
        return this.buttonsListener;
    }

    public final void setButtonsListener(@Nullable VideoControlsButtonListener videoControlsButtonListener) {
        this.buttonsListener = videoControlsButtonListener;
    }

    @Nullable
    public final VideoControlsVisibilityListener getVisibilityListener() {
        return this.visibilityListener;
    }

    public final void setVisibilityListener(@Nullable VideoControlsVisibilityListener videoControlsVisibilityListener) {
        this.visibilityListener = videoControlsVisibilityListener;
    }

    @NotNull
    protected final InternalListener getInternalListener() {
        return this.internalListener;
    }

    protected final void setInternalListener(@NotNull InternalListener internalListener) {
        Intrinsics.checkNotNullParameter((Object)internalListener, (String)"<set-?>");
        this.internalListener = internalListener;
    }

    @NotNull
    protected final SparseBooleanArray getEnabledViews() {
        return this.enabledViews;
    }

    protected final void setEnabledViews(@NotNull SparseBooleanArray sparseBooleanArray) {
        Intrinsics.checkNotNullParameter((Object)sparseBooleanArray, (String)"<set-?>");
        this.enabledViews = sparseBooleanArray;
    }

    protected final long getHideDelay() {
        return this.hideDelay;
    }

    protected final void setHideDelay(long l) {
        this.hideDelay = l;
    }

    protected final boolean isLoading() {
        return this.isLoading;
    }

    protected final void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    protected void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    protected final boolean getCanViewHide() {
        return this.canViewHide;
    }

    protected final void setCanViewHide(boolean bl) {
        this.canViewHide = bl;
    }

    protected final boolean getHideEmptyTextContainer() {
        return this.hideEmptyTextContainer;
    }

    protected final void setHideEmptyTextContainer(boolean value) {
        this.hideEmptyTextContainer = value;
        this.updateTextContainerVisibility();
    }

    @LayoutRes
    protected abstract int getLayoutResource();

    @NotNull
    public List<View> getExtraViews() {
        return new LinkedList();
    }

    protected final boolean isTextContainerEmpty() {
        TextView textView = this.titleTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleTextView");
        }
        CharSequence charSequence = textView.getText();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return false;
        }
        TextView textView2 = this.subTitleTextView;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subTitleTextView");
        }
        charSequence = textView2.getText();
        bl = false;
        bl2 = false;
        return charSequence == null || charSequence.length() == 0;
    }

    public abstract void setPosition(@IntRange(from=0L) long var1);

    public abstract void updateProgress(@IntRange(from=0L) long var1, @IntRange(from=0L) long var3, @IntRange(from=0L, to=100L) int var5);

    protected abstract void animateVisibility(boolean var1);

    protected abstract void updateTextContainerVisibility();

    protected final void updateCurrentTime(long position) {
        long l = position - this.lastUpdatedPosition;
        boolean bl = false;
        if (Math.abs(l) >= (long)1000 || this.lastUpdatedPosition == 0L) {
            this.lastUpdatedPosition = position;
            TextView textView = this.currentTimeTextView;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTimeTextView");
            }
            textView.setText((CharSequence)LongExtensionsKt.millisToFormattedTimeString(position));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.progressPollRepeater.setRepeatListener((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultVideoControls this$0;

            public final void invoke() {
                this.this$0.updateProgress();
            }
            {
                this.this$0 = defaultVideoControls;
                super(0);
            }
        }));
        VideoView videoView = this.videoView;
        if (videoView != null) {
            if (videoView.isPlaying()) {
                this.updatePlaybackState(true);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.progressPollRepeater.stop();
        this.progressPollRepeater.setRepeatListener((Function0<Unit>)((Function0)null));
    }

    @Override
    public void onAttachedToView(@NotNull VideoView videoView) {
        Intrinsics.checkNotNullParameter((Object)((Object)videoView), (String)"videoView");
        videoView.addView((View)this);
        this.videoView = videoView;
    }

    @Override
    public void onDetachedFromView(@NotNull VideoView videoView) {
        Intrinsics.checkNotNullParameter((Object)((Object)videoView), (String)"videoView");
        videoView.removeView((View)this);
        this.videoView = null;
    }

    public final void setButtonListener(@Nullable VideoControlsButtonListener callback) {
        this.buttonsListener = callback;
    }

    @Override
    public void updatePlaybackState(boolean isPlaying) {
        this.updatePlayPauseImage(isPlaying);
        this.progressPollRepeater.start();
        if (isPlaying) {
            this.hideDelayed();
        } else {
            this.show();
        }
    }

    public final void setTitle(@Nullable CharSequence title) {
        TextView textView = this.titleTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleTextView");
        }
        textView.setText(title);
        this.updateTextContainerVisibility();
    }

    public final void setSubTitle(@Nullable CharSequence subTitle) {
        TextView textView = this.subTitleTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"subTitleTextView");
        }
        textView.setText(subTitle);
        this.updateTextContainerVisibility();
    }

    public final void setPlayPauseDrawables(@NotNull Drawable playDrawable, @NotNull Drawable pauseDrawable) {
        Intrinsics.checkNotNullParameter((Object)playDrawable, (String)"playDrawable");
        Intrinsics.checkNotNullParameter((Object)pauseDrawable, (String)"pauseDrawable");
        this.playDrawable = playDrawable;
        this.pauseDrawable = pauseDrawable;
        VideoView videoView = this.videoView;
        this.updatePlayPauseImage(videoView != null && videoView.isPlaying());
    }

    public final void setPreviousDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        ImageButton imageButton = this.previousButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        }
        imageButton.setImageDrawable(drawable2);
    }

    public final void setNextDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        ImageButton imageButton = this.nextButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        }
        imageButton.setImageDrawable(drawable2);
    }

    public void setRewindDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
    }

    public void setFastForwardDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
    }

    public final void updatePlayPauseImage(boolean isPlaying) {
        Drawable drawable2;
        ImageButton imageButton = this.playPauseButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playPauseButton");
        }
        if (isPlaying) {
            drawable2 = this.pauseDrawable;
            if (drawable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pauseDrawable");
            }
        } else {
            drawable2 = this.playDrawable;
            if (drawable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playDrawable");
            }
        }
        imageButton.setImageDrawable(drawable2);
    }

    public final void setPreviousButtonEnabled(boolean enabled) {
        ImageButton imageButton = this.previousButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        }
        imageButton.setEnabled(enabled);
        this.enabledViews.put(R.id.exomedia_controls_previous_btn, enabled);
    }

    public final void setNextButtonEnabled(boolean enabled) {
        ImageButton imageButton = this.nextButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        }
        imageButton.setEnabled(enabled);
        this.enabledViews.put(R.id.exomedia_controls_next_btn, enabled);
    }

    public void setRewindButtonEnabled(boolean enabled) {
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
    }

    public final void setPreviousButtonRemoved(boolean removed) {
        ImageButton imageButton = this.previousButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        }
        imageButton.setVisibility(removed ? 8 : 0);
    }

    public final void setNextButtonRemoved(boolean removed) {
        ImageButton imageButton = this.nextButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        }
        imageButton.setVisibility(removed ? 8 : 0);
    }

    public void setRewindButtonRemoved(boolean removed) {
    }

    public void setFastForwardButtonRemoved(boolean removed) {
    }

    public void addExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    public void removeExtraView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @Override
    public void show() {
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(true);
    }

    @Override
    public void hide(boolean delayed) {
        if (delayed) {
            this.hideDelayed();
        } else {
            this.hide();
        }
    }

    public final void hide() {
        if (!this.canViewHide || this.isLoading) {
            return;
        }
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(false);
    }

    public final void hideDelayed() {
        this.hideDelayed(this.hideDelay);
    }

    public void hideDelayed(long delay) {
        this.hideDelay = delay;
        if (delay < 0L || !this.canViewHide || this.isLoading) {
            return;
        }
        this.visibilityHandler.postDelayed(new Runnable(this){
            final /* synthetic */ DefaultVideoControls this$0;

            public final void run() {
                this.this$0.hide();
            }
            {
                this.this$0 = defaultVideoControls;
            }
        }, delay);
    }

    public final void setCanHide(boolean canHide) {
        this.canViewHide = canHide;
    }

    protected void registerListeners() {
        ImageButton imageButton = this.playPauseButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playPauseButton");
        }
        imageButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ DefaultVideoControls this$0;

            public final void onClick(View it) {
                this.this$0.onPlayPauseClick();
            }
            {
                this.this$0 = defaultVideoControls;
            }
        });
        ImageButton imageButton2 = this.previousButton;
        if (imageButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        }
        imageButton2.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ DefaultVideoControls this$0;

            public final void onClick(View it) {
                this.this$0.onPreviousClick();
            }
            {
                this.this$0 = defaultVideoControls;
            }
        });
        ImageButton imageButton3 = this.nextButton;
        if (imageButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        }
        imageButton3.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ DefaultVideoControls this$0;

            public final void onClick(View it) {
                this.this$0.onNextClick();
            }
            {
                this.this$0 = defaultVideoControls;
            }
        });
    }

    protected void updateButtonDrawables() {
        this.updateButtonDrawables(R.color.exomedia_default_controls_button_selector);
    }

    protected void updateButtonDrawables(@ColorRes int tintList) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.playDrawable = ResourceExtensionsKt.tintListCompat(context, R.drawable.exomedia_ic_play_arrow_white, tintList);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.pauseDrawable = ResourceExtensionsKt.tintListCompat(context2, R.drawable.exomedia_ic_pause_white, tintList);
        ImageButton imageButton = this.playPauseButton;
        if (imageButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playPauseButton");
        }
        Drawable drawable2 = this.playDrawable;
        if (drawable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playDrawable");
        }
        imageButton.setImageDrawable(drawable2);
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        Drawable previousDrawable = ResourceExtensionsKt.tintListCompat(context3, R.drawable.exomedia_ic_skip_previous_white, tintList);
        ImageButton imageButton2 = this.previousButton;
        if (imageButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousButton");
        }
        imageButton2.setImageDrawable(previousDrawable);
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
        Drawable nextDrawable = ResourceExtensionsKt.tintListCompat(context4, R.drawable.exomedia_ic_skip_next_white, tintList);
        ImageButton imageButton3 = this.nextButton;
        if (imageButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextButton");
        }
        imageButton3.setImageDrawable(nextDrawable);
    }

    protected final void onPlayPauseClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (videoControlsButtonListener == null || !videoControlsButtonListener.onPlayPauseClicked()) {
            this.internalListener.onPlayPauseClicked();
        }
    }

    protected final void onPreviousClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (videoControlsButtonListener == null || !videoControlsButtonListener.onPreviousClicked()) {
            this.internalListener.onPreviousClicked();
        }
    }

    protected final void onNextClick() {
        VideoControlsButtonListener videoControlsButtonListener = this.buttonsListener;
        if (videoControlsButtonListener == null || !videoControlsButtonListener.onNextClicked()) {
            this.internalListener.onNextClicked();
        }
    }

    protected void setup(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)this.getLayoutResource(), (ViewGroup)((ViewGroup)this));
        this.retrieveViews();
        this.registerListeners();
        this.updateButtonDrawables();
    }

    protected void retrieveViews() {
        View view = this.findViewById(R.id.exomedia_controls_current_time);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.exomedia_controls_current_time)");
        this.currentTimeTextView = (TextView)view;
        View view2 = this.findViewById(R.id.exomedia_controls_end_time);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.exomedia_controls_end_time)");
        this.endTimeTextView = (TextView)view2;
        View view3 = this.findViewById(R.id.exomedia_controls_title);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.exomedia_controls_title)");
        this.titleTextView = (TextView)view3;
        View view4 = this.findViewById(R.id.exomedia_controls_sub_title);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.exomedia_controls_sub_title)");
        this.subTitleTextView = (TextView)view4;
        View view5 = this.findViewById(R.id.exomedia_controls_play_pause_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.exomed\u2026_controls_play_pause_btn)");
        this.playPauseButton = (ImageButton)view5;
        View view6 = this.findViewById(R.id.exomedia_controls_previous_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(R.id.exomedia_controls_previous_btn)");
        this.previousButton = (ImageButton)view6;
        View view7 = this.findViewById(R.id.exomedia_controls_next_btn);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(R.id.exomedia_controls_next_btn)");
        this.nextButton = (ImageButton)view7;
        View view8 = this.findViewById(R.id.exomedia_controls_video_loading);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(R.id.exomedia_controls_video_loading)");
        this.loadingProgressBar = (ProgressBar)view8;
    }

    protected final void onVisibilityChanged() {
        block1: {
            block0: {
                if (!this.isVisible()) break block0;
                VideoControlsVisibilityListener videoControlsVisibilityListener = this.visibilityListener;
                if (videoControlsVisibilityListener == null) break block1;
                videoControlsVisibilityListener.onControlsShown();
                break block1;
            }
            VideoControlsVisibilityListener videoControlsVisibilityListener = this.visibilityListener;
            if (videoControlsVisibilityListener == null) break block1;
            videoControlsVisibilityListener.onControlsHidden();
        }
    }

    protected final void updateProgress() {
        block0: {
            VideoView videoView = this.videoView;
            if (videoView == null) break block0;
            VideoView videoView2 = videoView;
            boolean bl = false;
            boolean bl2 = false;
            VideoView it = videoView2;
            boolean bl3 = false;
            this.updateProgress(it.getCurrentPosition(), it.getDuration(), it.getBufferPercentage());
        }
    }

    public DefaultVideoControls(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.visibilityHandler = new Handler();
        this.progressPollRepeater = new Repeater(false, 1, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.isVisible = true;
        this.canViewHide = true;
        this.hideEmptyTextContainer = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.visibilityHandler = new Handler();
        this.progressPollRepeater = new Repeater(false, 1, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.isVisible = true;
        this.canViewHide = true;
        this.hideEmptyTextContainer = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.visibilityHandler = new Handler();
        this.progressPollRepeater = new Repeater(false, 1, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.isVisible = true;
        this.canViewHide = true;
        this.hideEmptyTextContainer = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    public DefaultVideoControls(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.visibilityHandler = new Handler();
        this.progressPollRepeater = new Repeater(false, 1, null);
        this.internalListener = new InternalListener();
        this.enabledViews = new SparseBooleanArray();
        this.hideDelay = DEFAULT_CONTROL_HIDE_DELAY;
        this.isVisible = true;
        this.canViewHide = true;
        this.hideEmptyTextContainer = true;
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.setup(context2);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_CONTROL_HIDE_DELAY = 2000;
        CONTROL_VISIBILITY_ANIMATION_LENGTH = 300L;
    }

    public static final int getDEFAULT_CONTROL_HIDE_DELAY() {
        Companion companion = Companion;
        return DEFAULT_CONTROL_HIDE_DELAY;
    }

    protected static final long getCONTROL_VISIBILITY_ANIMATION_LENGTH() {
        Companion companion = Companion;
        return CONTROL_VISIBILITY_ANIMATION_LENGTH;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsSeekListener;", "Lcom/devbrackets/android/exomedia/ui/listener/VideoControlsButtonListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;)V", "pausedForSeek", "", "getPausedForSeek", "()Z", "setPausedForSeek", "(Z)V", "onFastForwardClicked", "onNextClicked", "onPlayPauseClicked", "onPreviousClicked", "onRewindClicked", "onSeekEnded", "seekTime", "", "onSeekStarted", "library_release"})
    protected class InternalListener
    implements VideoControlsSeekListener,
    VideoControlsButtonListener {
        private boolean pausedForSeek;

        protected final boolean getPausedForSeek() {
            return this.pausedForSeek;
        }

        protected final void setPausedForSeek(boolean bl) {
            this.pausedForSeek = bl;
        }

        @Override
        public boolean onPlayPauseClicked() {
            boolean bl;
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                VideoView videoView2 = videoView;
                boolean bl2 = false;
                boolean bl3 = false;
                VideoView it = videoView2;
                boolean bl4 = false;
                if (it.isPlaying()) {
                    VideoView.pause$default(it, false, 1, null);
                } else {
                    it.start();
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onPreviousClicked() {
            return false;
        }

        @Override
        public boolean onNextClicked() {
            return false;
        }

        @Override
        public boolean onRewindClicked() {
            return false;
        }

        @Override
        public boolean onFastForwardClicked() {
            return false;
        }

        @Override
        public boolean onSeekStarted() {
            if (DefaultVideoControls.this.getVideoView() == null) {
                return false;
            }
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                if (videoView.isPlaying()) {
                    this.pausedForSeek = true;
                    VideoView videoView2 = DefaultVideoControls.this.getVideoView();
                    if (videoView2 != null) {
                        videoView2.pause(true);
                    }
                }
            }
            DefaultVideoControls.this.show();
            return true;
        }

        @Override
        public boolean onSeekEnded(long seekTime) {
            if (DefaultVideoControls.this.getVideoView() == null) {
                return false;
            }
            VideoView videoView = DefaultVideoControls.this.getVideoView();
            if (videoView != null) {
                videoView.seekTo(seekTime);
            }
            if (this.pausedForSeek) {
                this.pausedForSeek = false;
                VideoView videoView2 = DefaultVideoControls.this.getVideoView();
                if (videoView2 != null) {
                    videoView2.start();
                }
                DefaultVideoControls.this.hideDelayed();
            }
            return true;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$Companion;", "", "()V", "CONTROL_VISIBILITY_ANIMATION_LENGTH", "", "getCONTROL_VISIBILITY_ANIMATION_LENGTH$annotations", "getCONTROL_VISIBILITY_ANIMATION_LENGTH", "()J", "DEFAULT_CONTROL_HIDE_DELAY", "", "getDEFAULT_CONTROL_HIDE_DELAY$annotations", "getDEFAULT_CONTROL_HIDE_DELAY", "()I", "library_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getDEFAULT_CONTROL_HIDE_DELAY$annotations() {
        }

        public final int getDEFAULT_CONTROL_HIDE_DELAY() {
            return DEFAULT_CONTROL_HIDE_DELAY;
        }

        @JvmStatic
        protected static /* synthetic */ void getCONTROL_VISIBILITY_ANIMATION_LENGTH$annotations() {
        }

        protected final long getCONTROL_VISIBILITY_ANIMATION_LENGTH() {
            return CONTROL_VISIBILITY_ANIMATION_LENGTH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

