/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.animation;

import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/ui/animation/BottomViewHideShowAnimation;", "Landroid/view/animation/AnimationSet;", "animationView", "Landroid/view/View;", "toVisible", "", "duration", "", "(Landroid/view/View;ZJ)V", "getHideShowDelta", "", "view", "Listener", "library_release"})
public final class BottomViewHideShowAnimation
extends AnimationSet {
    private final View animationView;
    private final boolean toVisible;

    private final int getHideShowDelta(View view) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Object object = view.getContext().getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        Display display = ((WindowManager)object).getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int screenHeight = displayMetrics.heightPixels;
        return screenHeight - view.getTop();
    }

    public BottomViewHideShowAnimation(@NotNull View animationView, boolean toVisible, long duration) {
        Intrinsics.checkNotNullParameter((Object)animationView, (String)"animationView");
        super(false);
        this.animationView = animationView;
        this.toVisible = toVisible;
        float startAlpha = !this.toVisible ? 1 : 0;
        float endAlpha = this.toVisible ? 1 : 0;
        AlphaAnimation alphaAnimation = new AlphaAnimation(startAlpha, endAlpha);
        alphaAnimation.setDuration(duration);
        int startY = this.toVisible ? this.getHideShowDelta(this.animationView) : 0;
        int endY = this.toVisible ? 0 : this.getHideShowDelta(this.animationView);
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)startY, (float)endY);
        translateAnimation.setInterpolator(this.toVisible ? (Interpolator)new LinearOutSlowInInterpolator() : (Interpolator)new FastOutLinearInInterpolator());
        translateAnimation.setDuration(duration);
        this.addAnimation((Animation)alphaAnimation);
        this.addAnimation((Animation)translateAnimation);
        this.setAnimationListener(new Listener());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/devbrackets/android/exomedia/ui/animation/BottomViewHideShowAnimation$Listener;", "Landroid/view/animation/Animation$AnimationListener;", "(Lcom/devbrackets/android/exomedia/ui/animation/BottomViewHideShowAnimation;)V", "onAnimationEnd", "", "animation", "Landroid/view/animation/Animation;", "onAnimationRepeat", "onAnimationStart", "library_release"})
    private final class Listener
    implements Animation.AnimationListener {
        public void onAnimationStart(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            BottomViewHideShowAnimation.this.animationView.setVisibility(0);
        }

        public void onAnimationEnd(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            BottomViewHideShowAnimation.this.animationView.setVisibility(BottomViewHideShowAnimation.this.toVisible ? 0 : 8);
        }

        public void onAnimationRepeat(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        }
    }
}

