/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp.manager.track;

import android.content.Context;
import android.util.ArrayMap;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.nmp.manager.track.RendererTrackInfo;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001a\u0010\u0018\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001aJ\u001e\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/devbrackets/android/exomedia/nmp/manager/track/TrackManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "selectionFactory", "Lcom/google/android/exoplayer2/trackselection/AdaptiveTrackSelection$Factory;", "selector", "Lcom/google/android/exoplayer2/trackselection/DefaultTrackSelector;", "getSelector", "()Lcom/google/android/exoplayer2/trackselection/DefaultTrackSelector;", "clearSelectedTracks", "", "type", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "getAvailableTracks", "", "Lcom/google/android/exoplayer2/source/TrackGroupArray;", "getExoPlayerTracksInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/track/RendererTrackInfo;", "groupIndex", "", "mappedTrackInfo", "Lcom/google/android/exoplayer2/trackselection/MappingTrackSelector$MappedTrackInfo;", "getSelectedTrackIndex", "isRendererEnabled", "", "setRendererEnabled", "enabled", "setSelectedTrack", "trackIndex", "library_release"})
public final class TrackManager {
    private final AdaptiveTrackSelection.Factory selectionFactory;
    @NotNull
    private final DefaultTrackSelector selector;

    @NotNull
    public final DefaultTrackSelector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<RendererType, TrackGroupArray> getAvailableTracks() {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return null;
        }
        ArrayMap trackMap = new ArrayMap();
        RendererType[] $this$forEach$iv = RendererType.values();
        boolean $i$f$forEach = false;
        RendererType[] rendererTypeArray = $this$forEach$iv;
        int n = rendererTypeArray.length;
        for (int i = 0; i < n; ++i) {
            RendererType element$iv;
            RendererType type = element$iv = rendererTypeArray[i];
            boolean bl = false;
            ArrayList<TrackGroup> trackGroups = new ArrayList<TrackGroup>();
            Iterator<Integer> iterator = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo).getIndexes().iterator();
            while (iterator.hasNext()) {
                TrackGroupArray trackGroupArray;
                int exoPlayerTrackIndex = ((Number)iterator.next()).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)mappedTrackInfo.getTrackGroups(exoPlayerTrackIndex), (String)"mappedTrackInfo.getTrack\u2026oups(exoPlayerTrackIndex)");
                int n2 = 0;
                int n3 = trackGroupArray.length;
                while (n2 < n3) {
                    void i2;
                    trackGroups.add(trackGroupArray.get((int)i2));
                    ++i2;
                }
            }
            Collection exoPlayerTrackIndex = trackGroups;
            boolean bl2 = false;
            if (!(!exoPlayerTrackIndex.isEmpty())) continue;
            Collection $this$toTypedArray$iv = trackGroups;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            TrackGroup[] trackGroupArray = thisCollection$iv.toArray(new TrackGroup[0]);
            if (trackGroupArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ((Map)trackMap).put(type, new TrackGroupArray(Arrays.copyOf(trackGroupArray, trackGroupArray.length)));
        }
        return (Map)trackMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RendererTrackInfo getExoPlayerTracksInfo(@NotNull RendererType type, int groupIndex, @Nullable MappingTrackSelector.MappedTrackInfo mappedTrackInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (mappedTrackInfo == null) {
            return new RendererTrackInfo(CollectionsKt.emptyList(), -1, -1);
        }
        ArrayList<Integer> rendererTrackIndexes = new ArrayList<Integer>();
        int rendererTrackIndex = -1;
        int rendererTrackGroupIndex = -1;
        int skippedRenderersGroupsCount = 0;
        int n = 0;
        int n2 = mappedTrackInfo.getRendererCount();
        while (n < n2) {
            void rendererIndex;
            if (type.getExoPlayerTrackType() == mappedTrackInfo.getRendererType((int)rendererIndex)) {
                TrackGroupArray trackGroups;
                rendererTrackIndexes.add((int)rendererIndex);
                Intrinsics.checkNotNullExpressionValue((Object)mappedTrackInfo.getTrackGroups((int)rendererIndex), (String)"mappedTrackInfo.getTrackGroups(rendererIndex)");
                if (skippedRenderersGroupsCount + trackGroups.length <= groupIndex) {
                    skippedRenderersGroupsCount += trackGroups.length;
                } else if (rendererTrackIndex == -1) {
                    rendererTrackIndex = rendererIndex;
                    rendererTrackGroupIndex = groupIndex - skippedRenderersGroupsCount;
                }
            }
            ++rendererIndex;
        }
        return new RendererTrackInfo((List<Integer>)rendererTrackIndexes, rendererTrackIndex, rendererTrackGroupIndex);
    }

    @JvmOverloads
    public final int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, groupIndex, mappedTrackInfo);
        if (tracksInfo.getIndex() == -1) {
            return -1;
        }
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo2 = mappedTrackInfo;
        Intrinsics.checkNotNull((Object)mappedTrackInfo2);
        TrackGroupArray trackGroupArray = mappedTrackInfo2.getTrackGroups(tracksInfo.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)trackGroupArray, (String)"mappedTrackInfo!!.getTrackGroups(tracksInfo.index)");
        TrackGroupArray trackGroupArray2 = trackGroupArray;
        if (trackGroupArray2.length == 0) {
            return -1;
        }
        DefaultTrackSelector.SelectionOverride selectionOverride = this.selector.getParameters().getSelectionOverride(tracksInfo.getIndex(), trackGroupArray2);
        if (selectionOverride == null || selectionOverride.groupIndex != tracksInfo.getGroupIndex() || selectionOverride.length <= 0) {
            return -1;
        }
        return selectionOverride.tracks[0];
    }

    public static /* synthetic */ int getSelectedTrackIndex$default(TrackManager trackManager, RendererType rendererType, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return trackManager.getSelectedTrackIndex(rendererType, n);
    }

    @JvmOverloads
    public final int getSelectedTrackIndex(@NotNull RendererType type) {
        return TrackManager.getSelectedTrackIndex$default(this, type, 0, 2, null);
    }

    public final void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, groupIndex, mappedTrackInfo);
        if (tracksInfo.getIndex() == -1 || mappedTrackInfo == null) {
            return;
        }
        TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(tracksInfo.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)trackGroupArray, (String)"mappedTrackInfo.getTrackGroups(tracksInfo.index)");
        TrackGroupArray trackGroupArray2 = trackGroupArray;
        if (trackGroupArray2.length == 0 || trackGroupArray2.length <= tracksInfo.getGroupIndex()) {
            return;
        }
        TrackGroup trackGroup = trackGroupArray2.get(tracksInfo.getGroupIndex());
        Intrinsics.checkNotNullExpressionValue((Object)trackGroup, (String)"trackGroupArray.get(tracksInfo.groupIndex)");
        TrackGroup group = trackGroup;
        if (group.length <= trackIndex) {
            return;
        }
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.selector.buildUponParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parametersBuilder, (String)"selector.buildUponParameters()");
        DefaultTrackSelector.ParametersBuilder parametersBuilder2 = parametersBuilder;
        Iterator<Integer> iterator = tracksInfo.getIndexes().iterator();
        while (iterator.hasNext()) {
            int rendererTrackIndex = ((Number)iterator.next()).intValue();
            parametersBuilder2.clearSelectionOverrides(rendererTrackIndex);
            if (tracksInfo.getIndex() != rendererTrackIndex) {
                parametersBuilder2.setRendererDisabled(rendererTrackIndex, true);
                continue;
            }
            parametersBuilder2.setSelectionOverride(rendererTrackIndex, trackGroupArray2, new DefaultTrackSelector.SelectionOverride(tracksInfo.getGroupIndex(), new int[]{trackIndex}));
            parametersBuilder2.setRendererDisabled(rendererTrackIndex, false);
        }
        this.selector.setParameters(parametersBuilder2);
    }

    public final void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.selector.buildUponParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parametersBuilder, (String)"selector.buildUponParameters()");
        DefaultTrackSelector.ParametersBuilder parametersBuilder2 = parametersBuilder;
        Iterator<Integer> iterator = tracksInfo.getIndexes().iterator();
        while (iterator.hasNext()) {
            int rendererTrackIndex = ((Number)iterator.next()).intValue();
            parametersBuilder2.setRendererDisabled(rendererTrackIndex, false).clearSelectionOverrides(rendererTrackIndex);
        }
        this.selector.setParameters(parametersBuilder2);
    }

    public final void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
        RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        if (tracksInfo.getIndexes().isEmpty()) {
            return;
        }
        boolean enabledSomething = false;
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.selector.buildUponParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parametersBuilder, (String)"selector.buildUponParameters()");
        DefaultTrackSelector.ParametersBuilder parametersBuilder2 = parametersBuilder;
        Iterator<Integer> iterator = tracksInfo.getIndexes().iterator();
        while (iterator.hasNext()) {
            int rendererTrackIndex = ((Number)iterator.next()).intValue();
            if (!enabled) {
                parametersBuilder2.setRendererDisabled(rendererTrackIndex, true);
                continue;
            }
            DefaultTrackSelector.Parameters parameters = this.selector.getParameters();
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo2 = mappedTrackInfo;
            Intrinsics.checkNotNull((Object)mappedTrackInfo2);
            DefaultTrackSelector.SelectionOverride selectionOverride = parameters.getSelectionOverride(rendererTrackIndex, mappedTrackInfo2.getTrackGroups(rendererTrackIndex));
            if (selectionOverride == null) continue;
            parametersBuilder2.setRendererDisabled(rendererTrackIndex, false);
            enabledSomething = true;
        }
        if (enabled && !enabledSomething) {
            parametersBuilder2.setRendererDisabled(((Number)tracksInfo.getIndexes().get(0)).intValue(), false);
        }
        this.selector.setParameters(parametersBuilder2);
    }

    public final boolean isRendererEnabled(@NotNull RendererType type) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.selector.getCurrentMappedTrackInfo();
            RendererTrackInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
            DefaultTrackSelector.Parameters parameters = this.selector.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"selector.parameters");
            DefaultTrackSelector.Parameters parameters2 = parameters;
            Iterable $this$any$iv = tracksInfo.getIndexes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!(!parameters2.getRendererDisabled(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public TrackManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.selectionFactory = new AdaptiveTrackSelection.Factory();
        this.selector = new DefaultTrackSelector(context, (ExoTrackSelection.Factory)this.selectionFactory);
    }
}

