/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.fallback.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.FloatRange;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.surface.VideoSurface;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.io.IOException;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\b\u00b1\u0001\u00b2\u0001\u00b3\u0001\u00b4\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u0013H\u0016J\u001b\u0010\u0088\u0001\u001a\u00020\u000e2\u0007\u0010\u0087\u0001\u001a\u00020\u00132\u0007\u0010\u0089\u0001\u001a\u00020\u000eH\u0016J\u0012\u0010\u008a\u0001\u001a\u00020@2\u0007\u0010\u0087\u0001\u001a\u00020\u0013H\u0016J\n\u0010\u008b\u0001\u001a\u00030\u0086\u0001H\u0016J\u0011\u0010\u008c\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0004\u001a\u00030\u008d\u0001J\u001a\u0010\u008e\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u008f\u0001\u001a\u00020\u000e2\u0007\u0010\u0090\u0001\u001a\u00020\u000eJ\n\u0010\u0091\u0001\u001a\u00030\u0086\u0001H\u0016J\n\u0010\u0092\u0001\u001a\u00030\u0086\u0001H\u0016J\n\u0010\u0093\u0001\u001a\u00030\u0086\u0001H\u0016J\t\u0010\u0094\u0001\u001a\u00020@H\u0016J\u0013\u0010\u0095\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0096\u0001\u001a\u00020\"H\u0016J\u0013\u0010\u0097\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u000eH\u0016J\u0016\u0010\u0099\u0001\u001a\u00030\u0086\u00012\n\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u0001H\u0016J\u0013\u0010\u009c\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u009d\u0001\u001a\u00020\bH\u0016J\"\u0010\u009e\u0001\u001a\u00030\u0086\u00012\n\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a0\u00012\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u00a2\u0001H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020@2\u0007\u0010\u00a4\u0001\u001a\u00020rH\u0016J\u001c\u0010\u00a5\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u00132\u0007\u0010\u00a6\u0001\u001a\u00020@H\u0016J\u0013\u0010\u00a7\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u00a8\u0001\u001a\u00020\u000eH\u0016J%\u0010\u00a9\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u00132\u0007\u0010\u0089\u0001\u001a\u00020\u000e2\u0007\u0010\u00aa\u0001\u001a\u00020\u000eH\u0016J\u0013\u0010\u00ab\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u00ac\u0001\u001a\u00020\u000eH\u0016J\n\u0010\u00ad\u0001\u001a\u00030\u0086\u0001H\u0016J\n\u0010\u00ae\u0001\u001a\u00030\u0086\u0001H\u0016J\u0013\u0010\u00ae\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u00af\u0001\u001a\u00020@H\u0016J\t\u0010\u00b0\u0001\u001a\u00020@H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0010\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0014\u00102\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010$R(\u00104\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000205\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u00108R\u001e\u00109\u001a\u00060:R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010AR\u0014\u0010B\u001a\u00020@8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010AR\u001b\u0010C\u001a\u00020D8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bE\u0010FR\u001c\u0010I\u001a\u0004\u0018\u00010JX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001c\u0010O\u001a\u0004\u0018\u00010PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001c\u0010U\u001a\u0004\u0018\u00010VX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u001c\u0010[\u001a\u0004\u0018\u00010\\X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R\u001c\u0010a\u001a\u0004\u0018\u00010bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\u001c\u0010g\u001a\u0004\u0018\u00010hX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u001a\u0010m\u001a\u00020@X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010A\"\u0004\bo\u0010pR\u0014\u0010q\u001a\u00020r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bs\u0010tR\u001a\u0010u\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010$\"\u0004\bw\u0010xR\u001e\u0010y\u001a\u00020r8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010t\"\u0004\b{\u0010|R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010~\u001a\u00020r2\u0006\u0010}\u001a\u00020r8V@VX\u0096\u000e\u00a2\u0006\r\u001a\u0004\b\u007f\u0010t\"\u0005\b\u0080\u0001\u0010|R\u001a\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001\u00a8\u0006\u00b5\u0001"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer;", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "context", "Landroid/content/Context;", "surface", "Lcom/devbrackets/android/exomedia/core/video/surface/VideoSurface;", "(Landroid/content/Context;Lcom/devbrackets/android/exomedia/core/video/surface/VideoSurface;)V", "_listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "get_listenerMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "set_listenerMux", "(Lcom/devbrackets/android/exomedia/core/ListenerMux;)V", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Lcom/google/android/exoplayer2/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferedPercent", "getBufferedPercent", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "currentBufferPercent", "getCurrentBufferPercent", "setCurrentBufferPercent", "(I)V", "currentPosition", "", "getCurrentPosition", "()J", "currentState", "Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$State;", "getCurrentState", "()Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$State;", "setCurrentState", "(Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$State;)V", "<anonymous parameter 0>", "Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "headers", "", "getHeaders", "setHeaders", "(Ljava/util/Map;)V", "internalListeners", "Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$InternalListeners;", "getInternalListeners", "()Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$InternalListeners;", "setInternalListeners", "(Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$InternalListeners;)V", "isPlaying", "", "()Z", "isReady", "mediaPlayer", "Landroid/media/MediaPlayer;", "getMediaPlayer", "()Landroid/media/MediaPlayer;", "mediaPlayer$delegate", "Lkotlin/Lazy;", "onBufferingUpdateListener", "Landroid/media/MediaPlayer$OnBufferingUpdateListener;", "getOnBufferingUpdateListener", "()Landroid/media/MediaPlayer$OnBufferingUpdateListener;", "setOnBufferingUpdateListener", "(Landroid/media/MediaPlayer$OnBufferingUpdateListener;)V", "onCompletionListener", "Landroid/media/MediaPlayer$OnCompletionListener;", "getOnCompletionListener", "()Landroid/media/MediaPlayer$OnCompletionListener;", "setOnCompletionListener", "(Landroid/media/MediaPlayer$OnCompletionListener;)V", "onErrorListener", "Landroid/media/MediaPlayer$OnErrorListener;", "getOnErrorListener", "()Landroid/media/MediaPlayer$OnErrorListener;", "setOnErrorListener", "(Landroid/media/MediaPlayer$OnErrorListener;)V", "onInfoListener", "Landroid/media/MediaPlayer$OnInfoListener;", "getOnInfoListener", "()Landroid/media/MediaPlayer$OnInfoListener;", "setOnInfoListener", "(Landroid/media/MediaPlayer$OnInfoListener;)V", "onPreparedListener", "Landroid/media/MediaPlayer$OnPreparedListener;", "getOnPreparedListener", "()Landroid/media/MediaPlayer$OnPreparedListener;", "setOnPreparedListener", "(Landroid/media/MediaPlayer$OnPreparedListener;)V", "onSeekCompleteListener", "Landroid/media/MediaPlayer$OnSeekCompleteListener;", "getOnSeekCompleteListener", "()Landroid/media/MediaPlayer$OnSeekCompleteListener;", "setOnSeekCompleteListener", "(Landroid/media/MediaPlayer$OnSeekCompleteListener;)V", "playRequested", "getPlayRequested", "setPlayRequested", "(Z)V", "playbackSpeed", "", "getPlaybackSpeed", "()F", "requestedSeek", "getRequestedSeek", "setRequestedSeek", "(J)V", "requestedVolume", "getRequestedVolume", "setRequestedVolume", "(F)V", "value", "volume", "getVolume", "setVolume", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "onMediaPrepared", "onSurfaceReady", "Landroid/view/Surface;", "onSurfaceSizeChanged", "width", "height", "pause", "release", "reset", "restart", "seekTo", "milliseconds", "setAudioStreamType", "streamType", "setCaptionListener", "listener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setListenerMux", "listenerMux", "setMedia", "uri", "Landroid/net/Uri;", "mediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "setPlaybackSpeed", "speed", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setWakeLevel", "levelAndFlags", "start", "stop", "clearSurface", "trackSelectionAvailable", "HolderCallback", "InternalListeners", "State", "TextureVideoViewSurfaceListener", "library_release"})
public final class NativeVideoPlayer
implements VideoPlayerApi {
    @Nullable
    private Map<String, String> headers;
    @NotNull
    private State currentState;
    @NotNull
    private final Lazy mediaPlayer$delegate;
    private boolean playRequested;
    private long requestedSeek;
    private int currentBufferPercent;
    @FloatRange(from=0.0, to=1.0)
    private float requestedVolume;
    @Nullable
    private ListenerMux _listenerMux;
    @NotNull
    private InternalListeners internalListeners;
    @Nullable
    private MediaPlayer.OnCompletionListener onCompletionListener;
    @Nullable
    private MediaPlayer.OnPreparedListener onPreparedListener;
    @Nullable
    private MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
    @Nullable
    private MediaPlayer.OnSeekCompleteListener onSeekCompleteListener;
    @Nullable
    private MediaPlayer.OnErrorListener onErrorListener;
    @Nullable
    private MediaPlayer.OnInfoListener onInfoListener;
    @NotNull
    private Context context;
    private final VideoSurface surface;

    @Nullable
    protected final Map<String, String> getHeaders() {
        return this.headers;
    }

    protected final void setHeaders(@Nullable Map<String, String> map) {
        this.headers = map;
    }

    @NotNull
    protected final State getCurrentState() {
        return this.currentState;
    }

    protected final void setCurrentState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.currentState = state;
    }

    @NotNull
    protected final MediaPlayer getMediaPlayer() {
        Lazy lazy = this.mediaPlayer$delegate;
        NativeVideoPlayer nativeVideoPlayer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MediaPlayer)lazy.getValue();
    }

    protected final boolean getPlayRequested() {
        return this.playRequested;
    }

    protected final void setPlayRequested(boolean bl) {
        this.playRequested = bl;
    }

    protected final long getRequestedSeek() {
        return this.requestedSeek;
    }

    protected final void setRequestedSeek(long l) {
        this.requestedSeek = l;
    }

    protected final int getCurrentBufferPercent() {
        return this.currentBufferPercent;
    }

    protected final void setCurrentBufferPercent(int n) {
        this.currentBufferPercent = n;
    }

    protected final float getRequestedVolume() {
        return this.requestedVolume;
    }

    protected final void setRequestedVolume(float f) {
        this.requestedVolume = f;
    }

    @Nullable
    protected final ListenerMux get_listenerMux() {
        return this._listenerMux;
    }

    protected final void set_listenerMux(@Nullable ListenerMux listenerMux2) {
        this._listenerMux = listenerMux2;
    }

    @NotNull
    public final InternalListeners getInternalListeners() {
        return this.internalListeners;
    }

    public final void setInternalListeners(@NotNull InternalListeners internalListeners) {
        Intrinsics.checkNotNullParameter((Object)internalListeners, (String)"<set-?>");
        this.internalListeners = internalListeners;
    }

    @Nullable
    public final MediaPlayer.OnCompletionListener getOnCompletionListener() {
        return this.onCompletionListener;
    }

    public final void setOnCompletionListener(@Nullable MediaPlayer.OnCompletionListener onCompletionListener) {
        this.onCompletionListener = onCompletionListener;
    }

    @Nullable
    public final MediaPlayer.OnPreparedListener getOnPreparedListener() {
        return this.onPreparedListener;
    }

    public final void setOnPreparedListener(@Nullable MediaPlayer.OnPreparedListener onPreparedListener) {
        this.onPreparedListener = onPreparedListener;
    }

    @Nullable
    public final MediaPlayer.OnBufferingUpdateListener getOnBufferingUpdateListener() {
        return this.onBufferingUpdateListener;
    }

    public final void setOnBufferingUpdateListener(@Nullable MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener) {
        this.onBufferingUpdateListener = onBufferingUpdateListener;
    }

    @Nullable
    public final MediaPlayer.OnSeekCompleteListener getOnSeekCompleteListener() {
        return this.onSeekCompleteListener;
    }

    public final void setOnSeekCompleteListener(@Nullable MediaPlayer.OnSeekCompleteListener onSeekCompleteListener) {
        this.onSeekCompleteListener = onSeekCompleteListener;
    }

    @Nullable
    public final MediaPlayer.OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final void setOnErrorListener(@Nullable MediaPlayer.OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Nullable
    public final MediaPlayer.OnInfoListener getOnInfoListener() {
        return this.onInfoListener;
    }

    public final void setOnInfoListener(@Nullable MediaPlayer.OnInfoListener onInfoListener) {
        this.onInfoListener = onInfoListener;
    }

    @Override
    public float getVolume() {
        return this.requestedVolume;
    }

    @Override
    public void setVolume(float value) {
        this.requestedVolume = value;
        this.getMediaPlayer().setVolume(value, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getDuration() {
        ListenerMux listenerMux2 = this._listenerMux;
        if (listenerMux2 == null) return 0L;
        if (!listenerMux2.isPrepared()) return 0L;
        if (!this.isReady()) {
            return 0L;
        }
        long l = this.getMediaPlayer().getDuration();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getCurrentPosition() {
        ListenerMux listenerMux2 = this._listenerMux;
        if (listenerMux2 == null) return 0L;
        if (!listenerMux2.isPrepared()) return 0L;
        if (!this.isReady()) {
            return 0L;
        }
        long l = this.getMediaPlayer().getCurrentPosition();
        return l;
    }

    @Override
    public boolean isPlaying() {
        return this.isReady() && this.getMediaPlayer().isPlaying();
    }

    @Override
    public int getBufferedPercent() {
        return this.currentBufferPercent;
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return null;
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider $noName_0) {
    }

    @Override
    public int getAudioSessionId() {
        return this.getMediaPlayer().getAudioSessionId();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return null;
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return null;
    }

    @Override
    public float getPlaybackSpeed() {
        float f;
        if (Build.VERSION.SDK_INT >= 23) {
            PlaybackParams playbackParams = this.getMediaPlayer().getPlaybackParams();
            Intrinsics.checkNotNullExpressionValue((Object)playbackParams, (String)"mediaPlayer.playbackParams");
            f = playbackParams.getSpeed();
        } else {
            f = 1.0f;
        }
        return f;
    }

    protected final boolean isReady() {
        return this.currentState != State.ERROR && this.currentState != State.IDLE && this.currentState != State.PREPARING;
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux2) {
        Intrinsics.checkNotNullParameter((Object)listenerMux2, (String)"listenerMux");
        this._listenerMux = listenerMux2;
        this.onCompletionListener = listenerMux2;
        this.onCompletionListener = listenerMux2;
        this.onPreparedListener = listenerMux2;
        this.onBufferingUpdateListener = listenerMux2;
        this.onSeekCompleteListener = listenerMux2;
        this.onErrorListener = listenerMux2;
    }

    @Override
    public void start() {
        block1: {
            if (this.isReady()) {
                this.getMediaPlayer().start();
                this.currentState = State.PLAYING;
            }
            this.playRequested = true;
            ListenerMux listenerMux2 = this._listenerMux;
            if (listenerMux2 == null) break block1;
            listenerMux2.setNotifiedCompleted(false);
        }
    }

    @Override
    public void pause() {
        if (this.isReady() && this.getMediaPlayer().isPlaying()) {
            this.getMediaPlayer().pause();
            this.currentState = State.PAUSED;
        }
        this.playRequested = false;
    }

    @Override
    public void seekTo(long milliseconds) {
        if (this.isReady()) {
            this.getMediaPlayer().seekTo((int)milliseconds);
            this.requestedSeek = 0L;
        } else {
            this.requestedSeek = milliseconds;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setPlaybackSpeed(float speed) {
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$apply;
            PlaybackParams playbackParams = new PlaybackParams();
            boolean bl = false;
            boolean bl2 = false;
            PlaybackParams playbackParams2 = playbackParams;
            MediaPlayer mediaPlayer2 = this.getMediaPlayer();
            boolean bl3 = false;
            $this$apply.setSpeed(speed);
            Unit unit = Unit.INSTANCE;
            mediaPlayer2.setPlaybackParams(playbackParams);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener) {
    }

    @Override
    public void stop(boolean clearSurface) {
        block4: {
            this.currentState = State.IDLE;
            if (this.isReady()) {
                try {
                    this.getMediaPlayer().stop();
                }
                catch (Exception e) {
                    Log.d((String)"ContentValues", (String)"stopPlayback: error calling mediaPlayer.stop()", (Throwable)e);
                }
            }
            this.playRequested = false;
            if (!clearSurface) break block4;
            ListenerMux listenerMux2 = this._listenerMux;
            if (listenerMux2 != null) {
                listenerMux2.clearSurfaceWhenReady(this.surface);
            }
        }
    }

    @Override
    public void release() {
        this.currentState = State.IDLE;
        try {
            this.getMediaPlayer().reset();
            this.getMediaPlayer().release();
        }
        catch (Exception e) {
            Log.d((String)"ContentValues", (String)"stopPlayback: error calling mediaPlayer.reset() or mediaPlayer.release()", (Throwable)e);
        }
        this.playRequested = false;
    }

    @Override
    public void reset() {
        this.getMediaPlayer().reset();
    }

    @Override
    public boolean restart() {
        block2: {
            if (this.currentState != State.COMPLETED) {
                return false;
            }
            this.seekTo(0L);
            this.start();
            ListenerMux listenerMux2 = this._listenerMux;
            if (listenerMux2 != null) {
                listenerMux2.setNotifiedPrepared(false);
            }
            ListenerMux listenerMux3 = this._listenerMux;
            if (listenerMux3 == null) break block2;
            listenerMux3.setNotifiedCompleted(false);
        }
        return true;
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return -1;
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return false;
    }

    @Override
    public void setAudioStreamType(int streamType) {
        this.getMediaPlayer().setAudioStreamType(streamType);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.getMediaPlayer().setWakeMode(this.context, levelAndFlags);
    }

    @Override
    public void onMediaPrepared() {
        String string = "Start playback?";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
    }

    public final void onSurfaceSizeChanged(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.requestedSeek != 0L) {
            this.seekTo(this.requestedSeek);
        }
        if (this.playRequested) {
            this.start();
        }
    }

    public final void onSurfaceReady(@NotNull Surface surface2) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this.getMediaPlayer().setSurface(surface2);
        if (this.playRequested) {
            this.start();
        }
    }

    @Override
    public void setMedia(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        if (uri == null) {
            return;
        }
        this.currentBufferPercent = 0;
        try {
            this.getMediaPlayer().reset();
            this.getMediaPlayer().setDataSource(this.context.getApplicationContext(), uri, this.headers);
            this.getMediaPlayer().prepareAsync();
            this.currentState = State.PREPARING;
        }
        catch (IOException ex) {
            Log.w((String)"ContentValues", (String)("Unable to open content: " + uri), (Throwable)ex);
            this.currentState = State.ERROR;
            this.internalListeners.onError(this.getMediaPlayer(), 1, 0);
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)"ContentValues", (String)("Unable to open content: " + uri), (Throwable)ex);
            this.currentState = State.ERROR;
            this.internalListeners.onError(this.getMediaPlayer(), 1, 0);
        }
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    protected final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public NativeVideoPlayer(@NotNull Context context, @NotNull VideoSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this.context = context;
        this.surface = surface2;
        this.currentState = State.IDLE;
        this.mediaPlayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaPlayer>(this){
            final /* synthetic */ NativeVideoPlayer this$0;

            @NotNull
            public final MediaPlayer invoke() {
                MediaPlayer mediaPlayer2 = new MediaPlayer();
                boolean bl = false;
                boolean bl2 = false;
                MediaPlayer $this$apply = mediaPlayer2;
                boolean bl3 = false;
                $this$apply.setOnInfoListener((MediaPlayer.OnInfoListener)this.this$0.getInternalListeners());
                $this$apply.setOnErrorListener((MediaPlayer.OnErrorListener)this.this$0.getInternalListeners());
                $this$apply.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.this$0.getInternalListeners());
                $this$apply.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.this$0.getInternalListeners());
                $this$apply.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this.this$0.getInternalListeners());
                $this$apply.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.this$0.getInternalListeners());
                $this$apply.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this.this$0.getInternalListeners());
                $this$apply.setAudioAttributes(new AudioAttributes.Builder().setContentType(2).build());
                $this$apply.setScreenOnWhilePlaying(true);
                return mediaPlayer2;
            }
            {
                this.this$0 = nativeVideoPlayer;
                super(0);
            }
        }));
        this.requestedVolume = 1.0f;
        this.internalListeners = new InternalListeners();
        this.currentState = State.IDLE;
        VideoSurface videoSurface = this.surface;
        if (videoSurface instanceof SurfaceView) {
            ((SurfaceView)this.surface).getHolder().addCallback((SurfaceHolder.Callback)new HolderCallback());
        } else if (videoSurface instanceof TextureView) {
            ((TextureView)this.surface).setSurfaceTextureListener((TextureView.SurfaceTextureListener)new TextureVideoViewSurfaceListener());
        } else {
            throw (Throwable)new IllegalArgumentException("Surface " + this.surface + " not one of TextureView or SurfaceView");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$State;", "", "(Ljava/lang/String;I)V", "ERROR", "IDLE", "PREPARING", "PREPARED", "PLAYING", "PAUSED", "COMPLETED", "library_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State ERROR;
        public static final /* enum */ State IDLE;
        public static final /* enum */ State PREPARING;
        public static final /* enum */ State PREPARED;
        public static final /* enum */ State PLAYING;
        public static final /* enum */ State PAUSED;
        public static final /* enum */ State COMPLETED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[7];
            State[] stateArray2 = stateArray;
            stateArray[0] = ERROR = new State();
            stateArray[1] = IDLE = new State();
            stateArray[2] = PREPARING = new State();
            stateArray[3] = PREPARED = new State();
            stateArray[4] = PLAYING = new State();
            stateArray[5] = PAUSED = new State();
            stateArray[6] = COMPLETED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$TextureVideoViewSurfaceListener;", "Landroid/view/TextureView$SurfaceTextureListener;", "(Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer;)V", "onSurfaceTextureAvailable", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "", "height", "onSurfaceTextureDestroyed", "", "surface", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "library_release"})
    protected final class TextureVideoViewSurfaceListener
    implements TextureView.SurfaceTextureListener {
        public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            NativeVideoPlayer.this.onSurfaceReady(new Surface(surfaceTexture));
        }

        public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface2, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
            NativeVideoPlayer.this.onSurfaceSizeChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface2) {
            Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
            surface2.release();
            NativeVideoPlayer.this.release();
            return true;
        }

        public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface2) {
            Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$HolderCallback;", "Landroid/view/SurfaceHolder$Callback;", "(Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer;)V", "surfaceChanged", "", "holder", "Landroid/view/SurfaceHolder;", "format", "", "width", "height", "surfaceCreated", "surfaceDestroyed", "library_release"})
    protected final class HolderCallback
    implements SurfaceHolder.Callback {
        public void surfaceCreated(@NotNull SurfaceHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Surface surface2 = holder.getSurface();
            Intrinsics.checkNotNullExpressionValue((Object)surface2, (String)"holder.surface");
            NativeVideoPlayer.this.onSurfaceReady(surface2);
        }

        public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            NativeVideoPlayer.this.onSurfaceSizeChanged(width, height);
        }

        public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            holder.getSurface().release();
            NativeVideoPlayer.this.release();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer$InternalListeners;", "Landroid/media/MediaPlayer$OnBufferingUpdateListener;", "Landroid/media/MediaPlayer$OnErrorListener;", "Landroid/media/MediaPlayer$OnPreparedListener;", "Landroid/media/MediaPlayer$OnCompletionListener;", "Landroid/media/MediaPlayer$OnSeekCompleteListener;", "Landroid/media/MediaPlayer$OnInfoListener;", "Landroid/media/MediaPlayer$OnVideoSizeChangedListener;", "(Lcom/devbrackets/android/exomedia/fallback/video/NativeVideoPlayer;)V", "onBufferingUpdate", "", "mp", "Landroid/media/MediaPlayer;", "percent", "", "onCompletion", "onError", "", "what", "extra", "onInfo", "onPrepared", "onSeekComplete", "onVideoSizeChanged", "width", "height", "library_release"})
    public final class InternalListeners
    implements MediaPlayer.OnBufferingUpdateListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnSeekCompleteListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnVideoSizeChangedListener {
        public void onBufferingUpdate(@NotNull MediaPlayer mp, int percent) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                NativeVideoPlayer.this.setCurrentBufferPercent(percent);
                MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = NativeVideoPlayer.this.getOnBufferingUpdateListener();
                if (onBufferingUpdateListener == null) break block0;
                onBufferingUpdateListener.onBufferingUpdate(mp, percent);
            }
        }

        public void onCompletion(@NotNull MediaPlayer mp) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                NativeVideoPlayer.this.setCurrentState(State.COMPLETED);
                MediaPlayer.OnCompletionListener onCompletionListener = NativeVideoPlayer.this.getOnCompletionListener();
                if (onCompletionListener == null) break block0;
                onCompletionListener.onCompletion(NativeVideoPlayer.this.getMediaPlayer());
            }
        }

        public void onSeekComplete(@NotNull MediaPlayer mp) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                MediaPlayer.OnSeekCompleteListener onSeekCompleteListener = NativeVideoPlayer.this.getOnSeekCompleteListener();
                if (onSeekCompleteListener == null) break block0;
                onSeekCompleteListener.onSeekComplete(mp);
            }
        }

        public boolean onError(@Nullable MediaPlayer mp, int what, int extra) {
            Log.d((String)"ContentValues", (String)("Error: " + what + ',' + extra));
            NativeVideoPlayer.this.setCurrentState(State.ERROR);
            MediaPlayer.OnErrorListener onErrorListener = NativeVideoPlayer.this.getOnErrorListener();
            return onErrorListener != null && onErrorListener.onError(NativeVideoPlayer.this.getMediaPlayer(), what, extra);
        }

        public void onPrepared(@NotNull MediaPlayer mp) {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            NativeVideoPlayer.this.setCurrentState(State.PREPARED);
            MediaPlayer.OnPreparedListener onPreparedListener = NativeVideoPlayer.this.getOnPreparedListener();
            if (onPreparedListener != null) {
                onPreparedListener.onPrepared(NativeVideoPlayer.this.getMediaPlayer());
            }
            NativeVideoPlayer.this.surface.updateVideoSize(mp.getVideoWidth(), mp.getVideoHeight());
            if (NativeVideoPlayer.this.getRequestedSeek() != 0L) {
                NativeVideoPlayer.this.seekTo(NativeVideoPlayer.this.getRequestedSeek());
            }
            if (NativeVideoPlayer.this.getPlayRequested()) {
                NativeVideoPlayer.this.start();
            }
        }

        public boolean onInfo(@NotNull MediaPlayer mp, int what, int extra) {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            MediaPlayer.OnInfoListener onInfoListener = NativeVideoPlayer.this.getOnInfoListener();
            return onInfoListener != null && onInfoListener.onInfo(mp, what, extra);
        }

        public void onVideoSizeChanged(@NotNull MediaPlayer mp, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            NativeVideoPlayer.this.surface.updateVideoSize(mp.getVideoWidth(), mp.getVideoHeight());
        }
    }
}

